/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet;

import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;

public class Facet<C extends FacetConfiguration>
extends UserDataHolderBase
implements UserDataHolder,
Disposable {
    public static final Facet[] EMPTY_ARRAY = new Facet[0];
    private final FacetType myFacetType;
    private final Module myModule;
    private final C myConfiguration;
    private final Facet myUnderlyingFacet;
    private String myName;
    private boolean isDisposed;

    public Facet(FacetType facetType, Module module, String name, C configuration, Facet underlyingFacet) {
        this.myName = name;
        this.myFacetType = facetType;
        this.myModule = module;
        this.myConfiguration = configuration;
        this.myUnderlyingFacet = underlyingFacet;
        Disposer.register((Disposable)this.myModule, (Disposable)this);
    }

    public final FacetType getType() {
        return this.myFacetType;
    }

    public final FacetTypeId getTypeId() {
        return this.myFacetType.getId();
    }

    public final Facet getUnderlyingFacet() {
        return this.myUnderlyingFacet;
    }

    public final C getConfiguration() {
        return this.myConfiguration;
    }

    public final Module getModule() {
        return this.myModule;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public void initFacet() {
    }

    public void disposeFacet() {
    }

    public final void dispose() {
        assert (!this.isDisposed);
        this.isDisposed = true;
        this.disposeFacet();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final String getName() {
        return this.myName;
    }

    final void setName(String name) {
        this.myName = name;
    }

    public String toString() {
        return this.getName() + " (" + this.getModule().getName() + ")";
    }
}

