/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;

public class CapturingProcessAdapter
extends ProcessAdapter {
    private final ProcessOutput myOutput;

    public CapturingProcessAdapter(ProcessOutput output) {
        this.myOutput = output;
    }

    public CapturingProcessAdapter() {
        this(new ProcessOutput());
    }

    public void onTextAvailable(ProcessEvent event, Key outputType) {
        this.addToOutput(event.getText(), outputType);
    }

    protected void addToOutput(String text, Key outputType) {
        if (outputType == ProcessOutputTypes.STDOUT) {
            this.myOutput.appendStdout(text);
        }
        if (outputType == ProcessOutputTypes.STDERR) {
            this.myOutput.appendStderr(text);
        }
    }

    public void processTerminated(ProcessEvent event) {
        this.myOutput.setExitCode(event.getExitCode());
    }

    public ProcessOutput getOutput() {
        return this.myOutput;
    }
}

