/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.BrowserHyperlinkInfo;
import com.intellij.execution.filters.ConsoleFilterProviderEx;
import com.intellij.execution.filters.Filter;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlFilter
implements Filter {
    public static final Pattern URL_PATTERN = Pattern.compile("\\b(mailto:|(news|(ht|f)tp(s?))://|((?<![\\p{L}0-9_.])(www\\.)))[-A-Za-z0-9+&@#/%?=~_|!:,.;]*[-A-Za-z0-9+&@#/%=~_|]");

    @Override
    public Filter.Result applyFilter(String line, int entireLength) {
        int textStartOffset = entireLength - line.length();
        Matcher m = URL_PATTERN.matcher(line);
        if (m.find()) {
            return new Filter.Result(textStartOffset + m.start(), textStartOffset + m.end(), new BrowserHyperlinkInfo(m.group()));
        }
        return null;
    }

    public static class UrlFilterProvider
    implements ConsoleFilterProviderEx {
        @Override
        public Filter[] getDefaultFilters(Project project, GlobalSearchScope scope) {
            return new Filter[]{new UrlFilter()};
        }

        @Override
        public Filter[] getDefaultFilters(Project project) {
            return this.getDefaultFilters(project, GlobalSearchScope.allScope(project));
        }
    }
}

