/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.PathsList;
import java.nio.charset.Charset;

public class SimpleJavaParameters
extends SimpleProgramParameters {
    private Sdk myJdk;
    private String myMainClass;
    private final PathsList myClassPath = new PathsList();
    private final ParametersList myVmParameters = new ParametersList();
    private Charset myCharset = CharsetToolkit.getDefaultSystemCharset();
    private boolean myUseDynamicClasspath;
    private boolean myUseDynamicVMOptions;
    private String myJarPath;

    public String getMainClass() {
        return this.myMainClass;
    }

    public String getJarPath() {
        return this.myJarPath;
    }

    public Sdk getJdk() {
        return this.myJdk;
    }

    public void setJdk(Sdk jdk) {
        this.myJdk = jdk;
    }

    public void setMainClass(String mainClass) {
        this.myMainClass = mainClass;
    }

    public void setJarPath(String jarPath) {
        this.myJarPath = jarPath;
    }

    public PathsList getClassPath() {
        return this.myClassPath;
    }

    public ParametersList getVMParametersList() {
        return this.myVmParameters;
    }

    public Charset getCharset() {
        return this.myCharset;
    }

    public void setCharset(Charset charset) {
        this.myCharset = charset;
    }

    public void setUseDynamicClasspath(boolean useDynamicClasspath) {
        this.myUseDynamicClasspath = useDynamicClasspath;
    }

    public void setUseDynamicVMOptions(boolean useDynamicVMOptions) {
        this.myUseDynamicVMOptions = useDynamicVMOptions;
    }

    public boolean isDynamicVMOptions() {
        return this.myUseDynamicVMOptions;
    }

    public OSProcessHandler createOSProcessHandler() throws ExecutionException {
        Sdk sdk = this.getJdk();
        assert (sdk != null) : "SDK should be defined";
        String exePath = ((JavaSdkType)((Object)sdk.getSdkType())).getVMExecutablePath(sdk);
        final GeneralCommandLine commandLine = JdkUtil.setupJVMCommandLine(exePath, this, this.myUseDynamicClasspath);
        OSProcessHandler processHandler = new OSProcessHandler(commandLine.createProcess(), commandLine.getCommandLineString()){

            public Charset getCharset() {
                return commandLine.getCharset();
            }
        };
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        return processHandler;
    }
}

