/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PlatformUtils;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;

public class EncodingEnvironmentUtil {
    private static final Logger LOG = Logger.getInstance(EncodingEnvironmentUtil.class);
    private static final String LC_ALL = "LC_ALL";
    private static final String LC_CTYPE = "LC_CTYPE";
    private static final String LANG = "LANG";

    public static void setLocaleEnvironmentIfMac(GeneralCommandLine commandLine) {
        if (SystemInfo.isMac && !EncodingEnvironmentUtil.isLocaleDefined(commandLine)) {
            EncodingEnvironmentUtil.setLocaleEnvironment(commandLine.getEnvironment(), commandLine.getCharset());
        }
    }

    @Deprecated
    public static void fixDefaultEncodingIfMac(GeneralCommandLine commandLine, Project project) {
        if (SystemInfo.isMac && !EncodingEnvironmentUtil.isLocaleDefined(commandLine)) {
            EncodingEnvironmentUtil.setLocaleEnvironment(commandLine.getEnvironment(), EncodingEnvironmentUtil.getCharset(project));
        }
    }

    private static void setLocaleEnvironment(Map<String, String> env, Charset charset) {
        env.put(LC_CTYPE, EncodingEnvironmentUtil.formatLocaleValue(charset));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fixed mac locale: " + charset.name());
        }
    }

    private static String formatLocaleValue(Charset charset) {
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        if (language.isEmpty() || country.isEmpty()) {
            return "en_US." + charset.name();
        }
        return language + "_" + country + "." + charset.name();
    }

    @Deprecated
    public static void fixDefaultEncodingIfMac(Map<String, String> env, Project project) {
        if (SystemInfo.isMac && !EncodingEnvironmentUtil.isLocaleDefined(env)) {
            EncodingEnvironmentUtil.setLocaleEnvironment(env, EncodingEnvironmentUtil.getCharset(project));
        }
    }

    public static void setLocaleEnvironmentIfMac(Map<String, String> env, Charset charset) {
        if (SystemInfo.isMac && !EncodingEnvironmentUtil.isLocaleDefined(env)) {
            EncodingEnvironmentUtil.setLocaleEnvironment(env, charset);
        }
    }

    private static boolean isLocaleDefined(GeneralCommandLine commandLine) {
        Map<String, String> env = commandLine.getEnvironment();
        if (EncodingEnvironmentUtil.isLocaleDefined(env)) {
            return true;
        }
        if (commandLine.isPassParentEnvironment()) {
            Map parentEnv;
            Map map = parentEnv = PlatformUtils.isAppCode() ? System.getenv() : EnvironmentUtil.getEnvironmentMap();
            if (EncodingEnvironmentUtil.isLocaleDefined(parentEnv)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isLocaleDefined(Map<String, String> env) {
        return env.containsKey(LC_ALL) || env.containsKey(LC_CTYPE) || env.containsKey(LANG);
    }

    private static Charset getCharset(Project project) {
        Charset charset = project == null ? EncodingManager.getInstance().getDefaultCharset() : EncodingProjectManager.getInstance(project).getDefaultCharset();
        return charset;
    }
}

