/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Comparator;

public abstract class ConfigurationFromContext {
    public static final Comparator<ConfigurationFromContext> COMPARATOR = new Comparator<ConfigurationFromContext>(){

        @Override
        public int compare(ConfigurationFromContext configuration1, ConfigurationFromContext configuration2) {
            if (PsiTreeUtil.isAncestor(configuration1.getSourceElement(), configuration2.getSourceElement(), true)) {
                return 1;
            }
            if (PsiTreeUtil.isAncestor(configuration2.getSourceElement(), configuration1.getSourceElement(), true)) {
                return -1;
            }
            if (!configuration1.isPreferredTo(configuration2)) {
                return 1;
            }
            if (configuration2.shouldReplace(configuration1)) {
                return 1;
            }
            if (!configuration2.isPreferredTo(configuration1)) {
                return -1;
            }
            if (configuration1.shouldReplace(configuration2)) {
                return -1;
            }
            return 0;
        }
    };
    public static final Comparator<ConfigurationFromContext> NAME_COMPARATOR = new Comparator<ConfigurationFromContext>(){

        @Override
        public int compare(ConfigurationFromContext p1, ConfigurationFromContext p2) {
            return p1.getConfigurationType().getDisplayName().compareTo(p2.getConfigurationType().getDisplayName());
        }
    };

    public abstract RunnerAndConfigurationSettings getConfigurationSettings();

    public abstract void setConfigurationSettings(RunnerAndConfigurationSettings var1);

    public RunConfiguration getConfiguration() {
        return this.getConfigurationSettings().getConfiguration();
    }

    public ConfigurationType getConfigurationType() {
        return this.getConfiguration().getType();
    }

    public abstract PsiElement getSourceElement();

    public void onFirstRun(ConfigurationContext context, Runnable startRunnable) {
        startRunnable.run();
    }

    public boolean isPreferredTo(ConfigurationFromContext other) {
        return true;
    }

    public boolean shouldReplace(ConfigurationFromContext other) {
        return false;
    }

    public boolean isProducedBy(Class<? extends RunConfigurationProducer> producerClass) {
        return false;
    }
}

