/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.requests;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;

public class SimpleDiffRequest
extends ContentDiffRequest {
    private final String myTitle;
    private final List<DiffContent> myContents;
    private final List<String> myContentTitles;

    public SimpleDiffRequest(String title, DiffContent content1, DiffContent content2, String title1, String title2) {
        this(title, ContainerUtil.list((Object[])new DiffContent[]{content1, content2}), ContainerUtil.list((Object[])new String[]{title1, title2}));
    }

    public SimpleDiffRequest(String title, DiffContent content1, DiffContent content2, DiffContent content3, String title1, String title2, String title3) {
        this(title, ContainerUtil.list((Object[])new DiffContent[]{content1, content2, content3}), ContainerUtil.list((Object[])new String[]{title1, title2, title3}));
    }

    public SimpleDiffRequest(String title, List<DiffContent> contents, List<String> titles) {
        assert (contents.size() == titles.size());
        this.myTitle = title;
        this.myContents = contents;
        this.myContentTitles = titles;
    }

    @Override
    public List<DiffContent> getContents() {
        return this.myContents;
    }

    @Override
    public List<String> getContentTitles() {
        return this.myContentTitles;
    }

    @Override
    public String getTitle() {
        return this.myTitle;
    }

    @Override
    public void onAssigned(boolean isAssigned) {
        for (DiffContent content : this.myContents) {
            content.onAssigned(isAssigned);
        }
    }
}

