/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;

public abstract class BuildProperties
extends CompositeGenerator {
    public static final String TARGET_ALL = "all";
    public static final String TARGET_BUILD_MODULES = "build.modules";
    public static final String TARGET_CLEAN = "clean";
    public static final String TARGET_INIT = "init";
    public static final String TARGET_REGISTER_CUSTOM_COMPILERS = "register.custom.compilers";
    public static final String DEFAULT_TARGET = "all";
    public static final String PROPERTY_COMPILER_NAME = "compiler.name";
    public static final String PROPERTY_COMPILER_ADDITIONAL_ARGS = "compiler.args";
    public static final String PROPERTY_COMPILER_MAX_MEMORY = "compiler.max.memory";
    public static final String PROPERTY_COMPILER_EXCLUDES = "compiler.excluded";
    public static final String PROPERTY_COMPILER_RESOURCE_PATTERNS = "compiler.resources";
    public static final String PROPERTY_IGNORED_FILES = "ignored.files";
    public static final String PROPERTY_COMPILER_GENERATE_DEBUG_INFO = "compiler.debug";
    public static final String PROPERTY_COMPILER_GENERATE_NO_WARNINGS = "compiler.generate.no.warnings";
    public static final String PROPERTY_PROJECT_JDK_HOME = "project.jdk.home";
    public static final String PROPERTY_PROJECT_JDK_BIN = "project.jdk.bin";
    public static final String PROPERTY_PROJECT_JDK_CLASSPATH = "project.jdk.classpath";
    public static final String PROPERTY_SKIP_TESTS = "skip.tests";
    public static final String PROPERTY_LIBRARIES_PATTERNS = "library.patterns";
    public static final String PROPERTY_IDEA_HOME = "idea.home";
    public static final String PROPERTY_JAVAC2_HOME = "javac2.home";
    public static final String PROPERTY_JAVAC2_CLASSPATH_ID = "javac2.classpath";
    public static final String PROPERTY_INCLUDE_JAVA_RUNTIME_FOR_INSTRUMENTATION = "javac2.instrumentation.includeJavaRuntime";

    protected abstract void createJdkGenerators(Project var1);

    public static Sdk[] getUsedJdks(Project project) {
        Module[] modules;
        HashSet<Sdk> jdks = new HashSet<Sdk>();
        for (Module module : modules = ModuleManager.getInstance(project).getModules()) {
            Sdk jdk = ModuleRootManager.getInstance(module).getSdk();
            if (jdk == null) continue;
            jdks.add(jdk);
        }
        return jdks.toArray(new Sdk[jdks.size()]);
    }

    public static String getJdkPathId(String jdkName) {
        return "jdk.classpath." + BuildProperties.convertName(jdkName);
    }

    public static String getModuleChunkJdkClasspathProperty(String moduleChunkName) {
        return "module.jdk.classpath." + BuildProperties.convertName(moduleChunkName);
    }

    public static String getModuleChunkJdkHomeProperty(String moduleChunkName) {
        return "module.jdk.home." + BuildProperties.convertName(moduleChunkName);
    }

    public static String getModuleChunkJdkBinProperty(String moduleChunkName) {
        return "module.jdk.bin." + BuildProperties.convertName(moduleChunkName);
    }

    public static String getModuleChunkCompilerArgsProperty(String moduleName) {
        return "compiler.args." + BuildProperties.convertName(moduleName);
    }

    public static String getLibraryPathId(String libraryName) {
        return "library." + BuildProperties.convertName(libraryName) + ".classpath";
    }

    public static String getJdkHomeProperty(String jdkName) {
        return "jdk.home." + BuildProperties.convertName(jdkName);
    }

    public static String getJdkBinProperty(String jdkName) {
        return "jdk.bin." + BuildProperties.convertName(jdkName);
    }

    public static String getCompileTargetName(String moduleName) {
        return "compile.module." + BuildProperties.convertName(moduleName);
    }

    public static String getOutputPathProperty(String moduleName) {
        return BuildProperties.convertName(moduleName) + ".output.dir";
    }

    public static String getOutputPathForTestsProperty(String moduleName) {
        return BuildProperties.convertName(moduleName) + ".testoutput.dir";
    }

    public static String getClasspathProperty(String moduleName) {
        return BuildProperties.convertName(moduleName) + ".module.production.classpath";
    }

    public static String getTestClasspathProperty(String moduleName) {
        return BuildProperties.convertName(moduleName) + ".module.classpath";
    }

    public static String getRuntimeClasspathProperty(String moduleName) {
        return BuildProperties.convertName(moduleName) + ".runtime.production.module.classpath";
    }

    public static String getTestRuntimeClasspathProperty(String moduleName) {
        return BuildProperties.convertName(moduleName) + ".runtime.module.classpath";
    }

    public static String getBootClasspathProperty(String moduleName) {
        return BuildProperties.convertName(moduleName) + ".module.bootclasspath";
    }

    public static String getSourcepathProperty(String moduleName) {
        return BuildProperties.convertName(moduleName) + ".module.sourcepath";
    }

    public static String getTestSourcepathProperty(String moduleName) {
        return BuildProperties.convertName(moduleName) + ".module.test.sourcepath";
    }

    public static String getExcludedFromModuleProperty(String moduleName) {
        return "excluded.from.module." + BuildProperties.convertName(moduleName);
    }

    public static String getExcludedFromCompilationProperty(String moduleName) {
        return "excluded.from.compilation." + BuildProperties.convertName(moduleName);
    }

    public static String getProjectBuildFileName(Project project) {
        return BuildProperties.convertName(project.getName());
    }

    public static String getModuleChunkBuildFileName(ModuleChunk chunk) {
        return "module_" + BuildProperties.convertName(chunk.getName());
    }

    public static String getModuleCleanTargetName(String moduleName) {
        return "clean.module." + BuildProperties.convertName(moduleName);
    }

    public static String getModuleChunkBasedirProperty(ModuleChunk chunk) {
        return "module." + BuildProperties.convertName(chunk.getName()) + ".basedir";
    }

    public static String getModuleBasedirProperty(Module module) {
        return "module." + BuildProperties.convertName(module.getName()) + ".basedir";
    }

    public static String getProjectBaseDirProperty() {
        return "basedir";
    }

    public static File getModuleChunkBaseDir(ModuleChunk chunk) {
        return chunk.getBaseDir();
    }

    public static File getProjectBaseDir(Project project) {
        VirtualFile baseDir = project.getBaseDir();
        assert (baseDir != null);
        return VfsUtil.virtualToIoFile(baseDir);
    }

    public static String convertName(String name) {
        return name.replaceAll("\"", "").replaceAll("\\s+", "_").toLowerCase();
    }

    public static String getPathMacroProperty(String pathMacro) {
        return "path.variable." + BuildProperties.convertName(pathMacro);
    }

    public static String propertyRef(String propertyName) {
        return "${" + propertyName + "}";
    }

    public static String propertyRelativePath(String propertyName, String relativePath) {
        return "${" + propertyName + "}/" + relativePath;
    }

    public static File toCanonicalFile(File file) {
        File canonicalFile;
        try {
            canonicalFile = file.getCanonicalFile();
        }
        catch (IOException e) {
            canonicalFile = file;
        }
        return canonicalFile;
    }

    public static String getTempDirForModuleProperty(String moduleName) {
        return "tmp.dir." + BuildProperties.convertName(moduleName);
    }
}

