/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.EverywhereContextType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;

public abstract class TemplateContextType {
    public static final ExtensionPointName<TemplateContextType> EP_NAME = ExtensionPointName.create((String)"com.intellij.liveTemplateContext");
    private final String myContextId;
    private final String myPresentableName;
    private final Class<? extends TemplateContextType> myBaseContextType;

    protected TemplateContextType(String id, String presentableName) {
        this(id, presentableName, EverywhereContextType.class);
    }

    protected TemplateContextType(String id, String presentableName, Class<? extends TemplateContextType> baseContextType) {
        this.myContextId = id;
        this.myPresentableName = presentableName;
        this.myBaseContextType = baseContextType;
    }

    public String getPresentableName() {
        return this.myPresentableName;
    }

    public String getContextId() {
        return this.myContextId;
    }

    public abstract boolean isInContext(PsiFile var1, int var2);

    public boolean isExpandableFromEditor() {
        return true;
    }

    public SyntaxHighlighter createHighlighter() {
        return null;
    }

    public TemplateContextType getBaseContextType() {
        return this.myBaseContextType != null ? (TemplateContextType)EP_NAME.findExtension(this.myBaseContextType) : null;
    }

    public Document createDocument(CharSequence text, Project project) {
        return EditorFactory.getInstance().createDocument(text);
    }
}

