/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;

public abstract class PriorityLocalQuickFixWrapper
implements LocalQuickFix {
    private final LocalQuickFix fix;

    private PriorityLocalQuickFixWrapper(LocalQuickFix fix) {
        this.fix = fix;
    }

    @Override
    public String getName() {
        return this.fix.getName();
    }

    @Override
    public String getFamilyName() {
        return this.fix.getFamilyName();
    }

    @Override
    public void applyFix(Project project, ProblemDescriptor descriptor) {
        this.fix.applyFix(project, descriptor);
    }

    public static LocalQuickFix highPriority(LocalQuickFix fix) {
        return new HighPriorityLocalQuickFixWrapper(fix);
    }

    public static LocalQuickFix normalPriority(LocalQuickFix fix) {
        return new NormalPriorityLocalQuickFixWrapper(fix);
    }

    public static LocalQuickFix lowPriority(LocalQuickFix fix) {
        return new LowPriorityLocalQuickFixWrapper(fix);
    }

    private static class LowPriorityLocalQuickFixWrapper
    extends PriorityLocalQuickFixWrapper
    implements LowPriorityAction {
        protected LowPriorityLocalQuickFixWrapper(LocalQuickFix fix) {
            super(fix);
        }
    }

    private static class NormalPriorityLocalQuickFixWrapper
    extends PriorityLocalQuickFixWrapper {
        protected NormalPriorityLocalQuickFixWrapper(LocalQuickFix fix) {
            super(fix);
        }
    }

    private static class HighPriorityLocalQuickFixWrapper
    extends PriorityLocalQuickFixWrapper
    implements HighPriorityAction {
        protected HighPriorityLocalQuickFixWrapper(LocalQuickFix fix) {
            super(fix);
        }
    }
}

