/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;

public abstract class BaseElementAtCaretIntentionAction
extends BaseIntentionAction {
    private volatile boolean useElementToTheLeft = false;

    @Override
    public final boolean isAvailable(Project project, Editor editor, PsiFile file) {
        if (!file.getManager().isInProject(file)) {
            return false;
        }
        this.useElementToTheLeft = false;
        PsiElement elementToTheRight = BaseElementAtCaretIntentionAction.getElementToTheRight(editor, file);
        if (elementToTheRight != null && this.isAvailable(project, editor, elementToTheRight)) {
            return true;
        }
        PsiElement elementToTheLeft = BaseElementAtCaretIntentionAction.getElementToTheLeft(editor, file);
        if (elementToTheLeft != null && this.isAvailable(project, editor, elementToTheLeft)) {
            this.useElementToTheLeft = true;
            return true;
        }
        return false;
    }

    public abstract boolean isAvailable(Project var1, Editor var2, PsiElement var3);

    @Override
    public final void invoke(Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement element;
        PsiElement psiElement = element = this.useElementToTheLeft ? BaseElementAtCaretIntentionAction.getElementToTheLeft(editor, file) : BaseElementAtCaretIntentionAction.getElementToTheRight(editor, file);
        if (element == null) {
            return;
        }
        this.invoke(project, editor, element);
    }

    public abstract void invoke(Project var1, Editor var2, PsiElement var3) throws IncorrectOperationException;

    protected static PsiElement getElementToTheRight(Editor editor, PsiFile file) {
        return file.findElementAt(editor.getCaretModel().getOffset());
    }

    protected static PsiElement getElementToTheLeft(Editor editor, PsiFile file) {
        return file.findElementAt(editor.getCaretModel().getOffset() - 1);
    }
}

