/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiResolveHelper;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;

public class ClassUtil {
    private ClassUtil() {
    }

    public static PsiMethod getAnyAbstractMethod(PsiClass aClass) {
        PsiMethod[] methods;
        PsiMethod methodToImplement = ClassUtil.getAnyMethodToImplement(aClass);
        if (methodToImplement != null) {
            return methodToImplement;
        }
        for (PsiMethod method : methods = aClass.getMethods()) {
            if (!method.hasModifierProperty("abstract")) continue;
            return method;
        }
        return null;
    }

    public static PsiMethod getAnyMethodToImplement(PsiClass aClass) {
        THashSet alreadyImplemented = new THashSet();
        for (HierarchicalMethodSignature signatureHierarchical : aClass.getVisibleSignatures()) {
            for (PsiMethod superS : signatureHierarchical.getMethod().findSuperMethods()) {
                ClassUtil.add(superS, (Set<PsiMethod>)alreadyImplemented);
            }
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(aClass.getProject()).getResolveHelper();
        for (HierarchicalMethodSignature signatureHierarchical : aClass.getVisibleSignatures()) {
            PsiMethod method = signatureHierarchical.getMethod();
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) continue;
            if (!(aClass.equals(containingClass) || !method.hasModifierProperty("abstract") || method.hasModifierProperty("static") || method.hasModifierProperty("private") || alreadyImplemented.contains(method))) {
                return method;
            }
            List<HierarchicalMethodSignature> superSignatures = signatureHierarchical.getSuperSignatures();
            for (HierarchicalMethodSignature superSignatureHierarchical : superSignatures) {
                PsiMethod superMethod = superSignatureHierarchical.getMethod();
                if (!superMethod.hasModifierProperty("abstract") || resolveHelper.isAccessible(superMethod, method, null)) continue;
                return superMethod;
            }
        }
        return ClassUtil.checkPackageLocalInSuperClass(aClass);
    }

    private static PsiMethod checkPackageLocalInSuperClass(PsiClass aClass) {
        PsiClass superClass = aClass.getSuperClass();
        if (superClass == null) {
            return null;
        }
        if ("java.lang.Object".equals(aClass.getQualifiedName())) {
            return null;
        }
        if (JavaPsiFacade.getInstance(aClass.getProject()).arePackagesTheSame(aClass, superClass)) {
            return null;
        }
        for (HierarchicalMethodSignature methodSignature : superClass.getVisibleSignatures()) {
            PsiMethod method = methodSignature.getMethod();
            if (!method.hasModifierProperty("abstract") || !method.hasModifierProperty("packageLocal")) continue;
            return method;
        }
        return null;
    }

    private static boolean add(PsiMethod method, Set<PsiMethod> alreadyImplemented) {
        boolean already = alreadyImplemented.add(method);
        if (!already) {
            return already;
        }
        for (PsiMethod superSig : method.findSuperMethods()) {
            already &= ClassUtil.add(superSig, alreadyImplemented);
        }
        return already;
    }
}

