/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.JBColor;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Map;
import javax.swing.Icon;

public class HighlightDisplayLevel {
    private static final Map<HighlightSeverity, HighlightDisplayLevel> ourMap = new HashMap();
    public static final HighlightDisplayLevel GENERIC_SERVER_ERROR_OR_WARNING = new HighlightDisplayLevel(HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING, HighlightDisplayLevel.createIconByKey(CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING));
    public static final HighlightDisplayLevel ERROR = new HighlightDisplayLevel(HighlightSeverity.ERROR, HighlightDisplayLevel.createErrorIcon());
    public static final HighlightDisplayLevel WARNING = new HighlightDisplayLevel(HighlightSeverity.WARNING, HighlightDisplayLevel.createIconByKey(CodeInsightColors.WARNINGS_ATTRIBUTES));
    private static final Icon DO_NOT_SHOW_KEY = HighlightDisplayLevel.createIconByKey(TextAttributesKey.createTextAttributesKey("DO_NOT_SHOW"));
    public static final HighlightDisplayLevel DO_NOT_SHOW = new HighlightDisplayLevel(HighlightSeverity.INFORMATION, DO_NOT_SHOW_KEY);
    @Deprecated
    public static final HighlightDisplayLevel INFO = new HighlightDisplayLevel(HighlightSeverity.INFO, DO_NOT_SHOW.getIcon());
    public static final HighlightDisplayLevel WEAK_WARNING = new HighlightDisplayLevel(HighlightSeverity.WEAK_WARNING, HighlightDisplayLevel.createIconByKey(CodeInsightColors.WEAK_WARNING_ATTRIBUTES));
    public static final HighlightDisplayLevel NON_SWITCHABLE_ERROR = new HighlightDisplayLevel(HighlightSeverity.ERROR);
    private Icon myIcon;
    private final HighlightSeverity mySeverity;

    private static Icon createErrorIcon() {
        return new SingleColorIcon(CodeInsightColors.ERRORS_ATTRIBUTES){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                IconUtil.colorize(AllIcons.General.InspectionsError, this.getColor()).paintIcon(c, g, x, y);
            }
        };
    }

    public static HighlightDisplayLevel find(String name) {
        for (Map.Entry<HighlightSeverity, HighlightDisplayLevel> entry : ourMap.entrySet()) {
            HighlightSeverity severity = entry.getKey();
            HighlightDisplayLevel displayLevel = entry.getValue();
            if (!Comparing.strEqual((String)severity.getName(), (String)name)) continue;
            return displayLevel;
        }
        return null;
    }

    public static HighlightDisplayLevel find(HighlightSeverity severity) {
        return ourMap.get(severity);
    }

    public HighlightDisplayLevel(HighlightSeverity severity, Icon icon) {
        this(severity);
        this.myIcon = icon;
        ourMap.put(this.mySeverity, this);
    }

    public HighlightDisplayLevel(HighlightSeverity severity) {
        this.mySeverity = severity;
    }

    public String toString() {
        return this.mySeverity.toString();
    }

    public String getName() {
        return this.mySeverity.getName();
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public HighlightSeverity getSeverity() {
        return this.mySeverity;
    }

    public static void registerSeverity(HighlightSeverity severity, TextAttributesKey key, Icon icon) {
        Icon severityIcon = icon != null ? icon : HighlightDisplayLevel.createIconByKey(key);
        HighlightDisplayLevel level = ourMap.get(severity);
        if (level == null) {
            new HighlightDisplayLevel(severity, severityIcon);
        } else {
            level.myIcon = severityIcon;
        }
    }

    public static int getEmptyIconDim() {
        return JBUI.scale((int)14);
    }

    public static Icon createIconByKey(TextAttributesKey key) {
        return new SingleColorIcon(key);
    }

    public static Icon createIconByMask(Color renderColor) {
        return new MyColorIcon(HighlightDisplayLevel.getEmptyIconDim(), renderColor);
    }

    public static class SingleColorIcon
    implements Icon,
    ColoredIcon {
        private final TextAttributesKey myKey;

        public SingleColorIcon(TextAttributesKey key) {
            this.myKey = key;
        }

        @Override
        public Color getColor() {
            return (Color)ObjectUtils.notNull((Object)this.getColorInner(), (Object)JBColor.GRAY);
        }

        public Color getColorInner() {
            EditorColorsManager manager = EditorColorsManager.getInstance();
            if (manager != null) {
                TextAttributes attributes = manager.getGlobalScheme().getAttributes(this.myKey);
                Color stripe = attributes.getErrorStripeColor();
                if (stripe != null) {
                    return stripe;
                }
                return attributes.getEffectColor();
            }
            TextAttributes defaultAttributes = this.myKey.getDefaultAttributes();
            if (defaultAttributes == null) {
                defaultAttributes = TextAttributes.ERASE_MARKER;
            }
            return defaultAttributes.getErrorStripeColor();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.getColor());
            g.fillRect(x + 2, y + 2, 10, 10);
        }

        @Override
        public int getIconWidth() {
            return HighlightDisplayLevel.getEmptyIconDim();
        }

        @Override
        public int getIconHeight() {
            return HighlightDisplayLevel.getEmptyIconDim();
        }
    }

    public static interface ColoredIcon {
        public Color getColor();
    }

    private static class MyColorIcon
    extends ColorIcon
    implements ColoredIcon {
        public MyColorIcon(int size, Color color) {
            super(size, color);
        }

        @Override
        public Color getColor() {
            return this.getIconColor();
        }
    }
}

