/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AnalysisScope {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.analysis.AnalysisScope");
    public static final int PROJECT = 1;
    public static final int DIRECTORY = 2;
    public static final int FILE = 3;
    public static final int MODULE = 4;
    public static final int INVALID = 6;
    public static final int MODULES = 7;
    public static final int CUSTOM = 8;
    public static final int VIRTUAL_FILES = 9;
    public static final int UNCOMMITTED_FILES = 10;
    private final Project myProject;
    protected List<Module> myModules;
    protected Module myModule;
    protected PsiElement myElement;
    private SearchScope myScope;
    private boolean mySearchInLibraries;
    @Type
    protected int myType;
    private final Set<VirtualFile> myVFiles;
    protected Set<VirtualFile> myFilesSet;
    protected boolean myIncludeTestSource = true;

    public AnalysisScope(Project project) {
        this.myProject = project;
        this.myElement = null;
        this.myModules = null;
        this.myModule = null;
        this.myScope = null;
        this.myType = 1;
        this.myVFiles = null;
    }

    public AnalysisScope(Module module) {
        this.myProject = module.getProject();
        this.myElement = null;
        this.myModules = null;
        this.myScope = null;
        this.myModule = module;
        this.myType = 4;
        this.myVFiles = null;
    }

    public AnalysisScope(Module[] modules) {
        this.myModules = Arrays.asList(modules);
        this.myModule = null;
        this.myProject = modules[0].getProject();
        this.myElement = null;
        this.myScope = null;
        this.myType = 7;
        this.myVFiles = null;
    }

    public AnalysisScope(PsiDirectory psiDirectory) {
        this.myProject = psiDirectory.getProject();
        this.myModules = null;
        this.myModule = null;
        this.myScope = null;
        this.myElement = psiDirectory;
        this.myType = 2;
        this.myVFiles = null;
    }

    public AnalysisScope(PsiFile psiFile) {
        this.myProject = psiFile.getProject();
        this.myElement = psiFile;
        this.myModule = null;
        this.myModules = null;
        this.myScope = null;
        this.myType = 3;
        this.myVFiles = null;
    }

    public AnalysisScope(SearchScope scope, Project project) {
        this.myProject = project;
        this.myElement = null;
        this.myModule = null;
        this.myModules = null;
        this.myScope = scope;
        this.myType = 8;
        this.mySearchInLibraries = scope instanceof GlobalSearchScope && ((GlobalSearchScope)scope).isSearchInLibraries();
        this.myVFiles = null;
    }

    public AnalysisScope(Project project, Collection<VirtualFile> virtualFiles) {
        this.myProject = project;
        this.myElement = null;
        this.myModule = null;
        this.myModules = null;
        this.myScope = null;
        this.myVFiles = new HashSet<VirtualFile>(virtualFiles);
        this.myType = 9;
    }

    public void setScope(SearchScope scope) {
        this.myScope = scope;
    }

    public void setSearchInLibraries(boolean searchInLibraries) {
        this.mySearchInLibraries = searchInLibraries;
    }

    public void setIncludeTestSource(boolean includeTestSource) {
        this.myIncludeTestSource = includeTestSource;
    }

    protected PsiElementVisitor createFileSearcher() {
        final FileIndex fileIndex = this.getFileIndex();
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        return new PsiElementVisitor(){

            @Override
            public void visitFile(PsiFile file) {
                if (AnalysisScope.this.mySearchInLibraries || !(file instanceof PsiCompiledElement)) {
                    VirtualFile virtualFile = file.getVirtualFile();
                    if (virtualFile == null) {
                        return;
                    }
                    if (!AnalysisScope.this.myIncludeTestSource && fileIndex.isInTestSourceContent(virtualFile)) {
                        return;
                    }
                    if (!AnalysisScope.shouldHighlightFile(file)) {
                        return;
                    }
                    AnalysisScope.this.myFilesSet.add(virtualFile);
                    if (indicator != null) {
                        indicator.setText(AnalysisScopeBundle.message("scanning.scope.progress.title", new Object[0]));
                        Project project = file.getProject();
                        String text = AnalysisScope.displayProjectRelativePath(virtualFile, project);
                        indicator.setText2(text);
                    }
                }
            }
        };
    }

    private FileIndex getFileIndex() {
        FileIndex fileIndex = this.myModule != null ? ModuleRootManager.getInstance(this.myModule).getFileIndex() : ProjectRootManager.getInstance(this.myProject).getFileIndex();
        return fileIndex;
    }

    private static String displayProjectRelativePath(VirtualFile virtualFile, Project project) {
        return ProjectUtilCore.displayUrlRelativeToProject(virtualFile, virtualFile.getPresentableUrl(), project, false, false);
    }

    public boolean contains(PsiElement psiElement) {
        VirtualFile file = psiElement.getContainingFile().getVirtualFile();
        return file != null && this.contains(file);
    }

    public boolean contains(VirtualFile file) {
        if (this.myFilesSet == null) {
            if (this.myType == 8) {
                if (this.myScope instanceof GlobalSearchScope) {
                    return ((GlobalSearchScope)this.myScope).contains(file);
                }
                if (this.myScope instanceof LocalSearchScope) {
                    return ((LocalSearchScope)this.myScope).isInScope(file);
                }
            }
            if (this.myType == 1) {
                ProjectFileIndex index = ProjectRootManager.getInstance(this.myProject).getFileIndex();
                return index.isInContent(file) && (this.myIncludeTestSource || !index.isInTestSourceContent(file));
            }
            this.initFilesSet();
        }
        return this.myFilesSet.contains(file);
    }

    protected void initFilesSet() {
        if (this.myType == 3) {
            this.myFilesSet = new HashSet<VirtualFile>(1);
            this.myFilesSet.add(((PsiFileSystemItem)this.myElement).getVirtualFile());
        } else if (this.myType == 2 || this.myType == 1 || this.myType == 7 || this.myType == 4 || this.myType == 8) {
            this.myFilesSet = new HashSet<VirtualFile>();
            this.accept(this.createFileSearcher());
        } else if (this.myType == 9) {
            this.myFilesSet = new HashSet<VirtualFile>();
            final ProjectFileIndex fileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
            Iterator<VirtualFile> iterator = this.myVFiles.iterator();
            while (iterator.hasNext()) {
                VirtualFile vFile = iterator.next();
                VfsUtilCore.visitChildrenRecursively(vFile, new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                    @Override
                    public VirtualFileVisitor.Result visitFileEx(VirtualFile file) {
                        boolean ignored = fileIndex.isExcluded(file);
                        if (!ignored && !file.isDirectory()) {
                            AnalysisScope.this.myFilesSet.add(file);
                        }
                        return ignored ? SKIP_CHILDREN : CONTINUE;
                    }
                });
                if (!vFile.isDirectory()) continue;
                iterator.remove();
            }
        }
    }

    public void accept(PsiElementVisitor visitor) {
        this.accept(visitor, !ApplicationManager.getApplication().isReadAccessAllowed());
    }

    protected void accept(final PsiElementVisitor visitor, final boolean needReadAction) {
        final PsiManager psiManager = PsiManager.getInstance(this.myProject);
        final FileIndex fileIndex = this.getFileIndex();
        this.accept(new Processor<VirtualFile>(){

            public boolean process(VirtualFile file) {
                return AnalysisScope.this.processFile(file, visitor, fileIndex, psiManager, needReadAction);
            }
        });
    }

    public boolean accept(final Processor<VirtualFile> processor) {
        List<Module> modules;
        if (this.myType == 9) {
            if (this.myFilesSet == null) {
                this.initFilesSet();
            }
            ProjectFileIndex index = ProjectRootManager.getInstance(this.myProject).getFileIndex();
            for (VirtualFile file : this.myFilesSet) {
                if (!this.myIncludeTestSource && index.isInTestSourceContent(file) || processor.process((Object)file)) continue;
                return false;
            }
            return true;
        }
        if (this.myScope instanceof GlobalSearchScope) {
            ContentIterator contentIterator;
            final ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
            if (!projectFileIndex.iterateContent(contentIterator = new ContentIterator(){

                @Override
                public boolean processFile(final VirtualFile fileOrDir) {
                    boolean isInScope = ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

                        public Boolean compute() {
                            if (!AnalysisScope.this.myIncludeTestSource && projectFileIndex.isInTestSourceContent(fileOrDir)) {
                                return false;
                            }
                            if (AnalysisScope.isInGeneratedSources(fileOrDir, AnalysisScope.this.myProject)) {
                                return false;
                            }
                            return ((GlobalSearchScope)AnalysisScope.this.myScope).contains(fileOrDir);
                        }
                    });
                    return !isInScope || processor.process((Object)fileOrDir);
                }
            })) {
                return false;
            }
            if (this.mySearchInLibraries) {
                VirtualFile[] libraryRoots;
                for (VirtualFile libraryRoot : libraryRoots = LibraryUtil.getLibraryRoots(this.myProject, false, false)) {
                    if (VfsUtilCore.iterateChildrenRecursively(libraryRoot, VirtualFileFilter.ALL, contentIterator)) continue;
                    return false;
                }
            }
            return true;
        }
        if (this.myScope instanceof LocalSearchScope) {
            PsiElement[] psiElements = ((LocalSearchScope)this.myScope).getScope();
            THashSet files = new THashSet();
            for (final PsiElement element : psiElements) {
                VirtualFile file = ApplicationManager.getApplication().runReadAction(new Computable<VirtualFile>(){

                    public VirtualFile compute() {
                        return PsiUtilCore.getVirtualFile(element);
                    }
                });
                if (file == null || !files.add(file) || processor.process((Object)file)) continue;
                return false;
            }
            return true;
        }
        List<Module> list = modules = this.myModule != null ? Collections.singletonList(this.myModule) : this.myModules;
        if (modules != null) {
            for (Module module : modules) {
                ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance(module).getFileIndex();
                if (moduleFileIndex.iterateContent(new ContentIterator(){

                    @Override
                    public boolean processFile(VirtualFile fileOrDir) {
                        return processor.process((Object)fileOrDir);
                    }
                })) continue;
                return false;
            }
            return true;
        }
        if (this.myElement instanceof PsiDirectory) {
            return this.accept((PsiDirectory)this.myElement, processor);
        }
        if (this.myElement != null) {
            VirtualFile file = ApplicationManager.getApplication().runReadAction(new Computable<VirtualFile>(){

                public VirtualFile compute() {
                    return PsiUtilCore.getVirtualFile(AnalysisScope.this.myElement);
                }
            });
            return file == null || processor.process((Object)file);
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
        return projectFileIndex.iterateContent(new ContentIterator(){

            @Override
            public boolean processFile(VirtualFile fileOrDir) {
                return processor.process((Object)fileOrDir);
            }
        });
    }

    private boolean processFile(VirtualFile fileOrDir, PsiElementVisitor visitor, FileIndex fileIndex, PsiManager psiManager, boolean needReadAction) {
        if (fileOrDir.isDirectory()) {
            return true;
        }
        if (ProjectCoreUtil.isProjectOrWorkspaceFile(fileOrDir)) {
            return true;
        }
        if (fileIndex.isInContent(fileOrDir) && (this.myIncludeTestSource || !fileIndex.isInTestSourceContent(fileOrDir)) && !AnalysisScope.isInGeneratedSources(fileOrDir, psiManager.getProject())) {
            return AnalysisScope.processFile(fileOrDir, visitor, psiManager, needReadAction);
        }
        return true;
    }

    private static boolean isInGeneratedSources(VirtualFile file, Project project) {
        for (GeneratedSourcesFilter filter : (GeneratedSourcesFilter[])GeneratedSourcesFilter.EP_NAME.getExtensions()) {
            if (!filter.isGeneratedSource(file, project)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processFile(VirtualFile fileOrDir, final PsiElementVisitor visitor, final PsiManager psiManager, boolean needReadAction) {
        PsiFile file;
        AccessToken accessToken = ReadAction.start();
        try {
            if (!fileOrDir.isValid()) {
                boolean bl = false;
                return bl;
            }
            file = psiManager.findFile(fileOrDir);
            if (file == null) {
                boolean bl = true;
                return bl;
            }
            if (!AnalysisScope.shouldHighlightFile(file)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            accessToken.finish();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AnalysisScope.doProcessFile(visitor, psiManager, file);
            }
        };
        if (needReadAction && !ApplicationManager.getApplication().isDispatchThread()) {
            AnalysisScope.commitAndRunInSmartMode(runnable, psiManager.getProject());
        } else {
            runnable.run();
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        return indicator == null || !indicator.isCanceled();
    }

    private static void commitAndRunInSmartMode(final Runnable runnable, Project project) {
        DumbService dumbService;
        boolean passed;
        do {
            dumbService = DumbService.getInstance(project);
            dumbService.waitForSmartMode();
        } while (!(passed = PsiDocumentManager.getInstance(project).commitAndRunReadAction(new Computable<Boolean>(){

            public Boolean compute() {
                if (dumbService.isDumb()) {
                    return false;
                }
                runnable.run();
                return true;
            }
        }).booleanValue()));
    }

    protected static boolean shouldHighlightFile(PsiFile file) {
        return ProblemHighlightFilter.shouldProcessFileInBatch(file);
    }

    public boolean containsModule(Module module) {
        switch (this.myType) {
            case 1: {
                return true;
            }
            case 4: {
                return this.myModule == module;
            }
            case 7: {
                return this.myModules.contains(module);
            }
        }
        return false;
    }

    private static void doProcessFile(PsiElementVisitor visitor, PsiManager psiManager, PsiFile file) {
        file.accept(visitor);
        psiManager.dropResolveCaches();
        InjectedLanguageManager.getInstance(file.getProject()).dropFileCaches(file);
    }

    protected boolean accept(PsiDirectory dir, final Processor<VirtualFile> processor) {
        final Project project = dir.getProject();
        final ProjectFileIndex index = ProjectRootManager.getInstance(project).getFileIndex();
        final boolean processGeneratedFiles = AnalysisScope.isInGeneratedSources(dir.getVirtualFile(), project);
        return VfsUtilCore.iterateChildrenRecursively(dir.getVirtualFile(), VirtualFileFilter.ALL, new ContentIterator(){

            @Override
            public boolean processFile(VirtualFile fileOrDir) {
                if (!AnalysisScope.this.myIncludeTestSource && index.isInTestSourceContent(fileOrDir)) {
                    return true;
                }
                if (!processGeneratedFiles && AnalysisScope.isInGeneratedSources(fileOrDir, project)) {
                    return true;
                }
                if (!fileOrDir.isDirectory()) {
                    return processor.process((Object)fileOrDir);
                }
                return true;
            }
        });
    }

    public boolean isValid() {
        if (this.myModules != null) {
            for (Module module : this.myModules) {
                if (!module.isDisposed()) continue;
                return false;
            }
            return true;
        }
        if (this.myModule != null) {
            return !this.myModule.isDisposed();
        }
        if (this.myElement != null) {
            return this.myElement.isValid();
        }
        return this.myType == 9 || this.myType == 8 || this.myType == 1;
    }

    @Type
    public int getScopeType() {
        return this.myType;
    }

    public String getDisplayName() {
        switch (this.myType) {
            case 8: {
                return this.myScope.getDisplayName();
            }
            case 4: {
                return AnalysisScopeBundle.message("scope.option.module", AnalysisScope.pathToName(this.myModule.getModuleFilePath()));
            }
            case 7: {
                String modules = StringUtil.join(this.myModules, (Function)new Function<Module, String>(){

                    public String fun(Module module) {
                        return AnalysisScope.pathToName(module.getModuleFilePath());
                    }
                }, (String)", ");
                return AnalysisScopeBundle.message("scope.module.list", modules, this.myModules.size());
            }
            case 1: {
                return AnalysisScopeBundle.message("scope.project", this.myProject.getName());
            }
            case 3: {
                return AnalysisScopeBundle.message("scope.file", AnalysisScope.getPresentableUrl((PsiFileSystemItem)this.myElement));
            }
            case 2: {
                return AnalysisScopeBundle.message("scope.directory", AnalysisScope.getPresentableUrl((PsiFileSystemItem)this.myElement));
            }
            case 9: {
                return AnalysisScopeBundle.message("scope.virtual.files", new Object[0]);
            }
        }
        return "";
    }

    private static String getPresentableUrl(PsiFileSystemItem element) {
        VirtualFile virtualFile = element.getVirtualFile();
        assert (virtualFile != null) : element;
        return virtualFile.getPresentableUrl();
    }

    public String getShortenName() {
        switch (this.myType) {
            case 8: {
                return this.myScope.getDisplayName();
            }
            case 4: {
                return AnalysisScopeBundle.message("scope.option.module", this.myModule.getName());
            }
            case 7: {
                String modules = StringUtil.join(this.myModules, (Function)new Function<Module, String>(){

                    public String fun(Module module) {
                        return module.getName();
                    }
                }, (String)", ");
                return AnalysisScopeBundle.message("scope.module.list", modules, this.myModules.size());
            }
            case 1: {
                return AnalysisScopeBundle.message("scope.project", this.myProject.getName());
            }
            case 3: {
                String relativePath = this.getRelativePath();
                return relativePath != null ? AnalysisScopeBundle.message("scope.file", relativePath) : "Current File";
            }
            case 2: {
                String relativeDirPath = this.getRelativePath();
                return relativeDirPath != null ? AnalysisScopeBundle.message("scope.directory", relativeDirPath) : "Current Directory";
            }
            case 9: {
                return AnalysisScopeBundle.message("scope.selected.files", new Object[0]);
            }
        }
        return "";
    }

    private String getRelativePath() {
        String relativePath = AnalysisScope.displayProjectRelativePath(((PsiFileSystemItem)this.myElement).getVirtualFile(), this.myElement.getProject());
        if (relativePath.length() > 100) {
            return null;
        }
        return relativePath;
    }

    private static String pathToName(String path) {
        File file = new File(path);
        return FileUtil.getNameWithoutExtension((File)file);
    }

    public int getFileCount() {
        ProgressIndicator indicator;
        if (this.myFilesSet == null) {
            this.initFilesSet();
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
            indicator.setText("");
            indicator.setText2("");
        }
        return this.myFilesSet.size();
    }

    @Deprecated
    public boolean checkScopeWritable(Project project) {
        if (this.myFilesSet == null) {
            this.initFilesSet();
        }
        return !FileModificationService.getInstance().prepareVirtualFilesForWrite(project, this.myFilesSet);
    }

    public void invalidate() {
        if (this.myType == 9) {
            Iterator<VirtualFile> i = this.myVFiles.iterator();
            while (i.hasNext()) {
                VirtualFile virtualFile = i.next();
                if (virtualFile != null && virtualFile.isValid()) continue;
                i.remove();
            }
        } else {
            this.myFilesSet = null;
        }
    }

    public boolean containsSources(boolean isTest) {
        if (this.myElement != null) {
            VirtualFile file;
            Project project = this.myElement.getProject();
            ProjectFileIndex index = ProjectRootManager.getInstance(project).getFileIndex();
            if (this.myElement instanceof PsiDirectory) {
                VirtualFile directory = ((PsiFileSystemItem)this.myElement).getVirtualFile();
                if (index.isInSourceContent(directory)) {
                    return isTest ? index.isInTestSourceContent(directory) : !index.isInTestSourceContent(directory);
                }
            } else if (this.myElement instanceof PsiFile && (file = ((PsiFileSystemItem)this.myElement).getVirtualFile()) != null) {
                return isTest ? index.isInTestSourceContent(file) : !index.isInTestSourceContent(file);
            }
        }
        return true;
    }

    public AnalysisScope getNarrowedComplementaryScope(Project defaultProject) {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(defaultProject).getFileIndex();
        HashSet<Module> modules = new HashSet<Module>();
        if (this.myType == 3 || this.myType == 2) {
            VirtualFile vFile = ((PsiFileSystemItem)this.myElement).getVirtualFile();
            modules.addAll(AnalysisScope.getAllInterestingModules(fileIndex, vFile));
        } else if (this.myType == 4) {
            modules.add(this.myModule);
        } else if (this.myType == 7) {
            modules.addAll(this.myModules);
        }
        return AnalysisScope.collectScopes(defaultProject, modules);
    }

    protected static AnalysisScope collectScopes(Project defaultProject, HashSet<Module> modules) {
        if (modules.isEmpty()) {
            return new AnalysisScope(defaultProject);
        }
        Module[] allModules = ModuleManager.getInstance(defaultProject).getModules();
        HashSet<Module> modulesToAnalyze = new HashSet<Module>();
        for (Module module : modules) {
            modulesToAnalyze.addAll(AnalysisScope.getDirectBackwardDependencies(module, allModules));
            modulesToAnalyze.addAll(AnalysisScope.getExportBackwardDependencies(module, allModules));
            modulesToAnalyze.add(module);
        }
        return new AnalysisScope(modulesToAnalyze.toArray(new Module[modulesToAnalyze.size()]));
    }

    private static Set<Module> getExportBackwardDependencies(Module fromModule, Module[] allModules) {
        HashSet<Module> result = new HashSet<Module>();
        for (Module module : allModules) {
            OrderEntry[] orderEntries;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            for (OrderEntry orderEntry : orderEntries = moduleRootManager.getOrderEntries()) {
                if (!(orderEntry instanceof ModuleOrderEntry) || !((ExportableOrderEntry)orderEntry).isExported() || fromModule != ((ModuleOrderEntry)orderEntry).getModule()) continue;
                result.addAll(AnalysisScope.getDirectBackwardDependencies(module, allModules));
            }
        }
        return result;
    }

    private static Set<Module> getDirectBackwardDependencies(Module module, Module[] allModules) {
        HashSet<Module> result = new HashSet<Module>();
        for (Module dependency : allModules) {
            if (ArrayUtil.find((Object[])ModuleRootManager.getInstance(dependency).getDependencies(), (Object)module) <= -1) continue;
            result.add(dependency);
        }
        return result;
    }

    protected static HashSet<Module> getAllInterestingModules(ProjectFileIndex fileIndex, VirtualFile vFile) {
        HashSet<Module> modules = new HashSet<Module>();
        if (fileIndex.isInLibrarySource(vFile) || fileIndex.isInLibraryClasses(vFile)) {
            for (OrderEntry orderEntry : fileIndex.getOrderEntriesForFile(vFile)) {
                modules.add(orderEntry.getOwnerModule());
            }
        } else {
            modules.add(fileIndex.getModuleForFile(vFile));
        }
        return modules;
    }

    public SearchScope toSearchScope() {
        switch (this.myType) {
            case 8: {
                return this.myScope;
            }
            case 2: {
                return GlobalSearchScopesCore.directoryScope((PsiDirectory)this.myElement, true);
            }
            case 3: {
                return new LocalSearchScope(this.myElement);
            }
            case 6: {
                return LocalSearchScope.EMPTY;
            }
            case 4: {
                GlobalSearchScope moduleScope = GlobalSearchScope.moduleScope(this.myModule);
                return this.myIncludeTestSource ? moduleScope : GlobalSearchScope.notScope(GlobalSearchScopesCore.projectTestScope(this.myModule.getProject())).intersectWith(moduleScope);
            }
            case 7: {
                SearchScope scope = GlobalSearchScope.EMPTY_SCOPE;
                for (Module module : this.myModules) {
                    scope = ((SearchScope)scope).union(GlobalSearchScope.moduleScope(module));
                }
                return scope;
            }
            case 1: {
                return this.myIncludeTestSource ? GlobalSearchScope.projectScope(this.myProject) : GlobalSearchScopesCore.projectProductionScope(this.myProject);
            }
            case 9: {
                return new GlobalSearchScope(){

                    @Override
                    public boolean contains(VirtualFile file) {
                        return AnalysisScope.this.myFilesSet.contains(file);
                    }

                    @Override
                    public int compare(VirtualFile file1, VirtualFile file2) {
                        return 0;
                    }

                    @Override
                    public boolean isSearchInModuleContent(Module aModule) {
                        return false;
                    }

                    @Override
                    public boolean isSearchInLibraries() {
                        return false;
                    }
                };
            }
        }
        LOG.error("invalid type " + this.myType);
        return GlobalSearchScope.EMPTY_SCOPE;
    }

    public boolean isAnalyzeTestsByDefault() {
        switch (this.myType) {
            case 2: {
                return ProjectRootManager.getInstance(this.myElement.getProject()).getFileIndex().isInTestSourceContent(((PsiDirectory)this.myElement).getVirtualFile());
            }
            case 3: {
                PsiFile containingFile = this.myElement.getContainingFile();
                return ProjectRootManager.getInstance(this.myElement.getProject()).getFileIndex().isInTestSourceContent(containingFile.getVirtualFile());
            }
            case 4: {
                return AnalysisScope.isTestOnly(this.myModule);
            }
            case 7: {
                for (Module module : this.myModules) {
                    if (AnalysisScope.isTestOnly(module)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isTestOnly(Module module) {
        return ModuleRootManager.getInstance(module).getSourceRootUrls(false).length == 0;
    }

    public boolean isIncludeTestSource() {
        return this.myIncludeTestSource;
    }

    public static @interface Type {
    }
}

