/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.util;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.zmlx.hg4idea.HgChange;
import org.zmlx.hg4idea.HgContentRevision;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgFileStatusEnum;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.command.HgRemoveCommand;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.ShellCommand;
import org.zmlx.hg4idea.execution.ShellCommandException;
import org.zmlx.hg4idea.provider.HgChangeProvider;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgReferenceValidator;

public abstract class HgUtil {
    public static final Pattern URL_WITH_PASSWORD = Pattern.compile("(?:.+)://(?:.+)(:.+)@(?:.+)");
    public static final int MANY_FILES = 100;
    private static final Logger LOG = Logger.getInstance(HgUtil.class);
    public static final String DOT_HG = ".hg";
    public static final String TIP_REFERENCE = "tip";
    public static final String HEAD_REFERENCE = "HEAD";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyResourceToTempFile(String basename, String extension) throws IOException {
        InputStream in = HgUtil.class.getClassLoader().getResourceAsStream("python/" + basename + extension);
        File tempFile = FileUtil.createTempFile((String)basename, (String)extension);
        byte[] buffer = new byte[4096];
        OutputStream out = null;
        try {
            int bytesRead;
            out = new FileOutputStream(tempFile, false);
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {}
        }
        try {
            in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        tempFile.deleteOnExit();
        return tempFile;
    }

    public static void markDirectoryDirty(Project project, VirtualFile file) throws InvocationTargetException, InterruptedException {
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{file});
        VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(file);
    }

    public static void markFileDirty(final Project project, final VirtualFile file) throws InvocationTargetException, InterruptedException {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file);
            }
        });
        HgUtil.runWriteActionAndWait(new Runnable(){

            @Override
            public void run() {
                file.refresh(true, false);
            }
        });
    }

    public static void runWriteActionAndWait(final Runnable runnable) throws InvocationTargetException, InterruptedException {
        GuiUtils.runOrInvokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(runnable);
            }
        });
    }

    public static void runWriteActionLater(final Runnable runnable) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(runnable);
            }
        });
    }

    public static File getTemporaryPythonFile(String base) {
        try {
            final File file = HgUtil.copyResourceToTempFile(base, ".py");
            final String fileName = file.getName();
            ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

                @Override
                public void run() {
                    File[] files = file.getParentFile().listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.startsWith(fileName);
                        }
                    });
                    if (files != null) {
                        for (File file1 : files) {
                            file1.delete();
                        }
                    }
                }
            });
            return file;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void removeFilesFromVcs(Project project, List<FilePath> files) {
        HgRemoveCommand command = new HgRemoveCommand(project);
        for (FilePath filePath : files) {
            VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)project, (FilePath)filePath);
            if (vcsRoot == null) continue;
            command.execute(new HgFile(vcsRoot, filePath));
        }
    }

    public static VirtualFile getNearestHgRoot(VirtualFile dir) {
        for (VirtualFile currentDir = dir; currentDir != null; currentDir = currentDir.getParent()) {
            if (!HgUtil.isHgRoot(currentDir)) continue;
            return currentDir;
        }
        return null;
    }

    public static boolean isHgRoot(VirtualFile dir) {
        return dir != null && dir.findChild(DOT_HG) != null;
    }

    public static VirtualFile getHgRootOrNull(Project project, FilePath filePath) {
        if (project == null) {
            return HgUtil.getNearestHgRoot(VcsUtil.getVirtualFile((String)filePath.getPath()));
        }
        return HgUtil.getNearestHgRoot(VcsUtil.getVcsRootFor((Project)project, (FilePath)filePath));
    }

    public static Set<VirtualFile> hgRoots(Project project, Collection<FilePath> filePaths) {
        HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
        for (FilePath path : filePaths) {
            ContainerUtil.addIfNotNull(roots, (Object)HgUtil.getHgRootOrNull(project, path));
        }
        return roots;
    }

    public static VirtualFile getHgRootOrNull(Project project, VirtualFile file) {
        return HgUtil.getHgRootOrNull(project, VcsUtil.getFilePath((String)file.getPath()));
    }

    public static VirtualFile getHgRootOrThrow(Project project, FilePath filePath) throws VcsException {
        VirtualFile vf = HgUtil.getHgRootOrNull(project, filePath);
        if (vf == null) {
            throw new VcsException(HgVcsMessages.message("hg4idea.exception.file.not.under.hg", filePath.getPresentableUrl()));
        }
        return vf;
    }

    public static VirtualFile getHgRootOrThrow(Project project, VirtualFile file) throws VcsException {
        return HgUtil.getHgRootOrThrow(project, VcsUtil.getFilePath((String)file.getPath()));
    }

    public static VirtualFile getSelectedFile(Project project) {
        Editor editor;
        FileEditorManager manager;
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
        FileEditor fileEditor = StatusBarUtil.getCurrentFileEditor((Project)project, (StatusBar)statusBar);
        VirtualFile result = null;
        if (fileEditor != null && fileEditor instanceof TextEditor) {
            Document document = ((TextEditor)fileEditor).getEditor().getDocument();
            result = FileDocumentManager.getInstance().getFile(document);
        }
        if (result == null && (manager = FileEditorManager.getInstance((Project)project)) != null && (editor = manager.getSelectedTextEditor()) != null) {
            result = FileDocumentManager.getInstance().getFile(editor.getDocument());
        }
        return result;
    }

    public static VirtualFile getRootForSelectedFile(Project project) {
        VirtualFile selectedFile = HgUtil.getSelectedFile(project);
        if (selectedFile != null) {
            return HgUtil.getHgRootOrNull(project, selectedFile);
        }
        return null;
    }

    public static String getNewBranchNameFromUser(HgRepository repository, String dialogTitle) {
        return Messages.showInputDialog((Project)repository.getProject(), (String)"Enter the name of new branch:", (String)dialogTitle, (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)HgReferenceValidator.newInstance(repository));
    }

    public static boolean isMergeInProgress(Project project, VirtualFile repository) {
        return new HgWorkingCopyRevisionsCommand(project).parents(repository).size() > 1;
    }

    public static Map<VirtualFile, List<String>> getRelativePathsByRepository(Collection<HgFile> hgFiles) {
        HashMap<VirtualFile, List<String>> map = new HashMap<VirtualFile, List<String>>();
        if (hgFiles == null) {
            return map;
        }
        for (HgFile file : hgFiles) {
            VirtualFile repo = file.getRepo();
            ArrayList<String> files = (ArrayList<String>)map.get(repo);
            if (files == null) {
                files = new ArrayList<String>();
                map.put(repo, files);
            }
            files.add(file.getRelativePath());
        }
        return map;
    }

    public static HgFile getFileNameInTargetRevision(Project project, HgRevisionNumber vcsRevisionNumber, HgFile localHgFile) {
        HgStatusCommand statCommand = new HgStatusCommand.Builder(false).copySource(true).baseRevision(vcsRevisionNumber).build(project);
        Set<HgChange> changes = statCommand.execute(localHgFile.getRepo(), Collections.singletonList(localHgFile.toFilePath()));
        for (HgChange change : changes) {
            if (!change.afterFile().equals(localHgFile)) continue;
            return change.beforeFile();
        }
        return localHgFile;
    }

    public static FilePath getOriginalFileName(FilePath filePath, ChangeListManager changeListManager) {
        Change change = changeListManager.getChange(filePath);
        if (change == null) {
            return filePath;
        }
        FileStatus status = change.getFileStatus();
        if (status == HgChangeProvider.COPIED || status == HgChangeProvider.RENAMED) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            assert (beforeRevision != null) : "If a file's status is copied or renamed, there must be an previous version";
            return beforeRevision.getFile();
        }
        return filePath;
    }

    public static List<VirtualFile> getHgRepositories(Project project) {
        LinkedList<VirtualFile> repos = new LinkedList<VirtualFile>();
        for (VcsRoot root : ProjectLevelVcsManager.getInstance((Project)project).getAllVcsRoots()) {
            if (!"hg4idea".equals(root.getVcs().getName())) continue;
            repos.add(root.getPath());
        }
        return repos;
    }

    public static Map<VirtualFile, Collection<VirtualFile>> sortByHgRoots(Project project, Collection<VirtualFile> files) {
        HashMap<VirtualFile, Collection<VirtualFile>> sorted = new HashMap<VirtualFile, Collection<VirtualFile>>();
        HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(project);
        for (VirtualFile file : files) {
            HgRepository repo = (HgRepository)repositoryManager.getRepositoryForFile(file);
            if (repo == null) continue;
            HashSet<VirtualFile> filesForRoot = (HashSet<VirtualFile>)sorted.get(repo.getRoot());
            if (filesForRoot == null) {
                filesForRoot = new HashSet<VirtualFile>();
                sorted.put(repo.getRoot(), filesForRoot);
            }
            filesForRoot.add(file);
        }
        return sorted;
    }

    public static Map<VirtualFile, Collection<FilePath>> groupFilePathsByHgRoots(Project project, Collection<FilePath> files) {
        HashMap<VirtualFile, Collection<FilePath>> sorted = new HashMap<VirtualFile, Collection<FilePath>>();
        if (project.isDisposed()) {
            return sorted;
        }
        HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(project);
        for (FilePath file : files) {
            HgRepository repo = (HgRepository)repositoryManager.getRepositoryForFile(file);
            if (repo == null) continue;
            HashSet<FilePath> filesForRoot = (HashSet<FilePath>)sorted.get(repo.getRoot());
            if (filesForRoot == null) {
                filesForRoot = new HashSet<FilePath>();
                sorted.put(repo.getRoot(), filesForRoot);
            }
            filesForRoot.add(file);
        }
        return sorted;
    }

    public static void executeOnPooledThreadIfNeeded(Runnable runnable) {
        if (EventQueue.isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().executeOnPooledThread(runnable);
        } else {
            runnable.run();
        }
    }

    public static VirtualFile convertToLocalVirtualFile(VirtualFile file) {
        if (!(file instanceof AbstractVcsVirtualFile)) {
            return file;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile resultFile = lfs.findFileByPath(file.getPath());
        if (resultFile == null) {
            resultFile = lfs.refreshAndFindFileByPath(file.getPath());
        }
        return resultFile;
    }

    public static List<Change> getDiff(Project project, VirtualFile root, FilePath path, HgFileRevision rev1, HgFileRevision rev2) {
        HgStatusCommand statusCommand;
        HgRevisionNumber revNumber1 = null;
        if (rev1 != null) {
            revNumber1 = rev1.getRevisionNumber();
            statusCommand = new HgStatusCommand.Builder(true).ignored(false).unknown(false).copySource(false).baseRevision(revNumber1).targetRevision(rev2 != null ? rev2.getRevisionNumber() : null).build(project);
        } else {
            LOG.assertTrue(rev2 != null, (Object)("revision1 and revision2 can't both be null. Path: " + path));
            statusCommand = new HgStatusCommand.Builder(true).ignored(false).unknown(false).copySource(false).baseRevision(rev2.getRevisionNumber()).build(project);
        }
        Set<HgChange> hgChanges = statusCommand.execute(root, Collections.singleton(path));
        ArrayList<Change> changes = new ArrayList<Change>();
        for (HgChange hgChange : hgChanges) {
            FileStatus status = HgUtil.convertHgDiffStatus(hgChange.getStatus());
            if (status == FileStatus.UNKNOWN) continue;
            changes.add(HgUtil.createChange(project, root, hgChange.beforeFile().getRelativePath(), revNumber1, hgChange.afterFile().getRelativePath(), rev2 != null ? rev2.getRevisionNumber() : null, status));
        }
        return changes;
    }

    public static Change createChange(Project project, VirtualFile root, String fileBefore, HgRevisionNumber revisionBefore, String fileAfter, HgRevisionNumber revisionAfter, FileStatus aStatus) {
        HgContentRevision beforeRevision;
        HgContentRevision hgContentRevision = beforeRevision = revisionBefore == null ? null : new HgContentRevision(project, new HgFile(root, new File(root.getPath(), fileBefore)), revisionBefore);
        if (revisionAfter == null) {
            ContentRevision currentRevision = CurrentContentRevision.create((FilePath)new HgFile(root, new File(root.getPath(), fileBefore)).toFilePath());
            return new Change((ContentRevision)beforeRevision, currentRevision, aStatus);
        }
        HgContentRevision afterRevision = new HgContentRevision(project, new HgFile(root, new File(root.getPath(), fileAfter)), revisionAfter);
        return new Change((ContentRevision)beforeRevision, (ContentRevision)afterRevision, aStatus);
    }

    public static FileStatus convertHgDiffStatus(HgFileStatusEnum hgstatus) {
        if (hgstatus.equals((Object)HgFileStatusEnum.ADDED)) {
            return FileStatus.ADDED;
        }
        if (hgstatus.equals((Object)HgFileStatusEnum.DELETED)) {
            return FileStatus.DELETED;
        }
        if (hgstatus.equals((Object)HgFileStatusEnum.MODIFIED)) {
            return FileStatus.MODIFIED;
        }
        if (hgstatus.equals((Object)HgFileStatusEnum.COPY)) {
            return HgChangeProvider.COPIED;
        }
        if (hgstatus.equals((Object)HgFileStatusEnum.UNVERSIONED)) {
            return FileStatus.UNKNOWN;
        }
        if (hgstatus.equals((Object)HgFileStatusEnum.IGNORED)) {
            return FileStatus.IGNORED;
        }
        return FileStatus.UNKNOWN;
    }

    public static String removePasswordIfNeeded(String path) {
        Matcher matcher = URL_WITH_PASSWORD.matcher(path);
        if (matcher.matches()) {
            return path.substring(0, matcher.start(1)) + path.substring(matcher.end(1), path.length());
        }
        return path;
    }

    public static String getDisplayableBranchOrBookmarkText(HgRepository repository) {
        Repository.State state = repository.getState();
        String branchText = "";
        if (state != Repository.State.NORMAL) {
            branchText = branchText + state.toString() + " ";
        }
        return branchText + repository.getCurrentBranchName();
    }

    public static HgRepositoryManager getRepositoryManager(Project project) {
        return (HgRepositoryManager)((Object)ServiceManager.getService((Project)project, HgRepositoryManager.class));
    }

    public static HgRepository getCurrentRepository(Project project) {
        VirtualFile file = DvcsUtil.getSelectedFile((Project)project);
        return HgUtil.getRepositoryForFile(project, file);
    }

    public static HgRepository getRepositoryForFile(Project project, VirtualFile file) {
        if (file == null || project.isDisposed()) {
            return null;
        }
        HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(project);
        VirtualFile root = HgUtil.getHgRootOrNull(project, file);
        return (HgRepository)repositoryManager.getRepositoryForRoot(root);
    }

    public static String getRepositoryDefaultPath(Project project, VirtualFile root) {
        HgRepository hgRepository = (HgRepository)HgUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        assert (hgRepository != null) : "Repository can't be null for root " + root.getName();
        return hgRepository.getRepositoryConfig().getDefaultPath();
    }

    public static String getRepositoryDefaultPushPath(Project project, VirtualFile root) {
        HgRepository hgRepository = (HgRepository)HgUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        assert (hgRepository != null) : "Repository can't be null for root " + root.getName();
        return hgRepository.getRepositoryConfig().getDefaultPushPath();
    }

    public static String getRepositoryDefaultPushPath(HgRepository repository) {
        return repository.getRepositoryConfig().getDefaultPushPath();
    }

    public static String getConfig(Project project, VirtualFile root, String section, String configName) {
        HgRepository hgRepository = (HgRepository)HgUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        assert (hgRepository != null) : "Repository can't be null for root " + root.getName();
        return hgRepository.getRepositoryConfig().getNamedConfig(section, configName);
    }

    public static Collection<String> getRepositoryPaths(Project project, VirtualFile root) {
        HgRepository hgRepository = (HgRepository)HgUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        assert (hgRepository != null) : "Repository can't be null for root " + root.getName();
        return hgRepository.getRepositoryConfig().getPaths();
    }

    public static boolean isExecutableValid(String executable) {
        try {
            if (StringUtil.isEmptyOrSpaces((String)executable)) {
                return false;
            }
            HgCommandResult result = HgUtil.getVersionOutput(executable);
            return result.getExitValue() == 0 && !result.getRawOutput().isEmpty();
        }
        catch (Throwable e) {
            LOG.info("Error during hg executable validation: ", e);
            return false;
        }
    }

    public static HgCommandResult getVersionOutput(String executable) throws ShellCommandException, InterruptedException {
        String hgExecutable = executable.trim();
        ArrayList<String> cmdArgs = new ArrayList<String>();
        cmdArgs.add(hgExecutable);
        cmdArgs.add("version");
        cmdArgs.add("-q");
        ShellCommand shellCommand = new ShellCommand(cmdArgs, null, CharsetToolkit.getDefaultSystemCharset());
        return shellCommand.execute(false);
    }

    public static List<String> getNamesWithoutHashes(Collection<HgNameWithHashInfo> namesWithHashes) {
        ArrayList<String> names = new ArrayList<String>();
        for (HgNameWithHashInfo hash : namesWithHashes) {
            if (names.contains(hash.getName())) continue;
            names.add(hash.getName());
        }
        Collections.sort(names);
        return names;
    }

    public static Couple<String> parseUserNameAndEmail(String authorString) {
        String userName;
        String email;
        int startEmailIndex = authorString.indexOf(60);
        int startDomainIndex = authorString.indexOf(64);
        int endEmailIndex = authorString.indexOf(62);
        if (0 < startEmailIndex && startEmailIndex < startDomainIndex && startDomainIndex < endEmailIndex) {
            email = authorString.substring(startEmailIndex + 1, endEmailIndex);
            userName = authorString.substring(0, startEmailIndex).trim();
        } else if (!authorString.contains(" ") && startDomainIndex > 0) {
            if (startEmailIndex >= 0 && startDomainIndex > startEmailIndex && startDomainIndex < endEmailIndex) {
                userName = authorString.substring(startEmailIndex + 1, startDomainIndex).trim();
                email = authorString.substring(startEmailIndex + 1, endEmailIndex).trim();
            } else {
                userName = authorString.substring(0, startDomainIndex).trim();
                email = authorString;
            }
        } else {
            userName = authorString.trim();
            email = "";
        }
        return Couple.of((Object)userName, (Object)email);
    }

    public static List<String> getTargetNames(HgRepository repository) {
        return ContainerUtil.sorted((Collection)ContainerUtil.map(repository.getRepositoryConfig().getPaths(), (Function)new Function<String, String>(){

            public String fun(String s) {
                return HgUtil.removePasswordIfNeeded(s);
            }
        }));
    }
}

