/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.util.HgUtil;

class HgSetExecutablePathPanel
extends TextFieldWithBrowseButton {
    private final Set<ActionListener> myOkListeners = new HashSet<ActionListener>();

    HgSetExecutablePathPanel(HgProjectSettings projectSettings) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public void validateSelectedFiles(VirtualFile[] files) throws Exception {
                String path = files[0].getPath();
                if (!HgUtil.isExecutableValid(path)) {
                    throw new ConfigurationException(HgVcsMessages.message("hg4idea.configuration.executable.error", path));
                }
                for (ActionListener okListener : HgSetExecutablePathPanel.this.myOkListeners) {
                    okListener.actionPerformed(null);
                }
            }
        };
        this.addBrowseFolderListener(HgVcsMessages.message("hg4idea.configuration.title", new Object[0]), HgVcsMessages.message("hg4idea.configuration.description", new Object[0]), null, descriptor);
    }

    void addOKListener(ActionListener listener) {
        this.myOkListeners.add(listener);
    }
}

