/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryFiles;

final class HgRepositoryUpdater
implements Disposable,
BulkFileListener {
    private final HgRepositoryFiles myRepositoryFiles;
    private final MessageBusConnection myMessageBusConnection;
    private final QueueProcessor<Object> myUpdateQueue;
    private final VirtualFile myBranchHeadsDir;
    private final LocalFileSystem.WatchRequest myWatchRequest;
    private final QueueProcessor<Object> myUpdateConfigQueue;

    HgRepositoryUpdater(final HgRepository repository) {
        VirtualFile hgDir = repository.getHgDir();
        this.myWatchRequest = LocalFileSystem.getInstance().addRootToWatch(hgDir.getPath(), true);
        this.myRepositoryFiles = HgRepositoryFiles.getInstance(hgDir);
        DvcsUtil.visitVcsDirVfs((VirtualFile)hgDir, HgRepositoryFiles.getSubDirRelativePaths());
        this.myBranchHeadsDir = VcsUtil.getVirtualFile((String)this.myRepositoryFiles.getBranchHeadsDirPath());
        Project project = repository.getProject();
        this.myUpdateQueue = new QueueProcessor((Consumer)new DvcsUtil.Updater((Repository)repository), project.getDisposed());
        this.myUpdateConfigQueue = new QueueProcessor((Consumer)new Consumer<Object>(){

            public void consume(Object dummy) {
                repository.updateConfig();
            }
        }, project.getDisposed());
        if (!project.isDisposed()) {
            this.myMessageBusConnection = project.getMessageBus().connect();
            this.myMessageBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
        } else {
            this.myMessageBusConnection = null;
        }
    }

    public void dispose() {
        if (this.myWatchRequest != null) {
            LocalFileSystem.getInstance().removeWatchedRoot(this.myWatchRequest);
        }
        if (this.myMessageBusConnection != null) {
            this.myMessageBusConnection.disconnect();
        }
    }

    public void before(List<? extends VFileEvent> events) {
    }

    public void after(List<? extends VFileEvent> events) {
        boolean branchHeadsChanged = false;
        boolean branchFileChanged = false;
        boolean dirstateFileChanged = false;
        boolean mergeFileChanged = false;
        boolean rebaseFileChanged = false;
        boolean bookmarksFileChanged = false;
        boolean tagsFileChanged = false;
        boolean localTagsFileChanged = false;
        boolean currentBookmarkFileChanged = false;
        boolean configHgrcChanged = false;
        for (VFileEvent vFileEvent : events) {
            String filePath = vFileEvent.getPath();
            if (filePath == null) continue;
            if (this.myRepositoryFiles.isbranchHeadsFile(filePath)) {
                branchHeadsChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isBranchFile(filePath)) {
                branchFileChanged = true;
                DvcsUtil.ensureAllChildrenInVfs((VirtualFile)this.myBranchHeadsDir);
                continue;
            }
            if (this.myRepositoryFiles.isDirstateFile(filePath)) {
                dirstateFileChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isMergeFile(filePath)) {
                mergeFileChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isRebaseFile(filePath)) {
                rebaseFileChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isBookmarksFile(filePath)) {
                bookmarksFileChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isTagsFile(filePath)) {
                tagsFileChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isLocalTagsFile(filePath)) {
                localTagsFileChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isCurrentBookmarksFile(filePath)) {
                currentBookmarkFileChanged = true;
                continue;
            }
            if (!this.myRepositoryFiles.isConfigHgrcFile(filePath)) continue;
            configHgrcChanged = true;
        }
        if (branchHeadsChanged || branchFileChanged || dirstateFileChanged || mergeFileChanged || rebaseFileChanged || bookmarksFileChanged || currentBookmarkFileChanged || tagsFileChanged || localTagsFileChanged) {
            this.myUpdateQueue.add(Void.TYPE);
        }
        if (configHgrcChanged) {
            this.myUpdateConfigQueue.add(Void.TYPE);
        }
    }
}

