/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.repo;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.Collection;

public class HgRepositoryFiles {
    public static final String BRANCHHEADS = "cache/branch";
    public static final String BRANCHEADSDIR = "cache";
    public static final String MERGE = "merge";
    public static final String REBASE = "rebase";
    public static final String BRANCH = "branch";
    public static final String DIRSTATE = "dirstate";
    public static final String BOOKMARKS = "bookmarks";
    public static final String LOCAL_TAGS = "localtags";
    public static final String TAGS = ".hgtags";
    public static final String CURRENT_BOOKMARK = "bookmarks.current";
    public static final String CONFIG_HGRC = "hgrc";
    private final String myBranchHeadsPath;
    private final String myBranchHeadsDirPath;
    private final String myMergePath;
    private final String myRebasePath;
    private final String myBranchPath;
    private final String myDirstatePath;
    private final String myBookmarksPath;
    private final String myTagsPath;
    private final String myLocalTagsPath;
    private final String myCurrentBookmarkPath;
    private final String myConfigHgrcPath;

    public static HgRepositoryFiles getInstance(VirtualFile hgDir) {
        return new HgRepositoryFiles(hgDir);
    }

    private HgRepositoryFiles(VirtualFile hgDir) {
        this.myBranchHeadsPath = hgDir.getPath() + HgRepositoryFiles.slash(BRANCHHEADS);
        this.myBranchHeadsDirPath = hgDir.getPath() + HgRepositoryFiles.slash(BRANCHEADSDIR);
        this.myBranchPath = hgDir.getPath() + HgRepositoryFiles.slash(BRANCH);
        this.myDirstatePath = hgDir.getPath() + HgRepositoryFiles.slash(DIRSTATE);
        this.myMergePath = hgDir.getPath() + HgRepositoryFiles.slash(MERGE);
        this.myRebasePath = hgDir.getPath() + HgRepositoryFiles.slash(REBASE);
        this.myBookmarksPath = hgDir.getPath() + HgRepositoryFiles.slash(BOOKMARKS);
        this.myTagsPath = hgDir.getParent().getPath() + HgRepositoryFiles.slash(TAGS);
        this.myLocalTagsPath = hgDir.getPath() + HgRepositoryFiles.slash(LOCAL_TAGS);
        this.myCurrentBookmarkPath = hgDir.getPath() + HgRepositoryFiles.slash(CURRENT_BOOKMARK);
        this.myConfigHgrcPath = hgDir.getPath() + HgRepositoryFiles.slash(CONFIG_HGRC);
    }

    private static String slash(String s) {
        return "/" + s;
    }

    static Collection<String> getSubDirRelativePaths() {
        return Arrays.asList(HgRepositoryFiles.slash(BRANCHHEADS), HgRepositoryFiles.slash(MERGE));
    }

    public String getBranchHeadsDirPath() {
        return this.myBranchHeadsDirPath;
    }

    public boolean isbranchHeadsFile(String filePath) {
        return filePath.startsWith(this.myBranchHeadsPath);
    }

    public boolean isBranchFile(String filePath) {
        return filePath.equals(this.myBranchPath);
    }

    public boolean isDirstateFile(String filePath) {
        return filePath.equals(this.myDirstatePath);
    }

    public boolean isMergeFile(String filePath) {
        return filePath.startsWith(this.myMergePath);
    }

    public boolean isRebaseFile(String filePath) {
        return filePath.startsWith(this.myRebasePath);
    }

    public boolean isBookmarksFile(String filePath) {
        return filePath.equals(this.myBookmarksPath);
    }

    public boolean isCurrentBookmarksFile(String filePath) {
        return filePath.equals(this.myCurrentBookmarkPath);
    }

    public boolean isConfigHgrcFile(String filePath) {
        return filePath.equals(this.myConfigHgrcPath);
    }

    public boolean isTagsFile(String filePath) {
        return filePath.equals(this.myTagsPath);
    }

    public boolean isLocalTagsFile(String filePath) {
        return filePath.equals(this.myLocalTagsPath);
    }
}

