/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.repo;

import com.google.common.base.Objects;
import com.intellij.dvcs.repo.Repository;
import com.intellij.vcs.log.Hash;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.zmlx.hg4idea.HgNameWithHashInfo;

public class HgRepoInfo {
    private String myCurrentBranch = "default";
    private final String myTipRevision;
    private final String myCurrentRevision;
    private final Repository.State myState;
    private String myCurrentBookmark = null;
    private Map<String, Set<Hash>> myBranches = Collections.emptyMap();
    private Set<HgNameWithHashInfo> myBookmarks = Collections.emptySet();
    private Set<HgNameWithHashInfo> myTags = Collections.emptySet();
    private Set<HgNameWithHashInfo> myLocalTags = Collections.emptySet();
    Set<HgNameWithHashInfo> mySubrepos = Collections.emptySet();

    public HgRepoInfo(String currentBranch, String currentRevision, String currentTipRevision, Repository.State state, Map<String, Set<Hash>> branches, Collection<HgNameWithHashInfo> bookmarks, String currentBookmark, Collection<HgNameWithHashInfo> tags, Collection<HgNameWithHashInfo> localTags, Collection<HgNameWithHashInfo> subrepos) {
        this.myCurrentBranch = currentBranch;
        this.myCurrentRevision = currentRevision;
        this.myTipRevision = currentTipRevision;
        this.myState = state;
        this.myBranches = branches;
        this.myBookmarks = new LinkedHashSet<HgNameWithHashInfo>(bookmarks);
        this.myCurrentBookmark = currentBookmark;
        this.myTags = new LinkedHashSet<HgNameWithHashInfo>(tags);
        this.myLocalTags = new LinkedHashSet<HgNameWithHashInfo>(localTags);
        this.mySubrepos = new HashSet<HgNameWithHashInfo>(subrepos);
    }

    public String getCurrentBranch() {
        return this.myCurrentBranch;
    }

    public Map<String, Set<Hash>> getBranches() {
        return this.myBranches;
    }

    public Collection<HgNameWithHashInfo> getBookmarks() {
        return this.myBookmarks;
    }

    public Collection<HgNameWithHashInfo> getTags() {
        return this.myTags;
    }

    public Collection<HgNameWithHashInfo> getLocalTags() {
        return this.myLocalTags;
    }

    public String getTipRevision() {
        return this.myTipRevision;
    }

    public String getCurrentRevision() {
        return this.myCurrentRevision;
    }

    public String getCurrentBookmark() {
        return this.myCurrentBookmark;
    }

    public Repository.State getState() {
        return this.myState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HgRepoInfo info = (HgRepoInfo)o;
        if (this.myState != info.myState) {
            return false;
        }
        if (this.myTipRevision != null ? !this.myTipRevision.equals(info.myTipRevision) : info.myTipRevision != null) {
            return false;
        }
        if (this.myCurrentRevision != null ? !this.myCurrentRevision.equals(info.myCurrentRevision) : info.myCurrentRevision != null) {
            return false;
        }
        if (!this.myCurrentBranch.equals(info.myCurrentBranch)) {
            return false;
        }
        if (this.myCurrentBookmark != null ? !this.myCurrentBookmark.equals(info.myCurrentBookmark) : info.myCurrentBookmark != null) {
            return false;
        }
        if (!((Object)this.myBranches).equals(info.myBranches)) {
            return false;
        }
        if (!((Object)this.myBookmarks).equals(info.myBookmarks)) {
            return false;
        }
        if (!((Object)this.myTags).equals(info.myTags)) {
            return false;
        }
        if (!((Object)this.myLocalTags).equals(info.myLocalTags)) {
            return false;
        }
        return ((Object)this.mySubrepos).equals(info.mySubrepos);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myCurrentBranch, this.myCurrentRevision, this.myTipRevision, this.myCurrentBookmark, this.myState, this.myBranches, this.myBookmarks, this.myTags, this.myLocalTags, this.mySubrepos});
    }

    public String toString() {
        return String.format("HgRepository{myCurrentBranch=%s, myCurrentRevision='%s', myState=%s}", this.myCurrentBranch, this.myCurrentRevision, this.myState);
    }

    public boolean hasSubrepos() {
        return !this.mySubrepos.isEmpty();
    }

    public Collection<HgNameWithHashInfo> getSubrepos() {
        return this.mySubrepos;
    }
}

