/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.UserNameRegex;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.LogDataImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.log.HgHistoryUtil;
import org.zmlx.hg4idea.log.HgRefManager;
import org.zmlx.hg4idea.repo.HgConfig;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgUtil;

public class HgLogProvider
implements VcsLogProvider {
    private static final Logger LOG = Logger.getInstance(HgLogProvider.class);
    private final Project myProject;
    private final HgRepositoryManager myRepositoryManager;
    private final VcsLogRefManager myRefSorter;
    private final VcsLogObjectsFactory myVcsObjectsFactory;

    public HgLogProvider(Project project, HgRepositoryManager repositoryManager, VcsLogObjectsFactory factory) {
        this.myProject = project;
        this.myRepositoryManager = repositoryManager;
        this.myRefSorter = new HgRefManager();
        this.myVcsObjectsFactory = factory;
    }

    public VcsLogProvider.DetailedLogData readFirstBlock(VirtualFile root, VcsLogProvider.Requirements requirements) throws VcsException {
        List<VcsCommitMetadata> commits = HgHistoryUtil.loadMetadata(this.myProject, root, requirements.getCommitCount(), Collections.<String>emptyList());
        return new LogDataImpl(this.readAllRefs(root), commits);
    }

    public VcsLogProvider.LogData readAllHashes(VirtualFile root, Consumer<TimedVcsCommit> commitConsumer) throws VcsException {
        HashSet userRegistry = ContainerUtil.newHashSet();
        List<TimedVcsCommit> commits = HgHistoryUtil.readAllHashes(this.myProject, root, (Consumer<VcsUser>)new CollectConsumer((Collection)userRegistry), Collections.<String>emptyList());
        for (TimedVcsCommit commit : commits) {
            commitConsumer.consume((Object)commit);
        }
        return new LogDataImpl(this.readAllRefs(root), (Set)userRegistry);
    }

    public List<? extends VcsShortCommitDetails> readShortDetails(VirtualFile root, List<String> hashes) throws VcsException {
        return HgHistoryUtil.readMiniDetails(this.myProject, root, hashes);
    }

    public List<? extends VcsFullCommitDetails> readFullDetails(VirtualFile root, List<String> hashes) throws VcsException {
        return HgHistoryUtil.history(this.myProject, root, -1, HgHistoryUtil.prepareHashes(hashes));
    }

    private Set<VcsRef> readAllRefs(VirtualFile root) throws VcsException {
        String tipRevision;
        if (this.myProject.isDisposed()) {
            return Collections.emptySet();
        }
        HgRepository repository = (HgRepository)this.myRepositoryManager.getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root);
            return Collections.emptySet();
        }
        repository.update();
        Map<String, Set<Hash>> branches = repository.getBranches();
        Set<String> openedBranchNames = repository.getOpenedBranches();
        Collection<HgNameWithHashInfo> bookmarks = repository.getBookmarks();
        Collection<HgNameWithHashInfo> tags = repository.getTags();
        Collection<HgNameWithHashInfo> localTags = repository.getLocalTags();
        HashSet<VcsRef> refs = new HashSet<VcsRef>(branches.size() + bookmarks.size());
        for (Map.Entry<String, Set<Hash>> entry : branches.entrySet()) {
            String branchName = entry.getKey();
            boolean opened = openedBranchNames.contains(branchName);
            for (Hash hash : entry.getValue()) {
                refs.add(this.myVcsObjectsFactory.createRef(hash, branchName, opened ? HgRefManager.BRANCH : HgRefManager.CLOSED_BRANCH, root));
            }
        }
        for (HgNameWithHashInfo bookmarkInfo : bookmarks) {
            refs.add(this.myVcsObjectsFactory.createRef(bookmarkInfo.getHash(), bookmarkInfo.getName(), HgRefManager.BOOKMARK, root));
        }
        String currentRevision = repository.getCurrentRevision();
        if (currentRevision != null) {
            refs.add(this.myVcsObjectsFactory.createRef(this.myVcsObjectsFactory.createHash(currentRevision), "HEAD", HgRefManager.HEAD, root));
        }
        if ((tipRevision = repository.getTipRevision()) != null) {
            refs.add(this.myVcsObjectsFactory.createRef(this.myVcsObjectsFactory.createHash(tipRevision), "tip", HgRefManager.TIP, root));
        }
        for (HgNameWithHashInfo tagInfo : tags) {
            refs.add(this.myVcsObjectsFactory.createRef(tagInfo.getHash(), tagInfo.getName(), HgRefManager.TAG, root));
        }
        for (HgNameWithHashInfo localTagInfo : localTags) {
            refs.add(this.myVcsObjectsFactory.createRef(localTagInfo.getHash(), localTagInfo.getName(), HgRefManager.LOCAL_TAG, root));
        }
        return refs;
    }

    public VcsKey getSupportedVcs() {
        return HgVcs.getKey();
    }

    public VcsLogRefManager getReferenceManager() {
        return this.myRefSorter;
    }

    public void subscribeToRootRefreshEvents(final Collection<VirtualFile> roots, final VcsLogRefresher refresher) {
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(HgVcs.STATUS_TOPIC, (Object)new HgUpdater(){

            @Override
            public void update(Project project, VirtualFile root) {
                if (root != null && roots.contains(root)) {
                    refresher.refresh(root);
                }
            }
        });
    }

    public List<TimedVcsCommit> getCommitsMatchingFilter(VirtualFile root, VcsLogFilterCollection filterCollection, int maxCount) throws VcsException {
        ArrayList filterParameters = ContainerUtil.newArrayList();
        if (filterCollection.getBranchFilter() != null) {
            HgRepository repository = (HgRepository)this.myRepositoryManager.getRepositoryForRoot(root);
            if (repository == null) {
                LOG.error("Repository not found for root " + root);
                return Collections.emptyList();
            }
            boolean atLeastOneBranchExists = false;
            for (String branchName : filterCollection.getBranchFilter().getBranchNames()) {
                if (branchName.equals("tip") || HgLogProvider.branchExists(repository, branchName)) {
                    filterParameters.add(HgHistoryUtil.prepareParameter("branch", branchName));
                    atLeastOneBranchExists = true;
                    continue;
                }
                if (!branchName.equals("HEAD")) continue;
                filterParameters.add(HgHistoryUtil.prepareParameter("branch", "."));
                filterParameters.add("-r");
                filterParameters.add("::.");
                atLeastOneBranchExists = true;
            }
            if (!atLeastOneBranchExists) {
                return Collections.emptyList();
            }
        }
        if (filterCollection.getUserFilter() != null) {
            filterParameters.add("-r");
            String authorFilter = StringUtil.join((Collection)ContainerUtil.map((Collection)filterCollection.getUserFilter().getUserNames(root), (Function)UserNameRegex.INSTANCE), (String)"|");
            filterParameters.add("user('re:" + authorFilter + "')");
        }
        if (filterCollection.getDateFilter() != null) {
            StringBuilder args = new StringBuilder();
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            filterParameters.add("-d");
            VcsLogDateFilter filter = filterCollection.getDateFilter();
            if (filter.getAfter() != null) {
                if (filter.getBefore() != null) {
                    args.append(dateFormatter.format(filter.getAfter())).append(" to ").append(dateFormatter.format(filter.getBefore()));
                } else {
                    args.append('>').append(dateFormatter.format(filter.getAfter()));
                }
            } else if (filter.getBefore() != null) {
                args.append('<').append(dateFormatter.format(filter.getBefore()));
            }
            filterParameters.add(args.toString());
        }
        if (filterCollection.getTextFilter() != null) {
            String textFilter = filterCollection.getTextFilter().getText();
            filterParameters.add(HgHistoryUtil.prepareParameter("keyword", textFilter));
        }
        if (filterCollection.getStructureFilter() != null) {
            for (VirtualFile file : filterCollection.getStructureFilter().getFiles()) {
                filterParameters.add(file.getPath());
            }
        }
        return HgHistoryUtil.readAllHashes(this.myProject, root, (Consumer<VcsUser>)Consumer.EMPTY_CONSUMER, filterParameters);
    }

    public VcsUser getCurrentUser(VirtualFile root) throws VcsException {
        String userName = HgConfig.getInstance(this.myProject, root).getNamedConfig("ui", "username");
        if (userName == null && (userName = System.getenv("HGUSER")) == null && (userName = System.getenv("USER")) == null && (userName = System.getenv("LOGNAME")) == null) {
            return null;
        }
        Couple<String> userArgs = HgUtil.parseUserNameAndEmail(userName);
        return this.myVcsObjectsFactory.createUser((String)userArgs.getFirst(), (String)userArgs.getSecond());
    }

    public Collection<String> getContainingBranches(VirtualFile root, Hash commitHash) throws VcsException {
        return HgHistoryUtil.getDescendingHeadsOfBranches(this.myProject, root, commitHash);
    }

    public <T> T getPropertyValue(VcsLogProperties.VcsLogProperty<T> property) {
        return null;
    }

    private static boolean branchExists(HgRepository repository, String branchName) {
        return repository.getBranches().keySet().contains(branchName) || HgUtil.getNamesWithoutHashes(repository.getBookmarks()).contains(branchName);
    }
}

