/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandAuthenticator;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.SocketServer;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgRemoteCommandExecutor
extends HgCommandExecutor {
    private ModalityState myState;
    final boolean myIgnoreAuthorizationRequest;

    public HgRemoteCommandExecutor(Project project, String destination) {
        this(project, destination, null, false);
    }

    public HgRemoteCommandExecutor(Project project, String destination, boolean ignoreAuthorizationRequest) {
        this(project, destination, null, ignoreAuthorizationRequest);
    }

    public HgRemoteCommandExecutor(Project project, String destination, ModalityState state, boolean ignoreAuthorizationRequest) {
        super(project, destination);
        this.myState = state;
        this.myIgnoreAuthorizationRequest = ignoreAuthorizationRequest;
    }

    @Override
    public HgCommandResult executeInCurrentThread(VirtualFile repo, String operation, List<String> arguments) {
        HgCommandResult result = this.executeInCurrentThread(repo, operation, arguments, false);
        if (!this.myIgnoreAuthorizationRequest && HgErrorUtil.isAuthorizationError(result)) {
            if (HgErrorUtil.hasAuthorizationInDestinationPath(this.myDestination)) {
                new HgCommandResultNotifier(this.myProject).notifyError(result, "Authorization failed", "Your hgrc file settings have wrong username or password in [paths].\nPlease, update your .hg/hgrc file.");
                return null;
            }
            result = this.executeInCurrentThread(repo, operation, arguments, true);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HgCommandResult executeInCurrentThread(VirtualFile repo, String operation, List<String> arguments, boolean forceAuthorization) {
        PassReceiver passReceiver = new PassReceiver(this.myProject, forceAuthorization, this.myIgnoreAuthorizationRequest, this.myState);
        SocketServer passServer = new SocketServer(passReceiver);
        try {
            int passPort = passServer.start();
            HgCommandResult result = super.executeInCurrentThread(repo, operation, this.prepareArguments(arguments, passPort));
            if (!HgErrorUtil.isAuthorizationError(result)) {
                passReceiver.saveCredentials();
            }
            HgCommandResult hgCommandResult = result;
            return hgCommandResult;
        }
        catch (IOException e) {
            this.showError(e);
            LOG.info("IOException during preparing command", (Throwable)e);
            HgCommandResult hgCommandResult = null;
            return hgCommandResult;
        }
        finally {
            passServer.stop();
        }
    }

    private List<String> prepareArguments(List<String> arguments, int port) {
        ArrayList cmdArguments = ContainerUtil.newArrayList();
        cmdArguments.add("--config");
        cmdArguments.add("extensions.hg4ideapromptextension=" + this.myVcs.getPromptHooksExtensionFile().getAbsolutePath());
        cmdArguments.add("--config");
        cmdArguments.add("hg4ideapass.port=" + port);
        if (arguments != null && arguments.size() != 0) {
            cmdArguments.addAll(arguments);
        }
        return cmdArguments;
    }

    @Override
    protected void logCommand(String operation, List<String> arguments) {
        super.logCommand(operation, null);
    }

    private static class PassReceiver
    extends SocketServer.Protocol {
        private final Project myProject;
        private HgCommandAuthenticator myAuthenticator;
        private boolean myForceAuthorization;
        private boolean mySilentMode;
        private ModalityState myState;

        private PassReceiver(Project project, boolean forceAuthorization, boolean silent, ModalityState state) {
            this.myProject = project;
            this.myForceAuthorization = forceAuthorization;
            this.mySilentMode = silent;
            this.myState = state;
        }

        @Override
        public boolean handleConnection(Socket socket) throws IOException {
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            String command = new String(PassReceiver.readDataBlock(dataInputStream));
            assert ("getpass".equals(command)) : "Invalid command: " + command;
            String uri = new String(PassReceiver.readDataBlock(dataInputStream));
            String path = new String(PassReceiver.readDataBlock(dataInputStream));
            HgCommandAuthenticator authenticator = new HgCommandAuthenticator(this.myProject, this.myForceAuthorization, this.mySilentMode);
            String proposedLogin = new String(PassReceiver.readDataBlock(dataInputStream));
            boolean ok = authenticator.promptForAuthentication(this.myProject, proposedLogin, uri, path, this.myState);
            if (ok) {
                this.myAuthenticator = authenticator;
                PassReceiver.sendDataBlock(out, authenticator.getUserName().getBytes());
                PassReceiver.sendDataBlock(out, authenticator.getPassword().getBytes());
            }
            return true;
        }

        public void saveCredentials() {
            if (this.myAuthenticator == null) {
                return;
            }
            this.myAuthenticator.saveCredentials();
        }
    }
}

