/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResultHandler;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgUtil;

public class HgTagCreateCommand {
    private final Project project;
    private final VirtualFile repo;
    private final String tagName;
    private final String revisionNumberOrHash;

    public HgTagCreateCommand(Project project, VirtualFile repo, String tagName, String revisionNumberOrHash) {
        this.project = project;
        this.repo = repo;
        this.tagName = tagName;
        this.revisionNumberOrHash = revisionNumberOrHash;
    }

    public void execute(HgCommandResultHandler resultHandler) throws HgCommandException {
        if (StringUtil.isEmptyOrSpaces((String)this.tagName)) {
            throw new HgCommandException("tag name is empty");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.tagName);
        if (!StringUtil.isEmptyOrSpaces((String)this.revisionNumberOrHash)) {
            arguments.add("--rev");
            arguments.add(this.revisionNumberOrHash);
        }
        new HgCommandExecutor(this.project).execute(this.repo, "tag", arguments, resultHandler);
        if (!this.project.isDisposed()) {
            HgRepositoryManager manager = HgUtil.getRepositoryManager(this.project);
            manager.updateRepository(this.repo);
        }
    }
}

