/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.LinkedList;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgCommandResultHandler;
import org.zmlx.hg4idea.execution.HgRemoteCommandExecutor;

public class HgPushCommand {
    private final Project myProject;
    private final VirtualFile myRepo;
    private final String myDestination;
    private String myRevision;
    private boolean myForce;
    private String myBranchName;
    private String myBookmarkName;
    private boolean myIsNewBranch;

    public HgPushCommand(Project project, VirtualFile repo, String destination) {
        this.myProject = project;
        this.myRepo = repo;
        this.myDestination = destination;
    }

    public void setRevision(String revision) {
        this.myRevision = revision;
    }

    public void setForce(boolean force) {
        this.myForce = force;
    }

    public void setBranchName(String branchName) {
        this.myBranchName = branchName;
    }

    public void setIsNewBranch(boolean isNewBranch) {
        this.myIsNewBranch = isNewBranch;
    }

    public void setBookmarkName(String bookmark) {
        this.myBookmarkName = bookmark;
    }

    public void execute(final HgCommandResultHandler resultHandler) {
        LinkedList<String> arguments = new LinkedList<String>();
        if (!StringUtil.isEmptyOrSpaces((String)this.myRevision)) {
            arguments.add("-r");
            arguments.add(this.myRevision);
        }
        if (this.myBranchName != null) {
            arguments.add("-b");
            arguments.add(this.myBranchName);
        }
        if (this.myIsNewBranch) {
            arguments.add("--new-branch");
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myBookmarkName)) {
            arguments.add("-B");
            arguments.add(this.myBookmarkName);
        }
        if (this.myForce) {
            arguments.add("-f");
        }
        arguments.add(this.myDestination);
        HgRemoteCommandExecutor executor = new HgRemoteCommandExecutor(this.myProject, this.myDestination);
        executor.setShowOutput(true);
        executor.execute(this.myRepo, "push", arguments, new HgCommandResultHandler(){

            @Override
            public void process(HgCommandResult result) {
                if (!HgPushCommand.this.myProject.isDisposed()) {
                    ((HgUpdater)HgPushCommand.this.myProject.getMessageBus().syncPublisher(HgVcs.REMOTE_TOPIC)).update(HgPushCommand.this.myProject, null);
                }
                resultHandler.process(result);
            }
        });
    }

    public VirtualFile getRepo() {
        return this.myRepo;
    }
}

