/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import org.zmlx.hg4idea.HgGlobalSettings;
import org.zmlx.hg4idea.HgVcs;

@com.intellij.openapi.components.State(name="hg4idea.settings", storages={@Storage(file="$WORKSPACE_FILE$")})
public class HgProjectSettings
implements PersistentStateComponent<State>,
DvcsSyncSettings {
    private final HgGlobalSettings myAppSettings;
    private final Project myProject;
    private State myState = new State();

    public HgProjectSettings(Project project, HgGlobalSettings appSettings) {
        this.myProject = project;
        this.myAppSettings = appSettings;
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
        if (state.CHECK_INCOMING_OUTGOING == null) {
            state.CHECK_INCOMING_OUTGOING = state.myCheckIncoming || state.myCheckOutgoing;
        }
    }

    public boolean isCheckIncomingOutgoing() {
        return this.myState.CHECK_INCOMING_OUTGOING != null && this.myState.CHECK_INCOMING_OUTGOING != false;
    }

    public boolean isWhitespacesIgnoredInAnnotations() {
        return this.myState.myIgnoreWhitespacesInAnnotations;
    }

    public DvcsSyncSettings.Value getSyncSetting() {
        return this.myState.ROOT_SYNC;
    }

    public void setSyncSetting(DvcsSyncSettings.Value syncSetting) {
        this.myState.ROOT_SYNC = syncSetting;
    }

    public void setCheckIncomingOutgoing(boolean checkIncomingOutgoing) {
        this.myState.CHECK_INCOMING_OUTGOING = checkIncomingOutgoing;
    }

    public void setIgnoreWhitespacesInAnnotations(boolean ignoreWhitespacesInAnnotations) {
        if (this.myState.myIgnoreWhitespacesInAnnotations != ignoreWhitespacesInAnnotations) {
            this.myState.myIgnoreWhitespacesInAnnotations = ignoreWhitespacesInAnnotations;
            ((VcsAnnotationRefresher)this.myProject.getMessageBus().syncPublisher(VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED)).configurationChanged(HgVcs.getKey());
        }
    }

    public String getHgExecutable() {
        return this.myAppSettings.getHgExecutable();
    }

    public void setHgExecutable(String text) {
        this.myAppSettings.setHgExecutable(text);
    }

    public HgGlobalSettings getGlobalSettings() {
        return this.myAppSettings;
    }

    public static class State {
        public boolean myCheckIncoming = true;
        public boolean myCheckOutgoing = true;
        public Boolean CHECK_INCOMING_OUTGOING = null;
        public boolean myIgnoreWhitespacesInAnnotations = true;
        public DvcsSyncSettings.Value ROOT_SYNC = DvcsSyncSettings.Value.NOT_DECIDED;
    }
}

