/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.groovy.compiler.rt;

import com.intellij.util.lang.UrlClassLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Queue;
import sun.misc.URLClassPath;

public class GroovycRunner {
    private GroovycRunner() {
    }

    public static void main(String[] args) {
        System.exit(GroovycRunner.intMain(args));
    }

    public static int intMain(String[] args) {
        boolean indy = false;
        if (args.length != 3) {
            if (args.length != 4 || !"--indy".equals(args[3])) {
                System.err.println("There is no arguments for groovy compiler");
                return 1;
            }
            indy = true;
        }
        boolean optimize = "optimize".equals(args[0]);
        boolean forStubs = "stubs".equals(args[1]);
        String argPath = args[2];
        return GroovycRunner.intMain2(indy, optimize, forStubs, argPath, null);
    }

    public static int intMain2(boolean indy, boolean optimize, boolean forStubs, String argPath, Queue mailbox) {
        ClassLoader loader;
        if (indy) {
            System.setProperty("groovy.target.indy", "true");
        }
        if (!new File(argPath).exists()) {
            System.err.println("Arguments file for groovy compiler not found");
            return 1;
        }
        ClassLoader classLoader = loader = optimize ? GroovycRunner.buildMainLoader(argPath) : GroovycRunner.class.getClassLoader();
        if (loader == null) {
            return 1;
        }
        if (optimize) {
            Thread.currentThread().setContextClassLoader(loader);
        }
        try {
            Class.forName("org.codehaus.groovy.control.CompilationUnit", true, loader);
        }
        catch (Throwable e) {
            System.err.println("Cannot compile Groovy files: no Groovy library is defined");
            return 1;
        }
        try {
            Class<?> aClass = Class.forName("org.jetbrains.groovy.compiler.rt.DependentGroovycRunner", true, loader);
            Method method = aClass.getDeclaredMethod("runGroovyc", Boolean.TYPE, String.class, Queue.class);
            method.invoke(null, forStubs, argPath, mailbox);
        }
        catch (Throwable e) {
            while (e.getCause() != null) {
                e = e.getCause();
            }
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    private static ClassLoader buildMainLoader(String argsPath) {
        HashSet bootstrapUrls = new HashSet();
        try {
            Method method = ClassLoader.class.getDeclaredMethod("getBootstrapClassPath", new Class[0]);
            method.setAccessible(true);
            URLClassPath ucp = (URLClassPath)method.invoke(null, new Object[0]);
            Collections.addAll(bootstrapUrls, ucp.getURLs());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final ArrayList<URL> urls = new ArrayList<URL>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(argsPath));
            String classpath = reader.readLine();
            for (String s : classpath.split(File.pathSeparator)) {
                URL url = new File(s).toURI().toURL();
                if (bootstrapUrls.contains(url)) continue;
                urls.add(url);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        final ClassLoader[] ref = new ClassLoader[1];
        new Runnable(){

            public void run() {
                ref[0] = UrlClassLoader.build().urls(urls).useCache().get();
            }
        }.run();
        return ref[0];
    }
}

