/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.google.common.base.Strings;
import com.google.common.io.Closeables;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public final class AndroidGradleSettings {
    private static final Logger LOG = Logger.getInstance(AndroidGradleSettings.class);
    private static final String JVM_ARG_FORMAT = "-D%1$s=%2$s";
    private static final String PROJECT_PROPERTY_FORMAT = "-P%1$s=%2$s";
    public static final String ANDROID_HOME_JVM_ARG = "android.home";

    private AndroidGradleSettings() {
    }

    public static boolean isAndroidSdkDirInLocalPropertiesFile(File projectDir) {
        String androidHome = AndroidGradleSettings.getAndroidHomeFromLocalPropertiesFile(projectDir);
        if (!Strings.isNullOrEmpty((String)androidHome)) {
            String msg = String.format("Found Android SDK home at '%1$s' (from local.properties file)", androidHome);
            LOG.info(msg);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAndroidHomeFromLocalPropertiesFile(File projectDir) {
        File filePath = new File(projectDir, "local.properties");
        if (!filePath.isFile()) {
            return null;
        }
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(filePath);
            properties.load(fileInputStream);
        }
        catch (FileNotFoundException e) {
            String string = null;
            return string;
        }
        catch (IOException e) {
            String msg = String.format("Failed to read file '%1$s'", filePath.getPath());
            LOG.error(msg, (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            try {
                Closeables.close((Closeable)fileInputStream, (boolean)true);
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }
        return properties.getProperty("sdk.dir");
    }

    public static String createAndroidHomeJvmArg(String androidHome) {
        return AndroidGradleSettings.createJvmArg(ANDROID_HOME_JVM_ARG, androidHome);
    }

    public static String createJvmArg(String name, int value) {
        return AndroidGradleSettings.createJvmArg(name, String.valueOf(value));
    }

    public static String createJvmArg(String name, boolean value) {
        return AndroidGradleSettings.createJvmArg(name, String.valueOf(value));
    }

    public static String createJvmArg(String name, String value) {
        return String.format(JVM_ARG_FORMAT, name, value);
    }

    public static String createProjectProperty(String name, boolean value) {
        return AndroidGradleSettings.createProjectProperty(name, String.valueOf(value));
    }

    public static String createProjectProperty(String name, String value) {
        return String.format(PROJECT_PROPERTY_FORMAT, name, value);
    }
}

