/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class MavenUIUtil {
    public static void executeAction(String actionId, InputEvent e) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action = actionManager.getAction(actionId);
        if (action != null) {
            Presentation presentation = new Presentation();
            AnActionEvent event = new AnActionEvent(e, DataManager.getInstance().getDataContext(e.getComponent()), "", presentation, actionManager, 0);
            action.update(event);
            if (presentation.isEnabled()) {
                action.actionPerformed(event);
            }
        }
    }

    public static <E> void setElements(ElementsChooser<E> chooser, Collection<E> all, Collection<E> selected, Comparator<E> comparator) {
        List selection = chooser.getSelectedElements();
        chooser.clear();
        TreeSet<E> sorted = new TreeSet<E>(comparator);
        sorted.addAll(all);
        for (Object element : sorted) {
            chooser.addElement(element, selected.contains(element));
        }
        chooser.selectElements((Collection)selection);
    }

    public static void installCheckboxRenderer(final SimpleTree tree, final CheckboxHandler handler) {
        final JCheckBox checkbox = new JCheckBox();
        final JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)checkbox, "West");
        final TreeCellRenderer baseRenderer = tree.getCellRenderer();
        tree.setCellRenderer(new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component baseComponent = baseRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (!handler.isVisible(userObject)) {
                    return baseComponent;
                }
                Color foreground = selected ? UIUtil.getTreeSelectionForeground() : UIUtil.getTreeTextForeground();
                Color background = selected ? UIUtil.getTreeSelectionBackground((boolean)hasFocus) : UIUtil.getTreeTextBackground();
                panel.add(baseComponent, "Center");
                panel.setBackground(background);
                panel.setForeground(foreground);
                CheckBoxState state = handler.getState(userObject);
                checkbox.setSelected(state != CheckBoxState.UNCHECKED);
                checkbox.setEnabled(state != CheckBoxState.PARTIAL);
                checkbox.setBackground(background);
                checkbox.setForeground(foreground);
                return panel;
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row = tree.getRowForLocation(e.getX(), e.getY());
                if (row >= 0) {
                    TreePath path = tree.getPathForRow(row);
                    if (!MavenUIUtil.isCheckboxEnabledFor(path, handler)) {
                        return;
                    }
                    Rectangle checkBounds = checkbox.getBounds();
                    checkBounds.setLocation(tree.getRowBounds(row).getLocation());
                    if (checkBounds.contains(e.getPoint())) {
                        handler.toggle(path, e);
                        e.consume();
                        tree.setSelectionRow(row);
                    }
                }
            }
        });
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TreePath[] treePaths;
                if (e.getKeyCode() == 32 && (treePaths = tree.getSelectionPaths()) != null) {
                    for (TreePath treePath : treePaths) {
                        if (!MavenUIUtil.isCheckboxEnabledFor(treePath, handler)) continue;
                        handler.toggle(treePath, e);
                    }
                    e.consume();
                }
            }
        });
    }

    private static boolean isCheckboxEnabledFor(TreePath path, CheckboxHandler handler) {
        Object userObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        return handler.isVisible(userObject);
    }

    public static enum CheckBoxState {
        CHECKED,
        UNCHECKED,
        PARTIAL;

    }

    public static interface CheckboxHandler {
        public void toggle(TreePath var1, InputEvent var2);

        public boolean isVisible(Object var1);

        public CheckBoxState getState(Object var1);
    }
}

