/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenGotoFileContributor
implements ChooseByNameContributor {
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        ArrayList<String> result = new ArrayList<String>();
        for (MavenProject each : MavenProjectsManager.getInstance(project).getProjects()) {
            result.add(each.getMavenId().getArtifactId());
        }
        return ArrayUtil.toStringArray(result);
    }

    public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        for (MavenProject each : MavenProjectsManager.getInstance(project).getProjects()) {
            PsiFile psiFile;
            if (!name.equals(each.getMavenId().getArtifactId()) || (psiFile = PsiManager.getInstance((Project)project).findFile(each.getFile())) == null) continue;
            result.add(psiFile);
        }
        return result.toArray(new NavigationItem[result.size()]);
    }
}

