/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.services.nexus;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.services.MavenRepositoryService;
import org.jetbrains.idea.maven.services.nexus.ArtifactType;
import org.jetbrains.idea.maven.services.nexus.Endpoint;
import org.jetbrains.idea.maven.services.nexus.RepositoryType;
import org.jetbrains.idea.maven.services.nexus.SearchResults;

public class NexusRepositoryService
extends MavenRepositoryService {
    public static MavenRepositoryInfo convertRepositoryInfo(RepositoryType repo) {
        return new MavenRepositoryInfo(repo.getId(), repo.getName(), repo.getContentResourceURI());
    }

    public static MavenArtifactInfo convertArtifactInfo(ArtifactType t) {
        return new MavenArtifactInfo(t.getGroupId(), t.getArtifactId(), t.getVersion(), t.getPackaging(), t.getClassifier(), null, t.getRepoId());
    }

    @Override
    public String getDisplayName() {
        return "Nexus";
    }

    @Override
    public List<MavenRepositoryInfo> getRepositories(String url) throws IOException {
        try {
            List<RepositoryType> repos = new Endpoint.Repositories(url).getRepolistAsRepositories().getData().getRepositoriesItem();
            ArrayList<MavenRepositoryInfo> result = new ArrayList<MavenRepositoryInfo>(repos.size());
            for (RepositoryType repo : repos) {
                if (!"maven2".equals(repo.getProvider())) continue;
                result.add(NexusRepositoryService.convertRepositoryInfo(repo));
            }
            return result;
        }
        catch (UnmarshalException e) {
            return Collections.emptyList();
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public List<MavenArtifactInfo> findArtifacts(String url, MavenArtifactInfo template) throws IOException {
        try {
            String packaging = StringUtil.notNullize((String)template.getPackaging());
            String name = StringUtil.join(Arrays.asList(template.getGroupId(), template.getArtifactId(), template.getVersion()), (String)":");
            SearchResults results = new Endpoint.DataIndex(url).getArtifactlistAsSearchResults(name, template.getGroupId(), template.getArtifactId(), template.getVersion(), null, template.getClassNames());
            boolean tooManyResults = results.isTooManyResults();
            SearchResults.Data data = results.getData();
            ArrayList<MavenArtifactInfo> result = new ArrayList<MavenArtifactInfo>();
            if (data != null) {
                for (ArtifactType each : data.getArtifact()) {
                    if (!Comparing.equal((String)each.packaging, (String)packaging)) continue;
                    result.add(NexusRepositoryService.convertArtifactInfo(each));
                }
            }
            if (tooManyResults) {
                result.add(null);
            }
            return result;
        }
        catch (UnmarshalException e) {
            return Collections.emptyList();
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }
}

