/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.services.artifactory;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.services.MavenRepositoryService;
import org.jetbrains.idea.maven.services.artifactory.ArtifactoryModel;
import org.jetbrains.idea.maven.services.artifactory.Endpoint;

public class ArtifactoryRepositoryService
extends MavenRepositoryService {
    @Override
    public String getDisplayName() {
        return "Artifactory";
    }

    @Override
    public List<MavenRepositoryInfo> getRepositories(String url) throws IOException {
        try {
            Gson gson = new Gson();
            InputStreamReader stream = new InputStreamReader(new Endpoint.Repositories(url).getRepositoryDetailsListJson(null).getInputStream());
            ArtifactoryModel.RepositoryType[] repos = (ArtifactoryModel.RepositoryType[])gson.fromJson((Reader)stream, ArtifactoryModel.RepositoryType[].class);
            ArrayList<MavenRepositoryInfo> result = new ArrayList<MavenRepositoryInfo>(repos.length);
            for (ArtifactoryModel.RepositoryType repo : repos) {
                result.add(ArtifactoryRepositoryService.convert(repo));
            }
            return result;
        }
        catch (JsonSyntaxException e) {
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static MavenRepositoryInfo convert(ArtifactoryModel.RepositoryType repo) {
        return new MavenRepositoryInfo(repo.key, repo.description, repo.url);
    }

    @Override
    public List<MavenArtifactInfo> findArtifacts(String url, MavenArtifactInfo template) throws IOException {
        try {
            String packaging = StringUtil.notNullize((String)template.getPackaging());
            ArrayList<MavenArtifactInfo> artifacts = new ArrayList<MavenArtifactInfo>();
            Gson gson = new Gson();
            String className = template.getClassNames();
            if (className == null || className.length() == 0) {
                ArtifactoryModel.GavcResults results;
                String name = StringUtil.join(Arrays.asList(template.getGroupId(), template.getArtifactId(), template.getVersion()), (String)":");
                InputStream stream = new Endpoint.Search.Artifact(url).getArtifactSearchResultJson(name, null).getInputStream();
                ArtifactoryModel.GavcResults gavcResults = results = stream == null ? null : (ArtifactoryModel.GavcResults)gson.fromJson((Reader)new InputStreamReader(stream), ArtifactoryModel.GavcResults.class);
                if (results != null && results.results != null) {
                    for (ArtifactoryModel.GavcResult result : results.results) {
                        if (!result.uri.endsWith(packaging)) continue;
                        artifacts.add(ArtifactoryRepositoryService.convertArtifactInfo(result.uri, url, null));
                    }
                }
            } else {
                ArtifactoryModel.ArchiveResults results;
                String searchString = className.endsWith("*") || className.endsWith("?") ? className : className + ".class";
                InputStream stream = new Endpoint.Search.Archive(url).getArchiveSearchResultJson(searchString, null).getInputStream();
                ArtifactoryModel.ArchiveResults archiveResults = results = stream == null ? null : (ArtifactoryModel.ArchiveResults)gson.fromJson((Reader)new InputStreamReader(stream), ArtifactoryModel.ArchiveResults.class);
                if (results != null && results.results != null) {
                    for (ArtifactoryModel.ArchiveResult result : results.results) {
                        for (String uri : result.archiveUris) {
                            if (!uri.endsWith(packaging)) continue;
                            artifacts.add(ArtifactoryRepositoryService.convertArtifactInfo(uri, url, result.entry));
                        }
                    }
                }
            }
            return artifacts;
        }
        catch (JsonSyntaxException e) {
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static MavenArtifactInfo convertArtifactInfo(String uri, String baseUri, String className) throws IOException {
        int repoIndex;
        String repoPathFile = uri.substring((baseUri + "storage/").length());
        String repoString = repoPathFile.substring(0, repoIndex = repoPathFile.indexOf(47));
        String repo = repoString.endsWith("-cache") ? repoString.substring(0, repoString.lastIndexOf(45)) : repoString;
        String filePath = repoPathFile.substring(repoIndex + 1, repoPathFile.lastIndexOf(47));
        int artIdIndex = filePath.lastIndexOf(47);
        String version = filePath.substring(artIdIndex + 1);
        String groupArtifact = filePath.substring(0, artIdIndex);
        int groupIndex = groupArtifact.lastIndexOf(47);
        String artifact = groupArtifact.substring(groupIndex + 1);
        String group = groupArtifact.substring(0, groupIndex).replace('/', '.');
        String packaging = uri.substring(uri.lastIndexOf(46) + 1);
        return new MavenArtifactInfo(group, artifact, version, packaging, null, className, repo);
    }
}

