/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public class AddFileAsMavenProjectAction
extends MavenAction {
    public void actionPerformed(AnActionEvent e) {
        DataContext context = e.getDataContext();
        MavenProjectsManager manager = MavenActionUtil.getProjectsManager(context);
        if (manager != null) {
            manager.addManagedFilesOrUnignore(Collections.singletonList(AddFileAsMavenProjectAction.getSelectedFile(context)));
        }
    }

    @Override
    protected boolean isAvailable(AnActionEvent e) {
        DataContext context = e.getDataContext();
        VirtualFile file = AddFileAsMavenProjectAction.getSelectedFile(context);
        return super.isAvailable(e) && MavenActionUtil.isMavenProjectFile(file) && !AddFileAsMavenProjectAction.isExistingProjectFile(context, file);
    }

    @Override
    protected boolean isVisible(AnActionEvent e) {
        return super.isVisible(e) && this.isAvailable(e);
    }

    private static boolean isExistingProjectFile(DataContext context, VirtualFile file) {
        MavenProjectsManager manager = MavenActionUtil.getProjectsManager(context);
        return manager != null && manager.findProject(file) != null;
    }

    private static VirtualFile getSelectedFile(DataContext context) {
        return (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
    }
}

