/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MavenTestConsoleFilter
implements Filter {
    private static final Pattern REPORT_DIR_PATTERN = Pattern.compile("\\s*(?:\\[INFO\\] +Surefire report directory:|\\[ERROR\\] Please refer to) +(.+?)(?: for the individual test results.)?\\s*");
    private String myReportFolder;
    private boolean myFailedTestsList;
    private final Project myProject;

    public MavenTestConsoleFilter(Project project) {
        this.myProject = project;
    }

    public Filter.Result applyFilter(String line, int entireLength) {
        Matcher matcherReportDir = REPORT_DIR_PATTERN.matcher(line);
        if (matcherReportDir.matches()) {
            String path;
            this.myReportFolder = path = matcherReportDir.group(1);
            return new Filter.Result(entireLength - line.length() + matcherReportDir.start(1), entireLength - line.length() + matcherReportDir.end(1), new HyperlinkInfo(){

                public void navigate(Project project) {
                    File f = new File(path);
                    if (f.isDirectory()) {
                        ShowFilePathAction.openDirectory((File)f);
                    }
                }
            });
        }
        return null;
    }
}

