/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenParentDesc;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;

public abstract class MavenParentProjectFileProcessor<RESULT_TYPE> {
    public RESULT_TYPE process(MavenGeneralSettings generalSettings, VirtualFile projectFile, MavenParentDesc parentDesc) {
        VirtualFile superPom = generalSettings.getEffectiveSuperPom();
        if (superPom == null || projectFile.equals(superPom)) {
            return null;
        }
        RESULT_TYPE result = null;
        if (parentDesc == null) {
            return this.processSuperParent(superPom);
        }
        VirtualFile parentFile = this.findManagedFile(parentDesc.getParentId());
        if (parentFile != null) {
            result = this.processManagedParent(parentFile);
        }
        if (result == null) {
            parentFile = projectFile.getParent().findFileByRelativePath(parentDesc.getParentRelativePath());
            if (parentFile != null && parentFile.isDirectory()) {
                parentFile = parentFile.findFileByRelativePath("pom.xml");
            }
            if (parentFile != null) {
                result = this.processRelativeParent(parentFile);
            }
        }
        if (result == null) {
            File parentIoFile = MavenArtifactUtil.getArtifactFile(generalSettings.getEffectiveLocalRepository(), parentDesc.getParentId(), "pom");
            parentFile = LocalFileSystem.getInstance().findFileByIoFile(parentIoFile);
            if (parentFile != null) {
                result = this.processRepositoryParent(parentFile);
            }
        }
        return result;
    }

    protected abstract VirtualFile findManagedFile(MavenId var1);

    protected RESULT_TYPE processManagedParent(VirtualFile parentFile) {
        return this.doProcessParent(parentFile);
    }

    protected RESULT_TYPE processRelativeParent(VirtualFile parentFile) {
        return this.doProcessParent(parentFile);
    }

    protected RESULT_TYPE processRepositoryParent(VirtualFile parentFile) {
        return this.doProcessParent(parentFile);
    }

    protected RESULT_TYPE processSuperParent(VirtualFile parentFile) {
        return this.doProcessParent(parentFile);
    }

    protected abstract RESULT_TYPE doProcessParent(VirtualFile var1);
}

