/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.externalSystem.service.ui.ExternalSystemJdkComboBox;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.idea.maven.project.AdditionalMavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettingsForm;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.server.MavenServerManager;

public class MavenImportingConfigurable
implements SearchableConfigurable {
    private final MavenImportingSettings myImportingSettings;
    private final MavenImportingSettingsForm mySettingsForm = new MavenImportingSettingsForm(false, false);
    private final List<UnnamedConfigurable> myAdditionalConfigurables;
    private final JTextField myEmbedderVMOptions;
    private final ExternalSystemJdkComboBox myEmbedderJdk;

    public MavenImportingConfigurable(Project project) {
        this.myImportingSettings = MavenProjectsManager.getInstance(project).getImportingSettings();
        this.myAdditionalConfigurables = new ArrayList<UnnamedConfigurable>();
        for (AdditionalMavenImportingSettings additionalSettings : (AdditionalMavenImportingSettings[])AdditionalMavenImportingSettings.EP_NAME.getExtensions()) {
            this.myAdditionalConfigurables.add(additionalSettings.createConfigurable(project));
        }
        this.myEmbedderVMOptions = new JTextField(30);
        this.myEmbedderJdk = new ExternalSystemJdkComboBox();
        assert (this.myEmbedderJdk.getProject() == null);
    }

    public JComponent createComponent() {
        JPanel panel = this.mySettingsForm.getAdditionalSettingsPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(Box.createVerticalStrut(5));
        JPanel useMaven3Panel = new JPanel(new BorderLayout());
        panel.add(useMaven3Panel);
        JPanel embedderVMOptionPanel = new JPanel(new BorderLayout());
        JLabel vmOptionLabel = new JLabel("VM options for importer:");
        embedderVMOptionPanel.add((Component)vmOptionLabel, "West");
        vmOptionLabel.setLabelFor(this.myEmbedderVMOptions);
        embedderVMOptionPanel.add(this.myEmbedderVMOptions);
        panel.add(Box.createVerticalStrut(3));
        panel.add(embedderVMOptionPanel);
        JPanel embedderJdkPanel = new JPanel(new BorderLayout());
        JLabel embedderJdkLabel = new JLabel("JDK for importer:");
        embedderJdkLabel.setLabelFor((Component)this.myEmbedderJdk);
        embedderJdkPanel.add((Component)embedderJdkLabel, "West");
        embedderJdkPanel.add((Component)this.myEmbedderJdk);
        panel.add(Box.createVerticalStrut(3));
        panel.add(embedderJdkPanel);
        for (UnnamedConfigurable additionalConfigurable : this.myAdditionalConfigurables) {
            panel.add(Box.createVerticalStrut(3));
            panel.add(additionalConfigurable.createComponent());
        }
        return this.mySettingsForm.createComponent();
    }

    public void disposeUIResources() {
        for (UnnamedConfigurable additionalConfigurable : this.myAdditionalConfigurables) {
            additionalConfigurable.disposeUIResources();
        }
    }

    public boolean isModified() {
        for (UnnamedConfigurable additionalConfigurable : this.myAdditionalConfigurables) {
            if (!additionalConfigurable.isModified()) continue;
            return true;
        }
        if (!MavenServerManager.getInstance().getMavenEmbedderVMOptions().equals(this.myEmbedderVMOptions.getText())) {
            return true;
        }
        if (!MavenServerManager.getInstance().getEmbedderJdk().equals(this.myEmbedderJdk.getSelectedValue())) {
            return true;
        }
        return this.mySettingsForm.isModified(this.myImportingSettings);
    }

    public void apply() throws ConfigurationException {
        this.mySettingsForm.getData(this.myImportingSettings);
        MavenServerManager.getInstance().setMavenEmbedderVMOptions(this.myEmbedderVMOptions.getText());
        String jdk = this.myEmbedderJdk.getSelectedValue();
        if (jdk != null) {
            MavenServerManager.getInstance().setEmbedderJdk(jdk);
        }
        for (UnnamedConfigurable additionalConfigurable : this.myAdditionalConfigurables) {
            additionalConfigurable.apply();
        }
    }

    public void reset() {
        this.mySettingsForm.setData(this.myImportingSettings);
        this.myEmbedderVMOptions.setText(MavenServerManager.getInstance().getMavenEmbedderVMOptions());
        this.myEmbedderJdk.refreshData(MavenServerManager.getInstance().getEmbedderJdk());
        for (UnnamedConfigurable additionalConfigurable : this.myAdditionalConfigurables) {
            additionalConfigurable.reset();
        }
    }

    public String getDisplayName() {
        return ProjectBundle.message("maven.tab.importing", new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settings.project.maven.importing";
    }

    public String getId() {
        return this.getHelpTopic();
    }

    public Runnable enableSearch(String option) {
        return null;
    }
}

