/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.MavenUIUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.Strings;

public class MavenIgnoredFilesConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private static final char SEPARATOR = ',';
    private final MavenProjectsManager myManager;
    private Collection<String> myOriginallyIgnoredFilesPaths;
    private String myOriginallyIgnoredFilesPatterns;
    private JPanel myMainPanel;
    private ElementsChooser<String> myIgnoredFilesPathsChooser;
    private JTextArea myIgnoredFilesPattersEditor;

    public MavenIgnoredFilesConfigurable(Project project) {
        this.$$$setupUI$$$();
        this.myManager = MavenProjectsManager.getInstance(project);
    }

    private void createUIComponents() {
        this.myIgnoredFilesPathsChooser = new ElementsChooser(true);
        this.myIgnoredFilesPathsChooser.getEmptyText().setText(ProjectBundle.message("maven.ingored.no.file", new Object[0]));
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public void disposeUIResources() {
    }

    public boolean isModified() {
        return !MavenUtil.equalAsSets(this.myOriginallyIgnoredFilesPaths, this.myIgnoredFilesPathsChooser.getMarkedElements()) || !this.myOriginallyIgnoredFilesPatterns.equals(this.myIgnoredFilesPattersEditor.getText());
    }

    public void apply() throws ConfigurationException {
        this.myManager.setIgnoredFilesPaths(this.myIgnoredFilesPathsChooser.getMarkedElements());
        this.myManager.setIgnoredFilesPatterns(Strings.tokenize(this.myIgnoredFilesPattersEditor.getText(), " \t\n\r\f,"));
    }

    public void reset() {
        this.myOriginallyIgnoredFilesPaths = this.myManager.getIgnoredFilesPaths();
        this.myOriginallyIgnoredFilesPatterns = Strings.detokenize(this.myManager.getIgnoredFilesPatterns(), ',');
        MavenUIUtil.setElements(this.myIgnoredFilesPathsChooser, MavenUtil.collectPaths(this.myManager.getProjectsFiles()), this.myOriginallyIgnoredFilesPaths, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return FileUtil.comparePaths((String)o1, (String)o2);
            }
        });
        this.myIgnoredFilesPattersEditor.setText(this.myOriginallyIgnoredFilesPatterns);
    }

    public String getDisplayName() {
        return ProjectBundle.message("maven.tab.ignored.files", new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settings.project.maven.ignored.files";
    }

    public String getId() {
        return this.getHelpTopic();
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEmptyBorder(), (String)"Path patterns (comma-separated, '*' and '?' wildcards allowed)", (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(-1, 40), null));
        this.myIgnoredFilesPattersEditor = jTextArea = new JTextArea();
        jBScrollPane.setViewportView(jTextArea);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEmptyBorder(), (String)"Ignored files", (int)0, (int)0, null, null));
        ElementsChooser<String> elementsChooser = this.myIgnoredFilesPathsChooser;
        jPanel3.add((Component)elementsChooser, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

