/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.plugins.api;

import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.InjectedLanguagePlaces;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.xml.XmlText;
import org.jetbrains.idea.maven.plugins.api.MavenParamLanguageProvider;
import org.jetbrains.idea.maven.plugins.api.MavenPluginParamInfo;

public final class MavenPluginConfigurationLanguageInjector
implements LanguageInjector {
    public void getLanguagesToInject(PsiLanguageInjectionHost host, InjectedLanguagePlaces injectionPlacesRegistrar) {
        if (!(host instanceof XmlText)) {
            return;
        }
        XmlText xmlText = (XmlText)host;
        if (!MavenPluginParamInfo.isSimpleText(xmlText)) {
            return;
        }
        MavenPluginParamInfo.ParamInfoList infoList = MavenPluginParamInfo.getParamInfoList(xmlText);
        for (MavenPluginParamInfo.ParamInfo info : infoList) {
            MavenParamLanguageProvider provider;
            Language language = info.getLanguage();
            if (language == null && (provider = info.getLanguageProvider()) != null) {
                language = provider.getLanguage(xmlText, infoList.getDomCfg());
            }
            if (language == null) continue;
            injectionPlacesRegistrar.addPlace(language, TextRange.from((int)0, (int)host.getTextLength()), info.getLanguageInjectionPrefix(), info.getLanguageInjectionSuffix());
            return;
        }
    }
}

