/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetectionUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.idea.maven.importing.MavenDefaultModifiableModelsProvider;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class MavenFoldersImporter {
    private final MavenProject myMavenProject;
    private final MavenImportingSettings myImportingSettings;
    private final MavenRootModelAdapter myModel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateProjectFolders(Project project, boolean updateTargetFoldersOnly) {
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
        MavenImportingSettings settings = manager.getImportingSettings();
        AccessToken accessToken = WriteAction.start();
        try {
            ModifiableRootModel[] modelsArray;
            ArrayList<ModifiableRootModel> rootModels = new ArrayList<ModifiableRootModel>();
            for (Module each : ModuleManager.getInstance((Project)project).getModules()) {
                MavenProject mavenProject = manager.findProject(each);
                if (mavenProject == null) continue;
                MavenRootModelAdapter a = new MavenRootModelAdapter(mavenProject, each, new MavenDefaultModifiableModelsProvider(project));
                new MavenFoldersImporter(mavenProject, settings, a).config(updateTargetFoldersOnly);
                ModifiableRootModel model = a.getRootModel();
                if (model.isChanged()) {
                    rootModels.add(model);
                    continue;
                }
                model.dispose();
            }
            if (!rootModels.isEmpty() && (modelsArray = rootModels.toArray(new ModifiableRootModel[rootModels.size()])).length > 0) {
                ModifiableModelCommitter.multiCommit((ModifiableRootModel[])modelsArray, (ModifiableModuleModel)ModuleManager.getInstance((Project)modelsArray[0].getProject()).getModifiableModel());
            }
        }
        finally {
            accessToken.finish();
        }
    }

    public MavenFoldersImporter(MavenProject mavenProject, MavenImportingSettings settings, MavenRootModelAdapter model) {
        this.myMavenProject = mavenProject;
        this.myImportingSettings = settings;
        this.myModel = model;
    }

    public void config() {
        this.config(false);
    }

    private void config(boolean updateTargetFoldersOnly) {
        if (!updateTargetFoldersOnly) {
            if (!this.myImportingSettings.isKeepSourceFolders()) {
                this.myModel.clearSourceFolders();
            }
            this.configSourceFolders();
            this.configOutputFolders();
        }
        this.configGeneratedAndExcludedFolders();
    }

    private void configSourceFolders() {
        LinkedMultiMap roots = new LinkedMultiMap();
        roots.putValues((Object)JavaSourceRootType.SOURCE, this.myMavenProject.getSources());
        roots.putValues((Object)JavaSourceRootType.TEST_SOURCE, this.myMavenProject.getTestSources());
        for (MavenImporter mavenImporter : MavenImporter.getSuitableImporters(this.myMavenProject)) {
            mavenImporter.collectSourceRoots(this.myMavenProject, new PairConsumer<String, JpsModuleSourceRootType<?>>((MultiMap)roots){
                final /* synthetic */ MultiMap val$roots;
                {
                    this.val$roots = multiMap;
                }

                public void consume(String s, JpsModuleSourceRootType<?> type) {
                    this.val$roots.putValue(type, (Object)s);
                }
            });
        }
        for (MavenResource mavenResource : this.myMavenProject.getResources()) {
            roots.putValue((Object)JavaResourceRootType.RESOURCE, (Object)mavenResource.getDirectory());
        }
        for (MavenResource mavenResource : this.myMavenProject.getTestResources()) {
            roots.putValue((Object)JavaResourceRootType.TEST_RESOURCE, (Object)mavenResource.getDirectory());
        }
        this.addBuilderHelperPaths("add-source", roots.getModifiable((Object)JavaSourceRootType.SOURCE));
        this.addBuilderHelperPaths("add-test-source", roots.getModifiable((Object)JavaSourceRootType.TEST_SOURCE));
        ArrayList<String> addedPaths = new ArrayList<String>();
        for (JpsModuleSourceRootType type : roots.keySet()) {
            for (String path : roots.get((Object)type)) {
                this.addSourceFolderIfNotOverlap(path, type, addedPaths);
            }
        }
    }

    private void addBuilderHelperPaths(String goal, Collection<String> folders) {
        Element sourcesElement;
        Element configurationElement = this.myMavenProject.getPluginGoalConfiguration("org.codehaus.mojo", "build-helper-maven-plugin", goal);
        if (configurationElement != null && (sourcesElement = configurationElement.getChild("sources")) != null) {
            for (Element element : sourcesElement.getChildren()) {
                folders.add(element.getTextTrim());
            }
        }
    }

    private void addSourceFolderIfNotOverlap(String path, JpsModuleSourceRootType<?> type, List<String> addedPaths) {
        String canonicalPath = this.myModel.toPath(path).getPath();
        for (String existing : addedPaths) {
            if (!VfsUtilCore.isEqualOrAncestor((String)existing, (String)canonicalPath) && !VfsUtilCore.isEqualOrAncestor((String)canonicalPath, (String)existing)) continue;
            return;
        }
        addedPaths.add(canonicalPath);
        this.myModel.addSourceFolder(canonicalPath, type);
    }

    private void configOutputFolders() {
        String testOutputDirPath;
        String outputDirPath;
        String buildDirPath;
        if (this.myImportingSettings.isUseMavenOutput()) {
            this.myModel.useModuleOutput(this.myMavenProject.getOutputDirectory(), this.myMavenProject.getTestOutputDirectory());
        }
        if (!VfsUtilCore.isEqualOrAncestor((String)(buildDirPath = this.myModel.toPath(this.myMavenProject.getBuildDirectory()).getPath()), (String)(outputDirPath = this.myModel.toPath(this.myMavenProject.getOutputDirectory()).getPath()))) {
            this.myModel.addExcludedFolder(this.myMavenProject.getOutputDirectory());
        }
        if (!VfsUtilCore.isEqualOrAncestor((String)buildDirPath, (String)(testOutputDirPath = this.myModel.toPath(this.myMavenProject.getTestOutputDirectory()).getPath()))) {
            this.myModel.addExcludedFolder(this.myMavenProject.getTestOutputDirectory());
        }
    }

    private void configGeneratedAndExcludedFolders() {
        File[] targetChildren;
        File targetDir = new File(this.myMavenProject.getBuildDirectory());
        String generatedDir = this.myMavenProject.getGeneratedSourcesDirectory(false);
        String generatedDirTest = this.myMavenProject.getGeneratedSourcesDirectory(true);
        this.myModel.unregisterAll(targetDir.getPath(), false, false);
        if (this.myImportingSettings.getGeneratedSourcesFolder() != MavenImportingSettings.GeneratedSourcesFolder.IGNORE) {
            this.myModel.addGeneratedJavaSourceFolder(this.myMavenProject.getAnnotationProcessorDirectory(true), JavaSourceRootType.TEST_SOURCE);
            this.myModel.addGeneratedJavaSourceFolder(this.myMavenProject.getAnnotationProcessorDirectory(false), JavaSourceRootType.SOURCE);
        }
        if ((targetChildren = targetDir.listFiles()) != null) {
            for (File f : targetChildren) {
                if (!f.isDirectory()) continue;
                if (FileUtil.pathsEqual((String)generatedDir, (String)f.getPath())) {
                    this.configGeneratedSourceFolder(f, JavaSourceRootType.SOURCE);
                    continue;
                }
                if (FileUtil.pathsEqual((String)generatedDirTest, (String)f.getPath())) {
                    this.configGeneratedSourceFolder(f, JavaSourceRootType.TEST_SOURCE);
                    continue;
                }
                if (!this.myImportingSettings.isExcludeTargetFolder() || this.myModel.hasRegisteredSourceSubfolder(f) || this.myModel.isAlreadyExcluded(f)) continue;
                this.myModel.addExcludedFolder(f.getPath());
            }
        }
        ArrayList<String> facetExcludes = new ArrayList<String>();
        for (MavenImporter each : MavenImporter.getSuitableImporters(this.myMavenProject)) {
            each.collectExcludedFolders(this.myMavenProject, facetExcludes);
        }
        for (String eachFolder : facetExcludes) {
            this.myModel.unregisterAll(eachFolder, true, true);
            this.myModel.addExcludedFolder(eachFolder);
        }
        if (this.myImportingSettings.isExcludeTargetFolder() && !this.myModel.hasRegisteredSourceSubfolder(targetDir)) {
            this.myModel.addExcludedFolder(targetDir.getPath());
        }
    }

    private void configGeneratedSourceFolder(File targetDir, JavaSourceRootType rootType) {
        switch (this.myImportingSettings.getGeneratedSourcesFolder()) {
            case GENERATED_SOURCE_FOLDER: {
                this.myModel.addGeneratedJavaSourceFolder(targetDir.getPath(), rootType);
                break;
            }
            case SUBFOLDER: {
                this.addAllSubDirsAsGeneratedSources(targetDir, rootType);
                break;
            }
            case AUTODETECT: {
                Collection sourceRoots = JavaSourceRootDetectionUtil.suggestRoots((File)targetDir);
                for (JavaModuleSourceRoot root : sourceRoots) {
                    if (FileUtil.filesEqual((File)targetDir, (File)root.getDirectory())) {
                        this.myModel.addGeneratedJavaSourceFolder(targetDir.getPath(), rootType);
                        return;
                    }
                    this.addAsGeneratedSourceFolder(root.getDirectory(), rootType);
                }
                this.addAllSubDirsAsGeneratedSources(targetDir, rootType);
                break;
            }
        }
    }

    private void addAsGeneratedSourceFolder(File dir, JavaSourceRootType rootType) {
        SourceFolder folder = this.myModel.getSourceFolder(dir);
        if (!this.myModel.hasRegisteredSourceSubfolder(dir) || folder != null && !MavenFoldersImporter.isGenerated(folder)) {
            this.myModel.addGeneratedJavaSourceFolder(dir.getPath(), rootType);
        }
    }

    private static boolean isGenerated(SourceFolder folder) {
        JavaSourceRootProperties properties = (JavaSourceRootProperties)folder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES);
        return properties != null && properties.isForGeneratedSources();
    }

    private void addAllSubDirsAsGeneratedSources(File dir, JavaSourceRootType rootType) {
        for (File f : MavenFoldersImporter.getChildren(dir)) {
            if (!f.isDirectory()) continue;
            this.addAsGeneratedSourceFolder(f, rootType);
        }
    }

    private static File[] getChildren(File dir) {
        File[] result = dir.listFiles();
        return result == null ? ArrayUtil.EMPTY_FILE_ARRAY : result;
    }
}

