/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MavenRunnerSettings
implements Cloneable {
    public static final String USE_INTERNAL_JAVA = "#JAVA_INTERNAL";
    public static final String USE_PROJECT_JDK = "#USE_PROJECT_JDK";
    public static final String USE_JAVA_HOME = "#JAVA_HOME";
    private boolean runMavenInBackground = true;
    private String jreName = "#USE_PROJECT_JDK";
    private String vmOptions = "";
    private boolean skipTests = false;
    private Map<String, String> mavenProperties = new LinkedHashMap<String, String>();
    private Map<String, String> environmentProperties = new HashMap();
    private boolean passParentEnv = true;
    private List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public boolean isRunMavenInBackground() {
        return this.runMavenInBackground;
    }

    public void setRunMavenInBackground(boolean runMavenInBackground) {
        this.runMavenInBackground = runMavenInBackground;
    }

    public String getJreName() {
        return this.jreName;
    }

    public void setJreName(String jreName) {
        if (jreName != null) {
            this.jreName = jreName;
        }
    }

    public String getVmOptions() {
        return this.vmOptions;
    }

    public void setVmOptions(String vmOptions) {
        if (vmOptions != null) {
            this.vmOptions = vmOptions;
        }
    }

    public boolean isSkipTests() {
        return this.skipTests;
    }

    public void setSkipTests(boolean skipTests) {
        if (skipTests != this.skipTests) {
            this.fireSkipTestsChanged();
        }
        this.skipTests = skipTests;
    }

    public Map<String, String> getMavenProperties() {
        return this.mavenProperties;
    }

    public void setMavenProperties(Map<String, String> mavenProperties) {
        this.mavenProperties = mavenProperties;
    }

    public Map<String, String> getEnvironmentProperties() {
        return this.environmentProperties;
    }

    public void setEnvironmentProperties(Map<String, String> envs) {
        if (envs == this.environmentProperties) {
            return;
        }
        this.environmentProperties.clear();
        this.environmentProperties.putAll(envs);
    }

    public boolean isPassParentEnv() {
        return this.passParentEnv;
    }

    public void setPassParentEnv(boolean passParentEnv) {
        this.passParentEnv = passParentEnv;
    }

    public void addListener(Listener l) {
        this.myListeners.add(l);
    }

    public void removeListener(Listener l) {
        this.myListeners.remove(l);
    }

    private void fireSkipTestsChanged() {
        for (Listener each : this.myListeners) {
            each.skipTestsChanged();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenRunnerSettings that = (MavenRunnerSettings)o;
        if (this.runMavenInBackground != that.runMavenInBackground) {
            return false;
        }
        if (this.skipTests != that.skipTests) {
            return false;
        }
        if (!this.jreName.equals(that.jreName)) {
            return false;
        }
        if (this.mavenProperties != null ? !((Object)this.mavenProperties).equals(that.mavenProperties) : that.mavenProperties != null) {
            return false;
        }
        if (!this.vmOptions.equals(that.vmOptions)) {
            return false;
        }
        if (!((Object)this.environmentProperties).equals(that.environmentProperties)) {
            return false;
        }
        return this.passParentEnv == that.passParentEnv;
    }

    public int hashCode() {
        int result = this.runMavenInBackground ? 1 : 0;
        result = 31 * result + this.jreName.hashCode();
        result = 31 * result + this.vmOptions.hashCode();
        result = 31 * result + (this.skipTests ? 1 : 0);
        result = 31 * result + ((Object)this.environmentProperties).hashCode();
        result = 31 * result + (this.mavenProperties != null ? ((Object)this.mavenProperties).hashCode() : 0);
        return result;
    }

    public MavenRunnerSettings clone() {
        try {
            MavenRunnerSettings clone = (MavenRunnerSettings)super.clone();
            clone.mavenProperties = MavenRunnerSettings.cloneMap(this.mavenProperties);
            clone.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
            clone.environmentProperties = new HashMap(this.environmentProperties);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    private static <K, V> Map<K, V> cloneMap(Map<K, V> source) {
        LinkedHashMap<K, V> clone = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry : source.entrySet()) {
            clone.put(entry.getKey(), entry.getValue());
        }
        return clone;
    }

    public static interface Listener {
        public void skipTestsChanged();
    }
}

