/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.utils.Path;

public class MavenRunnerParameters
implements Cloneable {
    private boolean isPomExecution;
    private Path myWorkingDirPath;
    private final List<String> myGoals = new ArrayList<String>();
    private boolean myResolveToWorkspace;
    private final Map<String, Boolean> myProfilesMap = new LinkedHashMap<String, Boolean>();
    private final Collection<String> myEnabledProfilesForXmlSerializer = new TreeSet<String>();

    public MavenRunnerParameters() {
        this(true, "", null, null, null);
    }

    public MavenRunnerParameters(boolean isPomExecution, String workingDirPath, List<String> goals, Collection<String> explicitEnabledProfiles) {
        this(isPomExecution, workingDirPath, goals, explicitEnabledProfiles, null);
    }

    public MavenRunnerParameters(boolean isPomExecution, String workingDirPath, List<String> goals, MavenExplicitProfiles explicitProfiles) {
        this(isPomExecution, workingDirPath, goals, explicitProfiles.getEnabledProfiles(), explicitProfiles.getDisabledProfiles());
    }

    public MavenRunnerParameters(boolean isPomExecution, String workingDirPath, List<String> goals, Collection<String> explicitEnabledProfiles, Collection<String> explicitDisabledProfiles) {
        this.isPomExecution = isPomExecution;
        this.setWorkingDirPath(workingDirPath);
        this.setGoals(goals);
        if (explicitEnabledProfiles != null) {
            for (String profile : explicitEnabledProfiles) {
                this.myProfilesMap.put(profile, Boolean.TRUE);
            }
        }
        if (explicitDisabledProfiles != null) {
            for (String profile : explicitDisabledProfiles) {
                this.myProfilesMap.put(profile, Boolean.FALSE);
            }
        }
    }

    public MavenRunnerParameters(String workingDirPath, boolean isPomExecution, List<String> goals, Map<String, Boolean> profilesMap) {
        this.isPomExecution = isPomExecution;
        this.setWorkingDirPath(workingDirPath);
        this.setGoals(goals);
        this.setProfilesMap(profilesMap);
    }

    public MavenRunnerParameters(MavenRunnerParameters that) {
        this(that.getWorkingDirPath(), that.isPomExecution, that.myGoals, that.myProfilesMap);
        this.myResolveToWorkspace = that.myResolveToWorkspace;
    }

    public boolean isPomExecution() {
        return this.isPomExecution;
    }

    public String getWorkingDirPath() {
        return this.myWorkingDirPath.getPath();
    }

    public void setWorkingDirPath(String workingDirPath) {
        this.myWorkingDirPath = new Path(workingDirPath);
    }

    public File getWorkingDirFile() {
        return new File(this.myWorkingDirPath.getPath());
    }

    public List<String> getGoals() {
        return this.myGoals;
    }

    public void setGoals(List<String> goals) {
        if (this.myGoals == goals) {
            return;
        }
        this.myGoals.clear();
        if (goals != null) {
            this.myGoals.addAll(goals);
        }
    }

    @Deprecated
    @OptionTag(value="profiles")
    public Collection<String> getEnabledProfilesForXmlSerializer() {
        return this.myEnabledProfilesForXmlSerializer;
    }

    @Deprecated
    public void setEnabledProfilesForXmlSerializer(Collection<String> enabledProfilesForXmlSerializer) {
        if (enabledProfilesForXmlSerializer != null) {
            if (this.myEnabledProfilesForXmlSerializer == enabledProfilesForXmlSerializer) {
                return;
            }
            this.myEnabledProfilesForXmlSerializer.retainAll(enabledProfilesForXmlSerializer);
            this.myEnabledProfilesForXmlSerializer.addAll(enabledProfilesForXmlSerializer);
        }
    }

    public void fixAfterLoadingFromOldFormat() {
        for (String profile : this.myEnabledProfilesForXmlSerializer) {
            this.myProfilesMap.put(profile, true);
        }
        this.myEnabledProfilesForXmlSerializer.clear();
        File workingDir = this.getWorkingDirFile();
        if ("pom.xml".equals(workingDir.getName())) {
            this.setWorkingDirPath(workingDir.getParent());
        }
    }

    @OptionTag(value="profilesMap")
    @MapAnnotation(sortBeforeSave=false)
    public Map<String, Boolean> getProfilesMap() {
        return this.myProfilesMap;
    }

    public void setProfilesMap(Map<String, Boolean> profilesMap) {
        if (this.myProfilesMap == profilesMap) {
            return;
        }
        this.myProfilesMap.clear();
        for (Map.Entry<String, Boolean> entry : profilesMap.entrySet()) {
            if (entry.getValue() == null) continue;
            this.myProfilesMap.put(entry.getKey(), entry.getValue());
        }
    }

    @Transient
    public Collection<String> getProfiles() {
        return Maps.filterValues(this.myProfilesMap, (Predicate)Predicates.equalTo((Object)true)).keySet();
    }

    public void setProfiles(Collection<String> profiles) {
        if (profiles != null) {
            for (String profile : profiles) {
                this.myProfilesMap.put(profile, true);
            }
        }
    }

    public boolean isResolveToWorkspace() {
        return this.myResolveToWorkspace;
    }

    public void setResolveToWorkspace(boolean resolveToWorkspace) {
        this.myResolveToWorkspace = resolveToWorkspace;
    }

    public MavenRunnerParameters clone() {
        return new MavenRunnerParameters(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenRunnerParameters that = (MavenRunnerParameters)o;
        if (this.isPomExecution != that.isPomExecution) {
            return false;
        }
        if (this.myResolveToWorkspace != that.myResolveToWorkspace) {
            return false;
        }
        if (!((Object)this.myGoals).equals(that.myGoals)) {
            return false;
        }
        if (this.myWorkingDirPath != null ? !this.myWorkingDirPath.equals(that.myWorkingDirPath) : that.myWorkingDirPath != null) {
            return false;
        }
        return ((Object)this.myProfilesMap).equals(that.myProfilesMap);
    }

    public int hashCode() {
        int result = this.isPomExecution ? 1 : 0;
        result = 31 * result + (this.myWorkingDirPath != null ? this.myWorkingDirPath.hashCode() : 0);
        result = 31 * result + ((Object)this.myGoals).hashCode();
        result = 31 * result + ((Object)this.myProfilesMap).hashCode();
        return result;
    }
}

