/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.ui.components.JBTabbedPane;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;

public class CompositeConfigurable
implements Configurable {
    private final List<Configurable> configurables = new ArrayList<Configurable>();
    private JTabbedPane tabbedPane;
    private int selectedTabIndex = 0;

    public CompositeConfigurable(Configurable ... configurables) {
        for (Configurable configurable : configurables) {
            this.registerConfigurable(configurable);
        }
    }

    public void registerConfigurable(Configurable configurable) {
        this.configurables.add(configurable);
    }

    public JComponent createComponent() {
        this.tabbedPane = new JBTabbedPane();
        for (Configurable configurable : this.configurables) {
            JComponent component = configurable.createComponent();
            this.tabbedPane.add(configurable.getDisplayName(), component);
        }
        return this.tabbedPane;
    }

    public boolean isModified() {
        for (Configurable configurable : this.configurables) {
            if (!configurable.isModified()) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        for (Configurable configurable : this.configurables) {
            configurable.apply();
        }
        this.selectedTabIndex = this.tabbedPane.getSelectedIndex();
    }

    public void reset() {
        for (Configurable configurable : this.configurables) {
            configurable.reset();
        }
        this.tabbedPane.setSelectedIndex(this.selectedTabIndex);
    }

    public void disposeUIResources() {
        for (Configurable configurable : this.configurables) {
            configurable.disposeUIResources();
        }
        this.tabbedPane = null;
    }

    public String getHelpTopic() {
        return this.selectedTabIndex < this.configurables.size() ? this.configurables.get(this.selectedTabIndex).getHelpTopic() : null;
    }

    public String getDisplayName() {
        return null;
    }
}

