/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import gnu.trove.THashSet;
import icons.MavenIcons;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenSchemaProvider;
import org.jetbrains.idea.maven.dom.model.MavenDomConfiguration;
import org.jetbrains.idea.maven.dom.model.MavenDomProfile;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomSettingsModel;
import org.jetbrains.idea.maven.dom.references.MavenModelClassesProperties;
import org.jetbrains.idea.maven.dom.references.MavenPsiElementWrapper;
import org.jetbrains.idea.maven.dom.references.MavenPsiReference;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.plugins.api.MavenPluginDescriptor;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.vfs.MavenPropertiesVirtualFileSystem;

public class MavenPropertyPsiReference
extends MavenPsiReference {
    public static final String TIMESTAMP_PROP = "maven.build.timestamp";
    protected final MavenDomProjectModel myProjectDom;
    protected final MavenProject myMavenProject;
    private final boolean mySoft;

    public MavenPropertyPsiReference(MavenProject mavenProject, PsiElement element, String text, TextRange range, boolean isSoft) {
        super(element, text, range);
        this.myMavenProject = mavenProject;
        this.mySoft = isSoft;
        this.myProjectDom = MavenDomUtil.getMavenDomProjectModel(this.myProject, mavenProject.getFile());
    }

    public PsiElement resolve() {
        PsiElement result = this.doResolve();
        if (result == null && MavenDomUtil.isMavenFile(this.getElement()) && (result = this.tryResolveToActivationSection()) == null) {
            return null;
        }
        if (result instanceof XmlTag) {
            XmlTagChild[] children = ((XmlTag)result).getValue().getChildren();
            if (children.length != 1 || !(children[0] instanceof Navigatable)) {
                return result;
            }
            return new MavenPsiElementWrapper(result, (Navigatable)children[0]);
        }
        return result;
    }

    private PsiElement tryResolveToActivationSection() {
        for (XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlTag.class); xmlTag != null; xmlTag = xmlTag.getParentTag()) {
            if (!xmlTag.getName().equals("profile")) continue;
            XmlTag activation = xmlTag.findFirstSubTag("activation");
            if (activation == null) break;
            for (XmlTag propertyTag : activation.findSubTags("property")) {
                XmlTag nameTag = propertyTag.findFirstSubTag("name");
                if (nameTag == null || !nameTag.getValue().getTrimmedText().equals(this.myText)) continue;
                return nameTag;
            }
            break;
        }
        return null;
    }

    protected PsiElement doResolve() {
        PsiElement res;
        MavenDomProjectModel domProjectModel;
        PsiElement element;
        XmlTag result;
        boolean notFound;
        XmlTag result2;
        PsiElement res2;
        MavenDomProjectModel domProjectModel2;
        boolean hasPrefix = false;
        String unprefixed = this.myText;
        if (this.myText.startsWith("pom.")) {
            unprefixed = this.myText.substring("pom.".length());
            hasPrefix = true;
        } else if (this.myText.startsWith("project.")) {
            unprefixed = this.myText.substring("project.".length());
            hasPrefix = true;
        }
        MavenProject mavenProject = this.myMavenProject;
        while (!(!unprefixed.startsWith("parent.") || unprefixed.equals("parent.groupId") || unprefixed.equals("parent.artifactId") || unprefixed.equals("parent.version") || unprefixed.equals("parent.relativePath"))) {
            MavenId parentId = mavenProject.getParentId();
            if (parentId == null) {
                return null;
            }
            mavenProject = this.myProjectsManager.findProject(parentId);
            if (mavenProject == null) {
                return null;
            }
            unprefixed = unprefixed.substring("parent.".length());
        }
        if (unprefixed.equals("basedir") || hasPrefix && mavenProject == this.myMavenProject && unprefixed.equals("baseUri")) {
            return this.getBaseDir(mavenProject);
        }
        if (this.myText.equals(TIMESTAMP_PROP)) {
            return this.myElement;
        }
        if (hasPrefix && (domProjectModel2 = MavenDomUtil.getMavenDomProjectModel(this.myProject, mavenProject.getFile())) != null && (res2 = this.resolveModelProperty(domProjectModel2, unprefixed, new HashSet<DomElement>())) != null) {
            return res2;
        }
        MavenRunnerSettings runnerSettings = MavenRunner.getInstance(this.myProject).getSettings();
        if (runnerSettings.getMavenProperties().containsKey(this.myText) || runnerSettings.getVmOptions().contains("-D" + this.myText + '=')) {
            return this.myElement;
        }
        if (MavenUtil.getPropertiesFromMavenOpts().containsKey(this.myText)) {
            return this.myElement;
        }
        MavenDomProfile profile = (MavenDomProfile)DomUtil.findDomElement((PsiElement)this.myElement, MavenDomProfile.class);
        if (profile != null && (result2 = MavenDomProjectProcessorUtils.findProperty(profile.getProperties(), this.myText)) != null) {
            return result2;
        }
        MavenDomConfiguration pluginCfg = (MavenDomConfiguration)DomUtil.findDomElement((PsiElement)this.myElement, MavenDomConfiguration.class);
        if (pluginCfg != null && !(notFound = MavenPluginDescriptor.processDescriptors(new Processor<MavenPluginDescriptor>(){

            public boolean process(MavenPluginDescriptor descriptor) {
                if (descriptor.properties != null) {
                    for (MavenPluginDescriptor.ModelProperty property : descriptor.properties) {
                        if (!property.insideConfigurationOnly || !property.name.equals(MavenPropertyPsiReference.this.myText)) continue;
                        return false;
                    }
                }
                return true;
            }
        }, pluginCfg))) {
            return this.myElement;
        }
        if (this.myProjectDom != null && (result = MavenDomProjectProcessorUtils.searchProperty(this.myText, this.myProjectDom, this.myProject)) != null) {
            return result;
        }
        if ("java.home".equals(this.myText) && (element = this.resolveToCustomSystemProperty("java.home", MavenUtil.getModuleJreHome(this.myProjectsManager, mavenProject))) != null) {
            return element;
        }
        if ("java.version".equals(this.myText) && (element = this.resolveToCustomSystemProperty("java.version", MavenUtil.getModuleJavaVersion(this.myProjectsManager, mavenProject))) != null) {
            return element;
        }
        MavenPropertiesVirtualFileSystem mavenPropertiesVirtualFileSystem = MavenPropertiesVirtualFileSystem.getInstance();
        IProperty property = mavenPropertiesVirtualFileSystem.findSystemProperty(this.myProject, this.myText);
        if (property != null) {
            return property.getPsiElement();
        }
        if (this.myText.startsWith("env.") && (property = mavenPropertiesVirtualFileSystem.findEnvProperty(this.myProject, this.myText.substring("env.".length()))) != null) {
            return property.getPsiElement();
        }
        String textWithEnv = "env." + this.myText;
        property = mavenPropertiesVirtualFileSystem.findSystemProperty(this.myProject, textWithEnv);
        if (property != null) {
            return property.getPsiElement();
        }
        property = mavenPropertiesVirtualFileSystem.findEnvProperty(this.myProject, textWithEnv);
        if (property != null) {
            return property.getPsiElement();
        }
        if (!hasPrefix && (domProjectModel = MavenDomUtil.getMavenDomProjectModel(this.myProject, mavenProject.getFile())) != null && (res = this.resolveModelProperty(domProjectModel, unprefixed, new HashSet<DomElement>())) != null) {
            return res;
        }
        if (mavenProject.getProperties().containsKey(this.myText)) {
            return this.myElement;
        }
        if (this.myText.startsWith("settings.")) {
            return this.resolveSettingsModelProperty();
        }
        return null;
    }

    private PsiElement resolveToCustomSystemProperty(String propertyName, String propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        PsiFile propFile = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("SystemProperties.properties", (Language)PropertiesLanguage.INSTANCE, (CharSequence)(propertyName + '=' + propertyValue));
        return ((IProperty)((PropertiesFile)propFile).getProperties().get(0)).getPsiElement();
    }

    private PsiDirectory getBaseDir(MavenProject mavenProject) {
        return PsiManager.getInstance((Project)this.myProject).findDirectory(mavenProject.getDirectoryFile());
    }

    private PsiElement resolveSettingsModelProperty() {
        if (!this.schemaHasProperty("http://maven.apache.org/xsd/settings-1.0.0.xsd", this.myText)) {
            return null;
        }
        for (VirtualFile each : this.myProjectsManager.getGeneralSettings().getEffectiveSettingsFiles()) {
            XmlTag result;
            MavenDomSettingsModel settingsDom = MavenDomUtil.getMavenDomModel(this.myProject, each, MavenDomSettingsModel.class);
            if (settingsDom == null || (result = MavenDomUtil.findTag(settingsDom, this.myText)) == null) continue;
            return result;
        }
        return this.myElement;
    }

    private PsiElement resolveModelProperty(MavenDomProjectModel projectDom, final String path, final Set<DomElement> recursionGuard) {
        if (!recursionGuard.add(projectDom)) {
            return null;
        }
        String pathWithProjectPrefix = "project." + path;
        if (!(MavenModelClassesProperties.isPathValid("org.apache.maven.project.MavenProject", path) || MavenModelClassesProperties.isPathValid("org.apache.maven.model.Model", path) || this.schemaHasProperty("http://maven.apache.org/xsd/maven-4.0.0.xsd", pathWithProjectPrefix))) {
            return null;
        }
        XmlTag result = MavenDomUtil.findTag(projectDom, pathWithProjectPrefix);
        if (result != null) {
            return result;
        }
        if (pathWithProjectPrefix.equals("project.groupId") || pathWithProjectPrefix.equals("project.version")) {
            return MavenDomUtil.findTag(projectDom, "project.parent." + path);
        }
        result = (PsiElement)new MavenDomProjectProcessorUtils.DomParentProjectFileProcessor<PsiElement>(this.myProjectsManager){

            @Override
            protected PsiElement doProcessParent(VirtualFile parentFile) {
                MavenDomProjectModel parentProjectDom = MavenDomUtil.getMavenDomProjectModel(MavenPropertyPsiReference.this.myProject, parentFile);
                if (parentProjectDom == null) {
                    return null;
                }
                return MavenPropertyPsiReference.this.resolveModelProperty(parentProjectDom, path, recursionGuard);
            }
        }.process(projectDom);
        if (result != null) {
            return result;
        }
        return this.myElement;
    }

    private boolean schemaHasProperty(String schema, final String property) {
        return this.processSchema(schema, new SchemaProcessor<Boolean>(){

            @Override
            public Boolean process(String eachProperty, XmlElementDescriptor descriptor) {
                if (eachProperty.equals(property)) {
                    return true;
                }
                return null;
            }
        }) != null;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return ElementManipulators.getManipulator((PsiElement)this.myElement).handleContentChange(this.myElement, this.myRange, newElementName);
    }

    public Object[] getVariants() {
        ArrayList<Object> result = new ArrayList<Object>();
        this.collectVariants(result, (Set<String>)new THashSet());
        return ArrayUtil.toObjectArray(result);
    }

    protected void collectVariants(final List<Object> result, Set<String> variants) {
        int prefixLength = 0;
        if (this.myText.startsWith("pom.")) {
            prefixLength = "pom.".length();
        } else if (this.myText.startsWith("project.")) {
            prefixLength = "project.".length();
        }
        MavenProject mavenProject = this.myMavenProject;
        while (this.myText.startsWith("parent.", prefixLength)) {
            MavenId parentId = mavenProject.getParentId();
            if (parentId == null) {
                return;
            }
            mavenProject = this.myProjectsManager.findProject(parentId);
            if (mavenProject == null) {
                return;
            }
            prefixLength += "parent.".length();
        }
        final String prefix = prefixLength == 0 ? null : this.myText.substring(0, prefixLength);
        PsiDirectory baseDir = this.getBaseDir(mavenProject);
        MavenPropertyPsiReference.addVariant(result, "basedir", baseDir, prefix, MavenIcons.MavenLogo);
        if (prefix == null) {
            result.add(MavenPropertyPsiReference.createLookupElement(baseDir, "project.baseUri", MavenIcons.MavenLogo));
            result.add(MavenPropertyPsiReference.createLookupElement(baseDir, "pom.baseUri", MavenIcons.MavenLogo));
            result.add(LookupElementBuilder.create((String)TIMESTAMP_PROP).withIcon(MavenIcons.MavenLogo));
        }
        this.processSchema("http://maven.apache.org/xsd/maven-4.0.0.xsd", new SchemaProcessor<Object>(){

            @Override
            public Object process(String property, XmlElementDescriptor descriptor) {
                if (property.startsWith("project.")) {
                    MavenPropertyPsiReference.addVariant(result, property.substring("project.".length()), descriptor, prefix, MavenIcons.MavenLogo);
                }
                return null;
            }
        });
        this.processSchema("http://maven.apache.org/xsd/settings-1.0.0.xsd", new SchemaProcessor<Object>(){

            @Override
            public Object process(String property, XmlElementDescriptor descriptor) {
                result.add(MavenPropertyPsiReference.createLookupElement(descriptor, property, MavenIcons.MavenLogo));
                return null;
            }
        });
        this.collectPropertiesVariants(result, variants);
        this.collectSystemEnvProperties("System.properties", null, result, variants);
        this.collectSystemEnvProperties("Environment.properties", "env.", result, variants);
        MavenRunnerSettings runnerSettings = MavenRunner.getInstance(this.myProject).getSettings();
        for (String prop : runnerSettings.getMavenProperties().keySet()) {
            if (!variants.add(prefix)) continue;
            result.add(LookupElementBuilder.create((String)prop).withIcon(PlatformIcons.PROPERTY_ICON));
        }
        for (String prop : MavenUtil.getPropertiesFromMavenOpts().keySet()) {
            if (!variants.add(prop)) continue;
            result.add(LookupElementBuilder.create((String)prop).withIcon(PlatformIcons.PROPERTY_ICON));
        }
        for (Object key : this.myMavenProject.getProperties().keySet()) {
            String property;
            if (!(key instanceof String) || !variants.add(property = (String)key)) continue;
            result.add(LookupElementBuilder.create((String)property).withIcon(PlatformIcons.PROPERTY_ICON));
        }
        MavenDomConfiguration pluginCfg = (MavenDomConfiguration)DomUtil.findDomElement((PsiElement)this.myElement, MavenDomConfiguration.class);
        if (pluginCfg != null) {
            MavenPluginDescriptor.processDescriptors(new Processor<MavenPluginDescriptor>(){

                public boolean process(MavenPluginDescriptor descriptor) {
                    if (descriptor.properties != null) {
                        for (MavenPluginDescriptor.ModelProperty property : descriptor.properties) {
                            if (!property.insideConfigurationOnly) continue;
                            result.add(LookupElementBuilder.create((String)property.name).withIcon(PlatformIcons.PROPERTY_ICON));
                        }
                    }
                    return true;
                }
            }, pluginCfg);
        }
    }

    private static void addVariant(List<Object> result, String name, Object element, String prefix, Icon icon) {
        String nameWithPrefix;
        if (prefix == null) {
            nameWithPrefix = name;
            result.add(MavenPropertyPsiReference.createLookupElement(element, "pom." + name, icon));
            result.add(MavenPropertyPsiReference.createLookupElement(element, "project." + name, icon));
        } else {
            nameWithPrefix = prefix + name;
        }
        result.add(MavenPropertyPsiReference.createLookupElement(element, nameWithPrefix, icon));
    }

    private void collectPropertiesVariants(List<Object> result, Set<String> variants) {
        if (this.myProjectDom != null) {
            for (XmlTag xmlTag : MavenDomProjectProcessorUtils.collectProperties(this.myProjectDom, this.myProject)) {
                String propertyName = xmlTag.getName();
                if (!variants.add(propertyName)) continue;
                result.add(MavenPropertyPsiReference.createLookupElement(xmlTag, propertyName, PlatformIcons.PROPERTY_ICON));
            }
        }
    }

    private void collectSystemEnvProperties(String propertiesFileName, String prefix, List<Object> result, Set<String> variants) {
        VirtualFile virtualFile = MavenPropertiesVirtualFileSystem.getInstance().findFileByPath(propertiesFileName);
        PropertiesFile file = MavenDomUtil.getPropertiesFile(this.myProject, virtualFile);
        MavenPropertyPsiReference.collectPropertiesFileVariants(file, prefix, result, variants);
    }

    protected static void collectPropertiesFileVariants(PropertiesFile file, String prefix, List<Object> result, Set<String> variants) {
        if (file == null) {
            return;
        }
        for (IProperty each : file.getProperties()) {
            String name = each.getKey();
            if (name == null) continue;
            if (prefix != null) {
                name = prefix + name;
            }
            if (!variants.add(name)) continue;
            result.add(MavenPropertyPsiReference.createLookupElement(each, name, PlatformIcons.PROPERTY_ICON));
        }
    }

    private static LookupElement createLookupElement(Object element, String name, Icon icon) {
        return LookupElementBuilder.create((Object)element, (String)name).withIcon(icon).withPresentableText(name);
    }

    private <T> T processSchema(String schema, SchemaProcessor<T> processor) {
        VirtualFile file = MavenSchemaProvider.getSchemaFile(schema);
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        XmlDocument document = xmlFile.getDocument();
        XmlNSDescriptor desc = (XmlNSDescriptor)document.getMetaData();
        XmlElementDescriptor[] descriptors = desc.getRootElementsDescriptors(document);
        return MavenPropertyPsiReference.doProcessSchema(descriptors, null, processor, (Set<XmlElementDescriptor>)new THashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T doProcessSchema(XmlElementDescriptor[] descriptors, String prefix, SchemaProcessor<T> processor, Set<XmlElementDescriptor> recursionGuard) {
        for (XmlElementDescriptor each : descriptors) {
            if (MavenPropertyPsiReference.isCollection(each) || !recursionGuard.add(each)) continue;
            try {
                T result;
                String name = each.getName();
                if (prefix != null) {
                    name = prefix + "." + name;
                }
                if ((result = processor.process(name, each)) != null) {
                    T t = result;
                    return t;
                }
                result = MavenPropertyPsiReference.doProcessSchema(each.getElementsDescriptors(null), name, processor, recursionGuard);
                if (result == null) continue;
                T t = result;
                return t;
            }
            finally {
                recursionGuard.remove(each);
            }
        }
        return null;
    }

    private static boolean isCollection(XmlElementDescriptor each) {
        XmlTag complexType;
        XmlTag declaration = (XmlTag)each.getDeclaration();
        return declaration != null && (complexType = declaration.findFirstSubTag("xs:complexType")) != null && complexType.findFirstSubTag("xs:sequence") != null;
    }

    @Override
    public boolean isSoft() {
        return this.mySoft;
    }

    private static interface SchemaProcessor<T> {
        public T process(String var1, XmlElementDescriptor var2);
    }
}

