/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.idea.maven.dom.MavenDomElement;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProfiles;
import org.jetbrains.idea.maven.dom.model.MavenDomProfilesModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProperties;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;

public class MavenDomUtil {
    private static final Key<Pair<Long, Set<VirtualFile>>> FILTERED_RESOURCES_ROOTS_KEY = Key.create((String)"MavenDomUtil.FILTERED_RESOURCES_ROOTS");
    private static final Set<String> SUBTAGS_IN_SETTINGS_FILE = ContainerUtil.newHashSet((Object[])new String[]{"localRepository", "interactiveMode", "usePluginRegistry", "offline", "pluginGroups", "servers", "mirrors", "proxies", "profiles", "activeProfiles"});
    private static final Pattern XML_TAG_NAME_PATTERN = Pattern.compile("(\\S*)\\[(\\d*)\\]\\z");

    public static boolean isMavenFile(PsiFile file) {
        return MavenDomUtil.isProjectFile(file) || MavenDomUtil.isProfilesFile(file) || MavenDomUtil.isSettingsFile(file);
    }

    public static boolean isProjectFile(PsiFile file) {
        if (!(file instanceof XmlFile)) {
            return false;
        }
        String name = file.getName();
        return name.equals("pom.xml") || name.endsWith(".pom") || name.equals("pom-4.0.0.xml");
    }

    public static boolean isProfilesFile(PsiFile file) {
        if (!(file instanceof XmlFile)) {
            return false;
        }
        return "profiles.xml".equals(file.getName());
    }

    public static boolean isSettingsFile(PsiFile file) {
        if (!(file instanceof XmlFile)) {
            return false;
        }
        String name = file.getName();
        if (!name.equals("settings.xml")) {
            return false;
        }
        XmlTag rootTag = ((XmlFile)file).getRootTag();
        if (rootTag == null || !"settings".equals(rootTag.getName())) {
            return false;
        }
        String xmlns = rootTag.getAttributeValue("xmlns");
        if (xmlns != null) {
            return xmlns.contains("maven");
        }
        boolean hasTag = false;
        for (PsiElement e = rootTag.getFirstChild(); e != null; e = e.getNextSibling()) {
            if (!(e instanceof XmlTag)) continue;
            if (SUBTAGS_IN_SETTINGS_FILE.contains(((XmlTag)e).getName())) {
                return true;
            }
            hasTag = true;
        }
        return !hasTag;
    }

    public static boolean isMavenFile(PsiElement element) {
        return MavenDomUtil.isMavenFile(element.getContainingFile());
    }

    public static Module findContainingMavenizedModule(PsiFile psiFile) {
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return null;
        }
        Project project = psiFile.getProject();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
        if (!manager.isMavenizedProject()) {
            return null;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = index.getModuleForFile(file);
        if (module == null || !manager.isMavenizedModule(module)) {
            return null;
        }
        return module;
    }

    public static boolean isMavenProperty(PsiElement target) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)target, XmlTag.class, (boolean)false);
        if (tag == null) {
            return false;
        }
        return DomUtil.findDomElement((PsiElement)tag, MavenDomProperties.class) != null;
    }

    public static String calcRelativePath(VirtualFile parent, VirtualFile child) {
        String result = FileUtil.getRelativePath((String)parent.getPath(), (String)child.getPath(), (char)'/');
        if (result == null) {
            MavenLog.LOG.warn("cannot calculate relative path for\nparent: " + parent + "\nchild: " + child);
            result = child.getPath();
        }
        return FileUtil.toSystemIndependentName((String)result);
    }

    public static MavenDomParent updateMavenParent(MavenDomProjectModel mavenModel, MavenProject parentProject) {
        MavenDomParent result = mavenModel.getMavenParent();
        VirtualFile pomFile = DomUtil.getFile((DomElement)mavenModel).getVirtualFile();
        Project project = mavenModel.getXmlElement().getProject();
        MavenId parentId = parentProject.getMavenId();
        result.getGroupId().setStringValue(parentId.getGroupId());
        result.getArtifactId().setStringValue(parentId.getArtifactId());
        result.getVersion().setStringValue(parentId.getVersion());
        if (!Comparing.equal((Object)pomFile.getParent().getParent(), (Object)parentProject.getDirectoryFile())) {
            result.getRelativePath().setValue((Object)PsiManager.getInstance((Project)project).findFile(parentProject.getFile()));
        }
        return result;
    }

    public static <T> T getImmediateParent(ConvertContext context, Class<T> clazz) {
        DomElement parentElement = context.getInvocationElement().getParent();
        return (T)(clazz.isInstance(parentElement) ? parentElement : null);
    }

    public static VirtualFile getVirtualFile(DomElement element) {
        XmlFile psiFile = DomUtil.getFile((DomElement)element);
        return MavenDomUtil.getVirtualFile((PsiFile)psiFile);
    }

    public static VirtualFile getVirtualFile(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        return MavenDomUtil.getVirtualFile(psiFile);
    }

    private static VirtualFile getVirtualFile(PsiFile psiFile) {
        if (psiFile == null) {
            return null;
        }
        psiFile = psiFile.getOriginalFile();
        return psiFile.getVirtualFile();
    }

    public static MavenProject findProject(MavenDomProjectModel projectDom) {
        XmlElement element = projectDom.getXmlElement();
        if (element == null) {
            return null;
        }
        VirtualFile file = MavenDomUtil.getVirtualFile((PsiElement)element);
        if (file == null) {
            return null;
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(element.getProject());
        return manager.findProject(file);
    }

    public static MavenProject findContainingProject(DomElement element) {
        XmlElement psi = element.getXmlElement();
        return psi == null ? null : MavenDomUtil.findContainingProject((PsiElement)psi);
    }

    public static MavenProject findContainingProject(PsiElement element) {
        VirtualFile file = MavenDomUtil.getVirtualFile(element);
        if (file == null) {
            return null;
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(element.getProject());
        return manager.findContainingProject(file);
    }

    public static MavenDomProjectModel getMavenDomProjectModel(Project project, VirtualFile file) {
        return MavenDomUtil.getMavenDomModel(project, file, MavenDomProjectModel.class);
    }

    public static MavenDomProfiles getMavenDomProfilesModel(Project project, VirtualFile file) {
        MavenDomProfilesModel model = MavenDomUtil.getMavenDomModel(project, file, MavenDomProfilesModel.class);
        if (model != null) {
            return model.getProfiles();
        }
        return MavenDomUtil.getMavenDomModel(project, file, MavenDomProfiles.class);
    }

    public static <T extends MavenDomElement> T getMavenDomModel(Project project, VirtualFile file, Class<T> clazz) {
        if (!file.isValid()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        return MavenDomUtil.getMavenDomModel(psiFile, clazz);
    }

    public static <T extends MavenDomElement> T getMavenDomModel(PsiFile file, Class<T> clazz) {
        DomFileElement<T> fileElement = MavenDomUtil.getMavenDomFile(file, clazz);
        return (T)(fileElement == null ? null : (MavenDomElement)fileElement.getRootElement());
    }

    private static <T extends MavenDomElement> DomFileElement<T> getMavenDomFile(PsiFile file, Class<T> clazz) {
        if (!(file instanceof XmlFile)) {
            return null;
        }
        return DomManager.getDomManager((Project)file.getProject()).getFileElement((XmlFile)file, clazz);
    }

    public static XmlTag findTag(DomElement domElement, String path) {
        List elements = StringUtil.split((String)path, (String)".");
        if (elements.isEmpty()) {
            return null;
        }
        Pair<String, Integer> nameAndIndex = MavenDomUtil.translateTagName((String)elements.get(0));
        String name = (String)nameAndIndex.first;
        Integer index = (Integer)nameAndIndex.second;
        XmlTag result = domElement.getXmlTag();
        if (result == null || !name.equals(result.getName())) {
            return null;
        }
        result = MavenDomUtil.getIndexedTag(result, index);
        for (String each : elements.subList(1, elements.size())) {
            nameAndIndex = MavenDomUtil.translateTagName(each);
            name = (String)nameAndIndex.first;
            index = (Integer)nameAndIndex.second;
            if ((result = result.findFirstSubTag(name)) == null) {
                return null;
            }
            result = MavenDomUtil.getIndexedTag(result, index);
        }
        return result;
    }

    private static Pair<String, Integer> translateTagName(String text) {
        String tagName = text.trim();
        Integer index = null;
        Matcher matcher = XML_TAG_NAME_PATTERN.matcher(tagName);
        if (matcher.find()) {
            tagName = matcher.group(1);
            try {
                index = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return Pair.create((Object)tagName, index);
    }

    private static XmlTag getIndexedTag(XmlTag parent, Integer index) {
        if (index == null) {
            return parent;
        }
        XmlTag[] children = parent.getSubTags();
        if (index < 0 || index >= children.length) {
            return null;
        }
        return children[index];
    }

    public static PropertiesFile getPropertiesFile(Project project, VirtualFile file) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (!(psiFile instanceof PropertiesFile)) {
            return null;
        }
        return (PropertiesFile)psiFile;
    }

    public static IProperty findProperty(Project project, VirtualFile file, String propName) {
        PropertiesFile propertiesFile = MavenDomUtil.getPropertiesFile(project, file);
        return propertiesFile == null ? null : propertiesFile.findPropertyByKey(propName);
    }

    public static PsiElement findPropertyValue(Project project, VirtualFile file, String propName) {
        IProperty prop = MavenDomUtil.findProperty(project, file, propName);
        return prop == null ? null : prop.getPsiElement().getFirstChild().getNextSibling().getNextSibling();
    }

    private static Set<VirtualFile> getFilteredResourcesRoots(MavenProject mavenProject) {
        Pair cachedValue = mavenProject.getCachedValue(FILTERED_RESOURCES_ROOTS_KEY);
        if (cachedValue == null || ((Long)cachedValue.first).longValue() != VirtualFileManager.getInstance().getModificationCount()) {
            Set set = null;
            for (MavenResource resource : ContainerUtil.concat(mavenProject.getResources(), mavenProject.getTestResources())) {
                VirtualFile resourceDir;
                if (!resource.isFiltered() || (resourceDir = LocalFileSystem.getInstance().findFileByPath(resource.getDirectory())) == null) continue;
                if (set == null) {
                    set = new HashSet();
                }
                set.add(resourceDir);
            }
            if (set == null) {
                set = Collections.emptySet();
            }
            cachedValue = Pair.create((Object)VirtualFileManager.getInstance().getModificationCount(), set);
            mavenProject.putCachedValue(FILTERED_RESOURCES_ROOTS_KEY, cachedValue);
        }
        return (Set)cachedValue.second;
    }

    public static boolean isFilteredResourceFile(PsiElement element) {
        VirtualFile file = MavenDomUtil.getVirtualFile(element);
        if (file == null) {
            return false;
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(element.getProject());
        MavenProject mavenProject = manager.findContainingProject(file);
        if (mavenProject == null) {
            return false;
        }
        Set<VirtualFile> filteredRoots = MavenDomUtil.getFilteredResourcesRoots(mavenProject);
        if (!filteredRoots.isEmpty()) {
            for (VirtualFile f = file.getParent(); f != null; f = f.getParent()) {
                if (!filteredRoots.contains(f)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<DomFileElement<MavenDomProjectModel>> collectProjectModels(Project p) {
        return DomService.getInstance().getFileElements(MavenDomProjectModel.class, p, GlobalSearchScope.projectScope((Project)p));
    }

    public static MavenId describe(PsiFile psiFile) {
        MavenDomProjectModel model = MavenDomUtil.getMavenDomModel(psiFile, MavenDomProjectModel.class);
        String groupId = model.getGroupId().getStringValue();
        String artifactId = model.getArtifactId().getStringValue();
        String version = model.getVersion().getStringValue();
        if (groupId == null) {
            groupId = model.getMavenParent().getGroupId().getStringValue();
        }
        if (version == null) {
            version = model.getMavenParent().getVersion().getStringValue();
        }
        return new MavenId(groupId, artifactId, version);
    }

    public static MavenDomDependency createDomDependency(MavenDomProjectModel model, Editor editor, MavenId id) {
        return MavenDomUtil.createDomDependency(model.getDependencies(), editor, id);
    }

    public static MavenDomDependency createDomDependency(MavenDomDependencies dependencies, Editor editor, MavenId id) {
        MavenDomDependency dep = MavenDomUtil.createDomDependency(dependencies, editor);
        dep.getGroupId().setStringValue(id.getGroupId());
        dep.getArtifactId().setStringValue(id.getArtifactId());
        dep.getVersion().setStringValue(id.getVersion());
        return dep;
    }

    public static MavenDomDependency createDomDependency(MavenDomProjectModel model, Editor editor) {
        return MavenDomUtil.createDomDependency(model.getDependencies(), editor);
    }

    public static MavenDomDependency createDomDependency(MavenDomDependencies dependencies, Editor editor) {
        DomElement element;
        DomCollectionChildDescription childDescription;
        int index = MavenDomUtil.getCollectionIndex(dependencies, editor);
        if (index >= 0 && (childDescription = dependencies.getGenericInfo().getCollectionChildDescription("dependency")) != null && (element = childDescription.addValue((DomElement)dependencies, index)) instanceof MavenDomDependency) {
            return (MavenDomDependency)element;
        }
        return dependencies.addDependency();
    }

    public static int getCollectionIndex(MavenDomDependencies dependencies, Editor editor) {
        if (editor != null) {
            int offset = editor.getCaretModel().getOffset();
            List<MavenDomDependency> dependencyList = dependencies.getDependencies();
            for (int i = 0; i < dependencyList.size(); ++i) {
                MavenDomDependency dependency = dependencyList.get(i);
                XmlElement xmlElement = dependency.getXmlElement();
                if (xmlElement == null || xmlElement.getTextRange().getStartOffset() < offset) continue;
                return i;
            }
        }
        return -1;
    }
}

