/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import lombok.ast.AstVisitor;
import lombok.ast.ConstructorInvocation;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.Select;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeReference;
import lombok.ast.TypeReferencePart;
import lombok.ast.VariableReference;
import org.w3c.dom.Element;

public class IconDetector
extends ResourceXmlDetector
implements Detector.JavaScanner {
    private static final boolean INCLUDE_LDPI;
    private static final Pattern DENSITY_PATTERN;
    private static final Pattern DP_NAME_PATTERN;
    private List<String> mCachedRequiredDensities;
    private Project mCachedDensitiesForProject;
    private static final String[] DENSITY_QUALIFIERS;
    private static final EnumSet<Scope> ICON_TYPE_SCOPE;
    private static final Implementation IMPLEMENTATION_JAVA;
    private static final Implementation IMPLEMENTATION_RES_ONLY;
    public static final Issue ICON_EXPECTED_SIZE;
    public static final Issue ICON_DIP_SIZE;
    public static final Issue ICON_LOCATION;
    public static final Issue ICON_DENSITIES;
    public static final Issue ICON_MISSING_FOLDER;
    public static final Issue GIF_USAGE;
    public static final Issue DUPLICATES_NAMES;
    public static final Issue DUPLICATES_CONFIGURATIONS;
    public static final Issue ICON_NODPI;
    public static final Issue ICON_MIX_9PNG;
    public static final Issue ICON_XML_AND_PNG;
    public static final Issue ICON_EXTENSION;
    public static final Issue ICON_COLORS;
    public static final Issue ICON_LAUNCHER_SHAPE;
    private Map<File, BufferedImage> mImageCache;
    private Set<String> mActionBarIcons;
    private Set<String> mNotificationIcons;
    private Set<String> mLauncherIcons;
    private Multimap<String, String> mMenuToIcons;
    private static final String NOTIFICATION_CLASS = "Notification";
    private static final String NOTIFICATION_COMPAT_CLASS = "NotificationCompat";
    private static final String BUILDER_CLASS = "Builder";
    private static final String SET_SMALL_ICON = "setSmallIcon";
    private static final String ON_CREATE_OPTIONS_MENU = "onCreateOptionsMenu";

    @Override
    public Speed getSpeed() {
        return Speed.SLOW;
    }

    @Override
    public void beforeCheckProject(Context context) {
        this.mLauncherIcons = null;
        this.mActionBarIcons = null;
        this.mNotificationIcons = null;
    }

    @Override
    public void afterCheckLibraryProject(Context context) {
        if (!context.getProject().getReportIssues()) {
            return;
        }
        this.checkResourceFolder(context, context.getProject());
    }

    @Override
    public void afterCheckProject(Context context) {
        this.checkResourceFolder(context, context.getProject());
    }

    private void checkResourceFolder(Context context, Project project) {
        List<File> resourceFolders = project.getResourceFolders();
        for (File res : resourceFolders) {
            File[] folders = res.listFiles();
            if (folders == null) continue;
            boolean checkFolders = context.isEnabled(ICON_DENSITIES) || context.isEnabled(ICON_MISSING_FOLDER) || context.isEnabled(ICON_NODPI) || context.isEnabled(ICON_MIX_9PNG) || context.isEnabled(ICON_XML_AND_PNG);
            boolean checkDipSizes = context.isEnabled(ICON_DIP_SIZE);
            boolean checkDuplicates = context.isEnabled(DUPLICATES_NAMES) || context.isEnabled(DUPLICATES_CONFIGURATIONS);
            HashMap<File, Dimension> pixelSizes = null;
            HashMap<File, Long> fileSizes = null;
            if (checkDipSizes || checkDuplicates) {
                pixelSizes = new HashMap<File, Dimension>();
                fileSizes = new HashMap<File, Long>();
            }
            HashMap<File, Set<String>> folderToNames = new HashMap<File, Set<String>>();
            HashMap<File, Set<String>> nonDpiFolderNames = new HashMap<File, Set<String>>();
            for (File folder : folders) {
                String name;
                HashSet<String> names;
                File[] files;
                String folderName = folder.getName();
                if (!folderName.startsWith("drawable") || (files = folder.listFiles()) == null) continue;
                this.checkDrawableDir(context, folder, files, pixelSizes, fileSizes);
                if (checkFolders && DENSITY_PATTERN.matcher(folderName).matches()) {
                    names = new HashSet(files.length);
                    for (File f : files) {
                        name = f.getName();
                        if (!IconDetector.isDrawableFile(name)) continue;
                        names.add(name);
                    }
                    folderToNames.put(folder, names);
                    continue;
                }
                if (!checkFolders) continue;
                names = new HashSet<String>(files.length);
                for (File f : files) {
                    name = f.getName();
                    if (!IconDetector.isDrawableFile(name)) continue;
                    names.add(name);
                }
                nonDpiFolderNames.put(folder, names);
            }
            if (checkDipSizes) {
                IconDetector.checkDipSizes(context, pixelSizes);
            }
            if (checkDuplicates) {
                IconDetector.checkDuplicates(context, pixelSizes, fileSizes);
            }
            if (!checkFolders || folderToNames.isEmpty()) continue;
            this.checkDensities(context, res, folderToNames, nonDpiFolderNames);
        }
    }

    private static boolean isDrawableFile(String name) {
        return LintUtils.endsWith(name, ".png") || LintUtils.endsWith(name, ".jpg") || LintUtils.endsWith(name, ".gif") || LintUtils.endsWith(name, ".xml") || LintUtils.endsWith(name, ".jpeg") || LintUtils.endsWith(name, ".webp");
    }

    private static void checkDuplicates(Context context, Map<File, Dimension> pixelSizes, Map<File, Long> fileSizes) {
        HashMap<Long, HashSet<File>> sameSizes = new HashMap<Long, HashSet<File>>();
        HashMap<Long, File> seenSizes = new HashMap<Long, File>(fileSizes.size());
        for (Map.Entry<File, Long> entry : fileSizes.entrySet()) {
            File file = entry.getKey();
            Long size = entry.getValue();
            if (seenSizes.containsKey(size)) {
                HashSet<File> set = (HashSet<File>)sameSizes.get(size);
                if (set == null) {
                    set = new HashSet<File>();
                    set.add((File)seenSizes.get(size));
                    sameSizes.put(size, set);
                }
                set.add(file);
                continue;
            }
            seenSizes.put(size, file);
        }
        if (sameSizes.isEmpty()) {
            return;
        }
        Collection candidateLists = sameSizes.values();
        for (Set candidates : candidateLists) {
            HashMap<Dimension, HashSet<File>> sameDimensions = new HashMap<Dimension, HashSet<File>>(candidates.size());
            ArrayList<File> noSize = new ArrayList<File>();
            for (File file : candidates) {
                Dimension dimension = pixelSizes.get(file);
                if (dimension != null) {
                    Set<File> set = (HashSet<File>)sameDimensions.get(dimension);
                    if (set == null) {
                        set = new HashSet<File>();
                        sameDimensions.put(dimension, (HashSet<File>)set);
                    }
                    set.add(file);
                    continue;
                }
                noSize.add(file);
            }
            Collection sets = sameDimensions.values();
            if (!noSize.isEmpty()) {
                if (!sets.isEmpty()) {
                    for (Set set : sets) {
                        set.addAll(noSize);
                    }
                } else {
                    HashSet noSizeSet = new HashSet(noSize);
                    sets = Collections.singletonList(noSizeSet);
                }
            }
            HashMap<File, byte[]> fileContents = new HashMap<File, byte[]>();
            for (Set<File> set : sets) {
                if (set.size() < 2) continue;
                for (File file : set) {
                    byte[] bits = (byte[])fileContents.get(file);
                    if (bits != null) continue;
                    try {
                        bits = context.getClient().readBytes(file);
                        fileContents.put(file, bits);
                    }
                    catch (IOException e) {
                        context.log(e, null, new Object[0]);
                    }
                }
                HashMap<File, File> equal = new HashMap<File, File>();
                ArrayList files = new ArrayList(set);
                Collections.sort(files);
                for (int i = 0; i < files.size() - 1; ++i) {
                    for (int j = i + 1; j < files.size(); ++j) {
                        File file1 = (File)files.get(i);
                        File file2 = (File)files.get(j);
                        byte[] byArray = (byte[])fileContents.get(file1);
                        byte[] byArray2 = (byte[])fileContents.get(file2);
                        if (byArray == null || byArray2 == null || byArray.length != byArray2.length) continue;
                        boolean same = true;
                        for (int k = 0; k < byArray.length; ++k) {
                            if (byArray[k] == byArray2[k]) continue;
                            same = false;
                            break;
                        }
                        if (!same) continue;
                        equal.put(file1, file2);
                    }
                }
                if (equal.isEmpty()) continue;
                HashMap<File, HashSet<File>> partitions = new HashMap<File, HashSet<File>>();
                ArrayList<HashSet<File>> sameSets = new ArrayList<HashSet<File>>();
                for (Map.Entry entry : equal.entrySet()) {
                    File file = (File)entry.getKey();
                    File file2 = (File)entry.getValue();
                    Set set1 = (Set)partitions.get(file);
                    Set set2 = (Set)partitions.get(file2);
                    if (set1 != null) {
                        set1.add(file2);
                        continue;
                    }
                    if (set2 != null) {
                        set2.add(file);
                        continue;
                    }
                    set = new HashSet();
                    sameSets.add((HashSet<File>)set);
                    set.add(file);
                    set.add(file2);
                    partitions.put(file, (HashSet<File>)set);
                    partitions.put(file2, (HashSet<File>)set);
                }
                ArrayList lists = new ArrayList();
                for (Set set2 : sameSets) {
                    assert (!set2.isEmpty());
                    ArrayList arrayList = new ArrayList(set2);
                    Collections.sort(arrayList);
                    lists.add(arrayList);
                }
                Collections.sort(lists, new Comparator<List<File>>(){

                    @Override
                    public int compare(List<File> list1, List<File> list2) {
                        return list1.get(0).compareTo(list2.get(0));
                    }
                });
                ListIterator iterator = lists.listIterator();
                while (iterator.hasNext()) {
                    List list = (List)iterator.next();
                    boolean bl = true;
                    for (File file : list) {
                        String name = file.getName();
                        if (DP_NAME_PATTERN.matcher(name).matches()) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    iterator.remove();
                }
                for (List list : lists) {
                    String message;
                    StringBuilder sb;
                    Location location = null;
                    boolean sameNames = true;
                    String lastName = null;
                    for (File file : list) {
                        if (lastName != null && !lastName.equals(file.getName())) {
                            sameNames = false;
                        }
                        lastName = file.getName();
                        Location linkedLocation = location;
                        location = Location.create(file);
                        location.setSecondary(linkedLocation);
                    }
                    if (sameNames) {
                        sb = new StringBuilder(list.size() * 16);
                        for (File file : list) {
                            if (sb.length() > 0) {
                                sb.append(", ");
                            }
                            sb.append(file.getParentFile().getName());
                        }
                        message = String.format("The `%1$s` icon has identical contents in the following configuration folders: %2$s", lastName, sb.toString());
                        context.report(DUPLICATES_CONFIGURATIONS, location, message);
                        continue;
                    }
                    sb = new StringBuilder(list.size() * 16);
                    for (File file : list) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(file.getName());
                    }
                    message = String.format("The following unrelated icon files have identical contents: %1$s", sb.toString());
                    context.report(DUPLICATES_NAMES, location, message);
                }
            }
        }
    }

    private static void checkDipSizes(Context context, Map<File, Dimension> pixelSizes) {
        HashMap<String, ArrayList<File>> nameToFiles = new HashMap<String, ArrayList<File>>();
        for (File file : pixelSizes.keySet()) {
            String name = file.getName();
            ArrayList<File> list = (ArrayList<File>)nameToFiles.get(name);
            if (list == null) {
                list = new ArrayList<File>();
                nameToFiles.put(name, list);
            }
            list.add(file);
        }
        ArrayList names = new ArrayList(nameToFiles.keySet());
        Collections.sort(names);
        HashMap configMap = new HashMap();
        for (Map.Entry entry : nameToFiles.entrySet()) {
            String name = (String)entry.getKey();
            List files = (List)entry.getValue();
            for (File file : files) {
                ArrayList<File> list;
                String parentName = file.getParentFile().getName();
                int index = -1;
                for (String qualifier : DENSITY_QUALIFIERS) {
                    index = parentName.indexOf(qualifier);
                    if (index == -1) continue;
                    parentName = parentName.substring(0, index) + parentName.substring(index + qualifier.length());
                    break;
                }
                if (index == -1) continue;
                HashMap<String, ArrayList<File>> folderMap = (HashMap<String, ArrayList<File>>)configMap.get(name);
                if (folderMap == null) {
                    folderMap = new HashMap<String, ArrayList<File>>();
                    configMap.put(name, folderMap);
                }
                if ((list = (ArrayList<File>)folderMap.get(parentName)) == null) {
                    list = new ArrayList<File>();
                    folderMap.put(parentName, list);
                }
                list.add(file);
            }
        }
        for (String name : names) {
            Map configurations = (Map)configMap.get(name);
            if (configurations == null) continue;
            for (Map.Entry entry : configurations.entrySet()) {
                List files = (List)entry.getValue();
                HashMap<File, Dimension> dipSizes = new HashMap<File, Dimension>();
                int dipWidthSum = 0;
                int dipHeightSum = 0;
                int count = 0;
                for (File file : files) {
                    String dpString;
                    int dp;
                    Dimension size;
                    String folderName = file.getParentFile().getName();
                    float factor = IconDetector.getMdpiScalingFactor(folderName);
                    if (!(factor > 0.0f) || (size = pixelSizes.get(file)) == null) continue;
                    Dimension dip = new Dimension(Math.round((float)size.width / factor), Math.round((float)size.height / factor));
                    dipWidthSum += dip.width;
                    dipHeightSum += dip.height;
                    dipSizes.put(file, dip);
                    ++count;
                    String fileName = file.getName();
                    Matcher matcher = DP_NAME_PATTERN.matcher(fileName);
                    if (!matcher.matches() || Math.abs(dip.width - (dp = Integer.parseInt(dpString = matcher.group(1)))) <= 2 && Math.abs(dip.height - dp) <= 2) continue;
                    String message = String.format("Suspicious file name `%1$s`: The implied %2$s `dp` size does not match the actual `dp` size (pixel size %3$d\u00d7%4$d in a `%5$s` folder computes to %6$d\u00d7%7$d `dp`)", fileName, dpString, size.width, size.height, folderName, dip.width, dip.height);
                    context.report(ICON_DIP_SIZE, Location.create(file), message);
                }
                if (count == 0) continue;
                int meanWidth = dipWidthSum / count;
                int meanHeight = dipHeightSum / count;
                int squareWidthSum = 0;
                int squareHeightSum = 0;
                for (Dimension size : dipSizes.values()) {
                    squareWidthSum += (size.width - meanWidth) * (size.width - meanWidth);
                    squareHeightSum += (size.height - meanHeight) * (size.height - meanHeight);
                }
                double widthStdDev = Math.sqrt(squareWidthSum / count);
                double heightStdDev = Math.sqrt(squareHeightSum / count);
                if (!(widthStdDev > (double)(meanWidth / 10)) && !(heightStdDev > (double)meanHeight)) continue;
                Location location = null;
                StringBuilder sb = new StringBuilder(100);
                ArrayList entries = new ArrayList();
                for (Map.Entry entry2 : dipSizes.entrySet()) {
                    entries.add(entry2);
                }
                Collections.sort(entries, new Comparator<Map.Entry<File, Dimension>>(){

                    @Override
                    public int compare(Map.Entry<File, Dimension> e1, Map.Entry<File, Dimension> e2) {
                        Dimension d1 = e1.getValue();
                        Dimension d2 = e2.getValue();
                        if (d1.width != d2.width) {
                            return d2.width - d1.width;
                        }
                        return d2.height - d1.height;
                    }
                });
                for (Map.Entry entry2 : entries) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    File file = (File)entry2.getKey();
                    Location linkedLocation = location;
                    location = Location.create(file);
                    location.setSecondary(linkedLocation);
                    Dimension dip = (Dimension)entry2.getValue();
                    Dimension px = pixelSizes.get(file);
                    String fileName = file.getParentFile().getName() + File.separator + file.getName();
                    sb.append(String.format("%1$s: %2$dx%3$d dp (%4$dx%5$d px)", fileName, dip.width, dip.height, px.width, px.height));
                }
                String message = String.format("The image `%1$s` varies significantly in its density-independent (dip) size across the various density versions: %2$s", name, sb.toString());
                context.report(ICON_DIP_SIZE, location, message);
            }
        }
    }

    private void checkDensities(Context context, File res, Map<File, Set<String>> folderToNames, Map<File, Set<String>> nonDpiFolderNames) {
        HashSet<String> definedDensities = new HashSet<String>();
        for (File f : folderToNames.keySet()) {
            definedDensities.add(f.getName());
        }
        if (context.isEnabled(ICON_MISSING_FOLDER)) {
            ArrayList<String> missing = new ArrayList<String>();
            for (String string : this.getRequiredDensityFolders(context)) {
                if (definedDensities.contains(string)) continue;
                missing.add(string);
            }
            if (!missing.isEmpty()) {
                context.report(ICON_MISSING_FOLDER, Location.create(res), String.format("Missing density variation folders in `%1$s`: %2$s", context.getProject().getDisplayPath(res), LintUtils.formatList(missing, -1)));
            }
        }
        if (context.isEnabled(ICON_NODPI)) {
            HashSet<String> noDpiNames = new HashSet<String>();
            for (Map.Entry entry : folderToNames.entrySet()) {
                if (!IconDetector.isNoDpiFolder((File)entry.getKey())) continue;
                noDpiNames.addAll((Collection)entry.getValue());
            }
            if (!noDpiNames.isEmpty()) {
                HashSet<String> inBoth = new HashSet<String>();
                ArrayList<File> arrayList = new ArrayList<File>();
                for (Map.Entry<Object, Object> entry : folderToNames.entrySet()) {
                    File folder = (File)entry.getKey();
                    String folderName = folder.getName();
                    if (IconDetector.isNoDpiFolder(folder)) continue;
                    assert (DENSITY_PATTERN.matcher(folderName).matches());
                    Set<String> overlap = IconDetector.nameIntersection(noDpiNames, (Set)entry.getValue());
                    inBoth.addAll(overlap);
                    for (String string : overlap) {
                        arrayList.add(new File(folder, string));
                    }
                }
                if (!inBoth.isEmpty()) {
                    ArrayList<String> list = new ArrayList<String>(inBoth);
                    Collections.sort(list);
                    Location location = IconDetector.chainLocations(arrayList);
                    context.report(ICON_NODPI, location, String.format("The following images appear in both `-nodpi` and in a density folder: %1$s", LintUtils.formatList(list, context.getDriver().isAbbreviating() ? 10 : -1)));
                }
            }
        }
        if (context.isEnabled(ICON_MIX_9PNG)) {
            IconDetector.checkMixedNinePatches(context, folderToNames);
        }
        if (context.isEnabled(ICON_XML_AND_PNG)) {
            Set<String> overlap;
            HashMap folderMap = Maps.newHashMap(folderToNames);
            folderMap.putAll(nonDpiFolderNames);
            HashSet xmlNames = Sets.newHashSetWithExpectedSize((int)100);
            HashSet hashSet = Sets.newHashSetWithExpectedSize((int)100);
            for (Map.Entry<Object, Object> entry : folderMap.entrySet()) {
                Set names = (Set)entry.getValue();
                for (String name : names) {
                    if (LintUtils.endsWith(name, ".xml")) {
                        xmlNames.add(name);
                        continue;
                    }
                    if (!IconDetector.isDrawableFile(name)) continue;
                    hashSet.add(name);
                }
            }
            if (!(xmlNames.isEmpty() || hashSet.isEmpty() || (overlap = IconDetector.nameIntersection(xmlNames, hashSet)).isEmpty())) {
                ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
                HashSet bases = Sets.newHashSetWithExpectedSize((int)overlap.size());
                for (String name : overlap) {
                    bases.add(LintUtils.getBaseName(name));
                }
                for (String base : bases) {
                    for (Map.Entry entry : folderMap.entrySet()) {
                        File folder = (File)entry.getKey();
                        for (String n : (Set)entry.getValue()) {
                            if (!base.equals(LintUtils.getBaseName(n))) continue;
                            arrayListMultimap.put((Object)base, (Object)new File(folder, n));
                        }
                    }
                }
                ArrayList sorted = new ArrayList(arrayListMultimap.keySet());
                Collections.sort(sorted);
                for (String name : sorted) {
                    ArrayList arrayList = Lists.newArrayList((Iterable)arrayListMultimap.get((Object)name));
                    Location location = IconDetector.chainLocations(arrayList);
                    ArrayList fileNames = Lists.newArrayList();
                    boolean seenXml = false;
                    boolean seenNonXml = false;
                    for (File f : arrayList) {
                        boolean isXml = LintUtils.endsWith(f.getPath(), ".xml");
                        if (isXml && !seenXml) {
                            fileNames.add(context.getProject().getDisplayPath(f));
                            seenXml = true;
                            continue;
                        }
                        if (isXml || seenNonXml) continue;
                        fileNames.add(context.getProject().getDisplayPath(f));
                        seenNonXml = true;
                    }
                    context.report(ICON_XML_AND_PNG, location, String.format("The following images appear both as density independent `.xml` files and as bitmap files: %1$s", LintUtils.formatList(fileNames, context.getDriver().isAbbreviating() ? 10 : -1)));
                }
            }
        }
        if (context.isEnabled(ICON_DENSITIES)) {
            HashSet<String> allNames = new HashSet<String>();
            for (Map.Entry entry : folderToNames.entrySet()) {
                if (IconDetector.isNoDpiFolder((File)entry.getKey())) continue;
                Set names = (Set)entry.getValue();
                allNames.addAll(names);
            }
            for (Map.Entry entry : folderToNames.entrySet()) {
                ArrayList<String> delta;
                Set set;
                File file = (File)entry.getKey();
                if (IconDetector.isNoDpiFolder(file) || (set = (Set)entry.getValue()).size() == allNames.size() || (delta = new ArrayList<String>(IconDetector.nameDifferences(allNames, set))).isEmpty()) continue;
                Collections.sort(delta);
                String foundIn = "";
                if (delta.size() == 1) {
                    String name;
                    ArrayList<String> defined = new ArrayList<String>();
                    name = (String)delta.get(0);
                    for (Map.Entry<File, Set<String>> e : folderToNames.entrySet()) {
                        if (!e.getValue().contains(name)) continue;
                        defined.add(e.getKey().getName());
                    }
                    if (!defined.isEmpty()) {
                        foundIn = String.format(" (found in %1$s)", LintUtils.formatList(defined, context.getDriver().isAbbreviating() ? 5 : -1));
                    }
                }
                String folder = file.getName();
                if (!this.getRequiredDensityFolders(context).contains(folder)) continue;
                context.report(ICON_DENSITIES, Location.create(file), String.format("Missing the following drawables in `%1$s`: %2$s%3$s", folder, LintUtils.formatList(delta, context.getDriver().isAbbreviating() ? 5 : -1), foundIn));
            }
        }
    }

    private List<String> getRequiredDensityFolders(Context context) {
        if (this.mCachedRequiredDensities == null || context.getProject() != this.mCachedDensitiesForProject) {
            this.mCachedDensitiesForProject = context.getProject();
            this.mCachedRequiredDensities = Lists.newArrayListWithExpectedSize((int)10);
            List<String> applicableDensities = context.getProject().getApplicableDensities();
            if (applicableDensities != null) {
                this.mCachedRequiredDensities.addAll(applicableDensities);
            } else {
                if (INCLUDE_LDPI) {
                    this.mCachedRequiredDensities.add("drawable-ldpi");
                }
                this.mCachedRequiredDensities.add("drawable-mdpi");
                this.mCachedRequiredDensities.add("drawable-hdpi");
                this.mCachedRequiredDensities.add("drawable-xhdpi");
                this.mCachedRequiredDensities.add("drawable-xxhdpi");
                this.mCachedRequiredDensities.add("drawable-xxxhdpi");
            }
        }
        return this.mCachedRequiredDensities;
    }

    private static void addResConfigsFromFlavor(Set<String> relevantDensities, List<String> variantFlavors, ProductFlavorContainer container) {
        ProductFlavor flavor = container.getProductFlavor();
        if ((variantFlavors == null || variantFlavors.contains(flavor.getName())) && !flavor.getResourceConfigurations().isEmpty()) {
            for (String densityName : flavor.getResourceConfigurations()) {
                Density density = Density.getEnum((String)densityName);
                if (density == null || !density.isRecommended() || density == Density.NODPI || density == Density.ANYDPI) continue;
                relevantDensities.add(densityName);
            }
        }
    }

    private static Set<String> nameDifferences(Set<String> a, Set<String> b) {
        HashSet<String> names1 = new HashSet<String>(a.size());
        for (String s : a) {
            names1.add(LintUtils.getBaseName(s));
        }
        HashSet<String> names2 = new HashSet<String>(b.size());
        for (String s : b) {
            names2.add(LintUtils.getBaseName(s));
        }
        names1.removeAll(names2);
        if (!names1.isEmpty()) {
            HashSet<String> result = new HashSet<String>(names1.size());
            for (String s : a) {
                if (!names1.contains(LintUtils.getBaseName(s))) continue;
                result.add(s);
            }
            for (String s : b) {
                if (!names1.contains(LintUtils.getBaseName(s))) continue;
                result.add(s);
            }
            return result;
        }
        return Collections.emptySet();
    }

    private static Set<String> nameIntersection(Set<String> a, Set<String> b) {
        HashSet<String> names1 = new HashSet<String>(a.size());
        for (String s : a) {
            names1.add(LintUtils.getBaseName(s));
        }
        HashSet<String> names2 = new HashSet<String>(b.size());
        for (String s : b) {
            names2.add(LintUtils.getBaseName(s));
        }
        names1.retainAll(names2);
        if (!names1.isEmpty()) {
            HashSet<String> result = new HashSet<String>(names1.size());
            for (String s : a) {
                if (!names1.contains(LintUtils.getBaseName(s))) continue;
                result.add(s);
            }
            for (String s : b) {
                if (!names1.contains(LintUtils.getBaseName(s))) continue;
                result.add(s);
            }
            return result;
        }
        return Collections.emptySet();
    }

    private static boolean isNoDpiFolder(File file) {
        return file.getName().contains("-nodpi");
    }

    private BufferedImage getImage(File file) throws IOException {
        BufferedImage image;
        if (file == null) {
            return null;
        }
        if (this.mImageCache == null) {
            this.mImageCache = Maps.newHashMap();
        } else {
            image = this.mImageCache.get(file);
            if (image != null) {
                return image;
            }
        }
        image = ImageIO.read(file);
        this.mImageCache.put(file, image);
        return image;
    }

    private void checkDrawableDir(Context context, File folder, File[] files, Map<File, Dimension> pixelSizes, Map<File, Long> fileSizes) {
        String name;
        if (folder.getName().equals("drawable") && context.isEnabled(ICON_LOCATION) && context.getProject().getMinSdk() >= 4) {
            for (File file : files) {
                name = file.getName();
                if (name.endsWith(".xml") || !LintUtils.endsWith(name, ".png") && !LintUtils.endsWith(name, ".jpg") && !LintUtils.endsWith(name, ".jpeg") && !LintUtils.endsWith(name, ".gif")) continue;
                context.report(ICON_LOCATION, Location.create(file), String.format("Found bitmap drawable `res/drawable/%1$s` in densityless folder", file.getName()));
            }
        }
        if (context.isEnabled(GIF_USAGE)) {
            for (File file : files) {
                name = file.getName();
                if (!LintUtils.endsWith(name, ".gif")) continue;
                context.report(GIF_USAGE, Location.create(file), "Using the `.gif` format for bitmaps is discouraged");
            }
        }
        if (context.isEnabled(ICON_EXTENSION)) {
            for (File file : files) {
                String path = file.getPath();
                if (!IconDetector.isDrawableFile(path) || LintUtils.endsWith(path, ".xml")) continue;
                IconDetector.checkExtension(context, file);
            }
        }
        if (context.isEnabled(ICON_COLORS)) {
            for (File file : files) {
                Dimension size;
                String baseName;
                boolean isActionBarIcon;
                name = file.getName();
                if (!IconDetector.isDrawableFile(name) || LintUtils.endsWith(name, ".xml") || LintUtils.endsWith(name, ".9.png") || !(isActionBarIcon = this.isActionBarIcon(context, baseName = IconDetector.getBaseName(name), file)) && !this.isNotificationIcon(baseName) || (size = this.checkColor(context, file, isActionBarIcon)) == null || pixelSizes == null) continue;
                pixelSizes.put(file, size);
            }
        }
        if (context.isEnabled(ICON_LAUNCHER_SHAPE)) {
            for (File file : files) {
                name = file.getName();
                if (!this.isLauncherIcon(IconDetector.getBaseName(name)) || LintUtils.endsWith(name, ".xml") || LintUtils.endsWith(name, ".9.png")) continue;
                this.checkLauncherShape(context, file);
            }
        }
        if (context.isEnabled(ICON_EXPECTED_SIZE)) {
            this.checkExpectedSizes(context, folder, files);
        }
        if (pixelSizes != null || fileSizes != null) {
            for (File file : files) {
                String fileName = file.getName();
                if (!LintUtils.endsWith(fileName, ".png") && !LintUtils.endsWith(fileName, ".jpg") && !LintUtils.endsWith(fileName, ".jpeg")) continue;
                if (pixelSizes != null && !LintUtils.endsWith(fileName, ".9.png") && !pixelSizes.containsKey(file)) {
                    Dimension size = IconDetector.getSize(file);
                    pixelSizes.put(file, size);
                }
                if (fileSizes == null) continue;
                fileSizes.put(file, file.length());
            }
        }
        this.mImageCache = null;
    }

    private void checkLauncherShape(Context context, File file) {
        try {
            BufferedImage image = this.getImage(file);
            if (image != null) {
                int height = image.getHeight();
                for (int y = 0; y < height; ++y) {
                    int width = image.getWidth();
                    for (int x = 0; x < width; ++x) {
                        int rgb = image.getRGB(x, y);
                        if ((rgb & 0xFF000000) != 0) continue;
                        return;
                    }
                }
                String message = "Launcher icons should not fill every pixel of their square region; see the design guide for details";
                context.report(ICON_LAUNCHER_SHAPE, Location.create(file), message);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Dimension checkColor(Context context, File file, boolean isActionBarIcon) {
        block13: {
            int folderVersion = context.getDriver().getResourceFolderVersion(file);
            if (isActionBarIcon ? folderVersion != -1 && folderVersion < 11 || !IconDetector.isAndroid30(context, folderVersion) : folderVersion != -1 && folderVersion < 9 || !IconDetector.isAndroid23(context, folderVersion) && !IconDetector.isAndroid30(context, folderVersion)) {
                return null;
            }
            try {
                BufferedImage image;
                block14: {
                    image = this.getImage(file);
                    if (image == null) break block13;
                    if (isActionBarIcon) {
                        int height = image.getHeight();
                        for (int y = 0; y < height; ++y) {
                            int width = image.getWidth();
                            for (int x = 0; x < width; ++x) {
                                int rgb = image.getRGB(x, y);
                                if ((rgb & 0xFF000000) == 0) continue;
                                int r = (rgb & 0xFF0000) >>> 16;
                                int g = (rgb & 0xFF00) >>> 8;
                                int b = rgb & 0xFF;
                                if (r == g && r == b) continue;
                                String message = "Action Bar icons should use a single gray color (`#333333` for light themes (with 60%/30% opacity for enabled/disabled), and `#FFFFFF` with opacity 80%/30% for dark themes";
                                context.report(ICON_COLORS, Location.create(file), message);
                                break block14;
                            }
                        }
                    } else if (folderVersion >= 11 || IconDetector.isAndroid30(context, folderVersion)) {
                        int height = image.getHeight();
                        for (int y = 0; y < height; ++y) {
                            int width = image.getWidth();
                            for (int x = 0; x < width; ++x) {
                                int rgb = image.getRGB(x, y);
                                if ((rgb & 0xFF000000) == 0 || (rgb & 0xFFFFFF) == 0xFFFFFF) continue;
                                int r = (rgb & 0xFF0000) >>> 16;
                                int g = (rgb & 0xFF00) >>> 8;
                                int b = rgb & 0xFF;
                                if (r == g && r == b && (x < width - 1 && rgb != image.getRGB(x + 1, y) || x > 0 && rgb != image.getRGB(x - 1, y) || y < height - 1 && rgb != image.getRGB(x, y + 1) || y > 0 && rgb != image.getRGB(x, y - 1))) continue;
                                String message = "Notification icons must be entirely white";
                                context.report(ICON_COLORS, Location.create(file), message);
                                break block14;
                            }
                        }
                    } else {
                        int height = image.getHeight();
                        for (int y = 0; y < height; ++y) {
                            int width = image.getWidth();
                            for (int x = 0; x < width; ++x) {
                                int rgb = image.getRGB(x, y);
                                if ((rgb & 0xFF000000) == 0) continue;
                                int r = (rgb & 0xFF0000) >>> 16;
                                int g = (rgb & 0xFF00) >>> 8;
                                int b = rgb & 0xFF;
                                if (r == g && r == b) continue;
                                String message = "Notification icons should not use colors";
                                context.report(ICON_COLORS, Location.create(file), message);
                                break block14;
                            }
                        }
                    }
                }
                return new Dimension(image.getWidth(), image.getHeight());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkExtension(Context context, File file) {
        block13: {
            try {
                ImageInputStream input = ImageIO.createImageInputStream(file);
                if (input == null) break block13;
                try {
                    Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
                    while (readers.hasNext()) {
                        ImageReader reader = readers.next();
                        try {
                            int index;
                            reader.setInput(input);
                            String formatName = reader.getFormatName();
                            if (formatName == null || formatName.isEmpty()) continue;
                            String path = file.getPath();
                            String extension = path.substring((index = path.lastIndexOf(46)) + 1).toLowerCase(Locale.US);
                            if (!formatName.equalsIgnoreCase(extension)) {
                                if (LintUtils.endsWith(path, ".jpg") && formatName.equals("JPEG")) {
                                    return;
                                }
                                String message = String.format("Misleading file extension; named `.%1$s` but the file format is `%2$s`", extension, formatName);
                                Location location = Location.create(file);
                                context.report(ICON_EXTENSION, location, message);
                            }
                            break;
                        }
                        finally {
                            reader.dispose();
                        }
                    }
                }
                finally {
                    input.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String getBaseName(String name) {
        String baseName = name;
        int index = baseName.indexOf(46);
        if (index != -1) {
            baseName = baseName.substring(0, index);
        }
        return baseName;
    }

    private static void checkMixedNinePatches(Context context, Map<File, Set<String>> folderToNames) {
        Set conflictSet = null;
        for (Map.Entry<File, Set<String>> entry : folderToNames.entrySet()) {
            HashSet<String> baseNames = new HashSet<String>();
            Set<String> names = entry.getValue();
            for (String name : names) {
                assert (IconDetector.isDrawableFile(name)) : name;
                String base = IconDetector.getBaseName(name);
                if (baseNames.contains(base)) {
                    String ninepatch = base + ".9.png";
                    String png = base + ".png";
                    if (!names.contains(ninepatch) || !names.contains(png)) continue;
                    if (conflictSet == null) {
                        conflictSet = Sets.newHashSet();
                    }
                    conflictSet.add(base);
                    continue;
                }
                baseNames.add(base);
            }
        }
        if (conflictSet == null || conflictSet.isEmpty()) {
            return;
        }
        Map conflicts = null;
        for (Map.Entry<File, Set<String>> entry : folderToNames.entrySet()) {
            File dir = entry.getKey();
            Set<String> names = entry.getValue();
            for (String name : names) {
                List files;
                assert (IconDetector.isDrawableFile(name)) : name;
                String base = IconDetector.getBaseName(name);
                if (!conflictSet.contains(base)) continue;
                if (conflicts == null) {
                    conflicts = Maps.newHashMap();
                }
                if ((files = (List)conflicts.get(base)) == null) {
                    files = Lists.newArrayList();
                    conflicts.put(base, files);
                }
                files.add(new File(dir, name));
            }
        }
        assert (conflicts != null && !conflicts.isEmpty()) : conflictSet;
        ArrayList names = new ArrayList(conflicts.keySet());
        Collections.sort(names);
        for (String name : names) {
            List files = (List)conflicts.get(name);
            assert (files != null) : name;
            Location location = IconDetector.chainLocations(files);
            String message = String.format("The files `%1$s.png` and `%1$s.9.png` clash; both will map to `@drawable/%1$s`", name);
            context.report(ICON_MIX_9PNG, location, message);
        }
    }

    private static Location chainLocations(List<File> files) {
        Collections.sort(files);
        Location location = null;
        for (File file : files) {
            Location linkedLocation = location;
            location = Location.create(file);
            location.setSecondary(linkedLocation);
        }
        return location;
    }

    private void checkExpectedSizes(Context context, File folder, File[] files) {
        if (files == null || files.length == 0) {
            return;
        }
        String folderName = folder.getName();
        int folderVersion = context.getDriver().getResourceFolderVersion(files[0]);
        for (File file : files) {
            String name = file.getName();
            String baseName = IconDetector.getBaseName(name);
            if (this.isLauncherIcon(baseName)) {
                IconDetector.checkSize(context, folderName, file, 48, 48, true);
                continue;
            }
            if (this.isActionBarIcon(baseName)) {
                IconDetector.checkSize(context, folderName, file, 32, 32, true);
                continue;
            }
            if (name.startsWith("ic_dialog_")) {
                IconDetector.checkSize(context, folderName, file, 32, 32, true);
                continue;
            }
            if (name.startsWith("ic_tab_")) {
                IconDetector.checkSize(context, folderName, file, 32, 32, true);
                continue;
            }
            if (this.isNotificationIcon(baseName)) {
                if (IconDetector.isAndroid30(context, folderVersion)) {
                    IconDetector.checkSize(context, folderName, file, 24, 24, true);
                    continue;
                }
                if (IconDetector.isAndroid23(context, folderVersion)) {
                    IconDetector.checkSize(context, folderName, file, 16, 25, false);
                    continue;
                }
                IconDetector.checkSize(context, folderName, file, 25, 25, true);
                continue;
            }
            if (!name.startsWith("ic_menu_")) continue;
            if (IconDetector.isAndroid30(context, folderVersion)) {
                IconDetector.checkSize(context, folderName, file, 32, 32, true);
                continue;
            }
            if (IconDetector.isAndroid23(context, folderVersion)) {
                IconDetector.checkSize(context, folderName, file, 48, 48, true);
                continue;
            }
            IconDetector.checkSize(context, folderName, file, 48, 48, true);
        }
    }

    private static boolean isAndroid30(Context context, int folderVersion) {
        return folderVersion >= 11 || context.getMainProject().getMinSdk() >= 11;
    }

    private static boolean isAndroid23(Context context, int folderVersion) {
        if (IconDetector.isAndroid30(context, folderVersion)) {
            return false;
        }
        if (folderVersion == 9 || folderVersion == 10) {
            return true;
        }
        int minSdk = context.getMainProject().getMinSdk();
        return minSdk == 9 || minSdk == 10;
    }

    private static float getMdpiScalingFactor(String folderName) {
        if (folderName.contains("-mdpi")) {
            return 1.0f;
        }
        if (folderName.contains("-hdpi")) {
            return 1.5f;
        }
        if (folderName.contains("-xhdpi")) {
            return 2.0f;
        }
        if (folderName.contains("-xxhdpi")) {
            return 3.0f;
        }
        if (folderName.contains("-xxxhdpi")) {
            return 4.0f;
        }
        if (folderName.contains("-ldpi")) {
            return 0.75f;
        }
        return 0.0f;
    }

    private static void checkSize(Context context, String folderName, File file, int mdpiWidth, int mdpiHeight, boolean exactMatch) {
        int height;
        int width;
        String fileName = file.getName();
        if (!(LintUtils.endsWith(fileName, ".png") && !LintUtils.endsWith(fileName, ".9.png") || LintUtils.endsWith(fileName, ".jpg") || LintUtils.endsWith(fileName, ".jpeg"))) {
            return;
        }
        if (folderName.startsWith("drawable-mdpi")) {
            width = mdpiWidth;
            height = mdpiHeight;
        } else if (folderName.startsWith("drawable-hdpi")) {
            width = Math.round((float)mdpiWidth * 3.0f / 2.0f);
            height = Math.round((float)mdpiHeight * 3.0f / 2.0f);
        } else if (folderName.startsWith("drawable-xhdpi")) {
            width = mdpiWidth * 2;
            height = mdpiHeight * 2;
        } else if (folderName.startsWith("drawable-xxhdpi")) {
            width = mdpiWidth * 3;
            height = mdpiWidth * 3;
        } else if (folderName.startsWith("drawable-ldpi")) {
            width = Math.round((float)mdpiWidth * 3.0f / 4.0f);
            height = Math.round((float)mdpiHeight * 3.0f / 4.0f);
        } else {
            return;
        }
        Dimension size = IconDetector.getSize(file);
        if (size != null) {
            if (exactMatch && (size.width != width || size.height != height)) {
                context.report(ICON_EXPECTED_SIZE, Location.create(file), String.format("Incorrect icon size for `%1$s`: expected %2$dx%3$d, but was %4$dx%5$d", folderName + File.separator + file.getName(), width, height, size.width, size.height));
            } else if (!(exactMatch || size.width <= width && size.height <= height)) {
                context.report(ICON_EXPECTED_SIZE, Location.create(file), String.format("Incorrect icon size for `%1$s`: icon size should be at most %2$dx%3$d, but was %4$dx%5$d", folderName + File.separator + file.getName(), width, height, size.width, size.height));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static Dimension getSize(File file) {
        try {
            BufferedImage image;
            ImageInputStream input = ImageIO.createImageInputStream(file);
            if (input != null) {
                try {
                    Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
                    if (readers.hasNext()) {
                        ImageReader reader = readers.next();
                        try {
                            reader.setInput(input);
                            Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                            reader.dispose();
                            return dimension;
                        }
                        catch (Throwable throwable) {
                            reader.dispose();
                            throw throwable;
                        }
                    }
                }
                finally {
                    input.close();
                }
            }
            if ((image = ImageIO.read(file)) != null) {
                return new Dimension(image.getWidth(), image.getHeight());
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean isLauncherIcon(String name) {
        assert (name.indexOf(46) == -1) : name;
        if (name.startsWith("ic_launcher")) {
            return true;
        }
        return this.mLauncherIcons != null && this.mLauncherIcons.contains(name);
    }

    private boolean isNotificationIcon(String name) {
        assert (name.indexOf(46) == -1);
        if (name.startsWith("ic_stat_")) {
            return true;
        }
        return this.mNotificationIcons != null && this.mNotificationIcons.contains(name);
    }

    private boolean isActionBarIcon(String name) {
        assert (name.indexOf(46) == -1);
        if (name.startsWith("ic_action_")) {
            return true;
        }
        return this.mActionBarIcons != null && this.mActionBarIcons.contains(name);
    }

    private boolean isActionBarIcon(Context context, String name, File file) {
        if (this.isActionBarIcon(name)) {
            return true;
        }
        return file != null && name.startsWith("ic_menu_") && IconDetector.isAndroid30(context, context.getDriver().getResourceFolderVersion(file));
    }

    @Override
    public boolean appliesTo(Context context, File file) {
        return file.getName().equals("AndroidManifest.xml");
    }

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.MENU;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("application", "activity", "service", "provider", "receiver", "item");
    }

    @Override
    public void visitElement(XmlContext context, Element element) {
        String icon = element.getAttributeNS("http://schemas.android.com/apk/res/android", "icon");
        if (icon != null && icon.startsWith("@drawable/")) {
            icon = icon.substring("@drawable/".length());
            String tagName = element.getTagName();
            if (tagName.equals("item")) {
                if (this.mMenuToIcons == null) {
                    this.mMenuToIcons = ArrayListMultimap.create();
                }
                String menu = IconDetector.getBaseName(context.file.getName());
                this.mMenuToIcons.put((Object)menu, (Object)icon);
            } else {
                if (this.mLauncherIcons == null) {
                    this.mLauncherIcons = Sets.newHashSet();
                }
                this.mLauncherIcons.add(icon);
            }
        }
    }

    @Override
    public AstVisitor createJavaVisitor(JavaContext context) {
        return new NotificationFinder();
    }

    @Override
    public List<Class<? extends Node>> getApplicableNodeTypes() {
        ArrayList<Class<? extends Node>> types = new ArrayList<Class<? extends Node>>(3);
        types.add(MethodDeclaration.class);
        types.add(ConstructorInvocation.class);
        return types;
    }

    private boolean handleSelect(Select select) {
        if (select.toString().startsWith("R.drawable.")) {
            String name = select.astIdentifier().astValue();
            if (this.mNotificationIcons == null) {
                this.mNotificationIcons = Sets.newHashSet();
            }
            this.mNotificationIcons.add(name);
            return true;
        }
        return false;
    }

    static {
        boolean includeLdpi = false;
        String value = System.getenv("ANDROID_LINT_INCLUDE_LDPI");
        if (value != null) {
            includeLdpi = Boolean.valueOf(value);
        }
        INCLUDE_LDPI = includeLdpi;
        DENSITY_PATTERN = Pattern.compile("^drawable-(nodpi|xxxhdpi|xxhdpi|xhdpi|hdpi|mdpi" + (INCLUDE_LDPI ? "|ldpi" : "") + ")$");
        DP_NAME_PATTERN = Pattern.compile(".+_(\\d+)dp\\.png");
        DENSITY_QUALIFIERS = new String[]{"-ldpi", "-mdpi", "-hdpi", "-xhdpi", "-xxhdpi", "-xxxhdpi"};
        ICON_TYPE_SCOPE = EnumSet.of(Scope.ALL_RESOURCE_FILES, Scope.JAVA_FILE, Scope.MANIFEST);
        IMPLEMENTATION_JAVA = new Implementation(IconDetector.class, ICON_TYPE_SCOPE);
        IMPLEMENTATION_RES_ONLY = new Implementation(IconDetector.class, Scope.ALL_RESOURCES_SCOPE);
        ICON_EXPECTED_SIZE = Issue.create("IconExpectedSize", "Icon has incorrect size", "There are predefined sizes (for each density) for launcher icons. You should follow these conventions to make sure your icons fit in with the overall look of the platform.", Category.ICONS, 5, Severity.WARNING, IMPLEMENTATION_JAVA).setEnabledByDefault(false).addMoreInfo("http://developer.android.com/design/style/iconography.html");
        ICON_DIP_SIZE = Issue.create("IconDipSize", "Icon density-independent size validation", "Checks the all icons which are provided in multiple densities, all compute to roughly the same density-independent pixel (`dip`) size. This catches errors where images are either placed in the wrong folder, or icons are changed to new sizes but some folders are forgotten.", Category.ICONS, 5, Severity.WARNING, IMPLEMENTATION_RES_ONLY);
        ICON_LOCATION = Issue.create("IconLocation", "Image defined in density-independent drawable folder", "The res/drawable folder is intended for density-independent graphics such as shapes defined in XML. For bitmaps, move it to `drawable-mdpi` and consider providing higher and lower resolution versions in `drawable-ldpi`, `drawable-hdpi` and `drawable-xhdpi`. If the icon *really* is density independent (for example a solid color) you can place it in `drawable-nodpi`.", Category.ICONS, 5, Severity.WARNING, IMPLEMENTATION_RES_ONLY).addMoreInfo("http://developer.android.com/guide/practices/screens_support.html");
        ICON_DENSITIES = Issue.create("IconDensities", "Icon densities validation", "Icons will look best if a custom version is provided for each of the major screen density classes (low, medium, high, extra high). This lint check identifies icons which do not have complete coverage across the densities.\n\nLow density is not really used much anymore, so this check ignores the ldpi density. To force lint to include it, set the environment variable `ANDROID_LINT_INCLUDE_LDPI=true`. For more information on current density usage, see http://developer.android.com/resources/dashboard/screens.html", Category.ICONS, 4, Severity.WARNING, IMPLEMENTATION_RES_ONLY).addMoreInfo("http://developer.android.com/guide/practices/screens_support.html");
        ICON_MISSING_FOLDER = Issue.create("IconMissingDensityFolder", "Missing density folder", "Icons will look best if a custom version is provided for each of the major screen density classes (low, medium, high, extra-high, extra-extra-high). This lint check identifies folders which are missing, such as `drawable-hdpi`.\n\nLow density is not really used much anymore, so this check ignores the ldpi density. To force lint to include it, set the environment variable `ANDROID_LINT_INCLUDE_LDPI=true`. For more information on current density usage, see http://developer.android.com/resources/dashboard/screens.html", Category.ICONS, 3, Severity.WARNING, IMPLEMENTATION_RES_ONLY).addMoreInfo("http://developer.android.com/guide/practices/screens_support.html");
        GIF_USAGE = Issue.create("GifUsage", "Using `.gif` format for bitmaps is discouraged", "The `.gif` file format is discouraged. Consider using `.png` (preferred) or `.jpg` (acceptable) instead.", Category.ICONS, 5, Severity.WARNING, IMPLEMENTATION_RES_ONLY).addMoreInfo("http://developer.android.com/guide/topics/resources/drawable-resource.html#Bitmap");
        DUPLICATES_NAMES = Issue.create("IconDuplicates", "Duplicated icons under different names", "If an icon is repeated under different names, you can consolidate and just use one of the icons and delete the others to make your application smaller. However, duplicated icons usually are not intentional and can sometimes point to icons that were accidentally overwritten or accidentally not updated.", Category.ICONS, 3, Severity.WARNING, IMPLEMENTATION_RES_ONLY);
        DUPLICATES_CONFIGURATIONS = Issue.create("IconDuplicatesConfig", "Identical bitmaps across various configurations", "If an icon is provided under different configuration parameters such as `drawable-hdpi` or `-v11`, they should typically be different. This detector catches cases where the same icon is provided in different configuration folder which is usually not intentional.", Category.ICONS, 5, Severity.WARNING, IMPLEMENTATION_RES_ONLY);
        ICON_NODPI = Issue.create("IconNoDpi", "Icon appears in both `-nodpi` and dpi folders", "Bitmaps that appear in `drawable-nodpi` folders will not be scaled by the Android framework. If a drawable resource of the same name appears *both* in a `-nodpi` folder as well as a dpi folder such as `drawable-hdpi`, then the behavior is ambiguous and probably not intentional. Delete one or the other, or use different names for the icons.", Category.ICONS, 7, Severity.WARNING, IMPLEMENTATION_RES_ONLY);
        ICON_MIX_9PNG = Issue.create("IconMixedNinePatch", "Clashing PNG and 9-PNG files", "If you accidentally name two separate resources `file.png` and `file.9.png`, the image file and the nine patch file will both map to the same drawable resource, `@drawable/file`, which is probably not what was intended.", Category.ICONS, 5, Severity.WARNING, IMPLEMENTATION_RES_ONLY);
        ICON_XML_AND_PNG = Issue.create("IconXmlAndPng", "Icon is specified both as `.xml` file and as a bitmap", "If a drawable resource appears as an `.xml` file in the `drawable/` folder, it's usually not intentional for it to also appear as a bitmap using the same name; generally you expect the drawable XML file to define states and each state has a corresponding drawable bitmap.", Category.ICONS, 7, Severity.WARNING, IMPLEMENTATION_RES_ONLY);
        ICON_EXTENSION = Issue.create("IconExtension", "Icon format does not match the file extension", "Ensures that icons have the correct file extension (e.g. a `.png` file is really in the PNG format and not for example a GIF file named `.png`.)", Category.ICONS, 3, Severity.WARNING, IMPLEMENTATION_RES_ONLY);
        ICON_COLORS = Issue.create("IconColors", "Icon colors do not follow the recommended visual style", "Notification icons and Action Bar icons should only white and shades of gray. See the Android Design Guide for more details. Note that the way Lint decides whether an icon is an action bar icon or a notification icon is based on the filename prefix: `ic_menu_` for action bar icons, `ic_stat_` for notification icons etc. These correspond to the naming conventions documented in http://developer.android.com/guide/practices/ui_guidelines/icon_design.html", Category.ICONS, 6, Severity.WARNING, IMPLEMENTATION_JAVA).addMoreInfo("http://developer.android.com/design/style/iconography.html");
        ICON_LAUNCHER_SHAPE = Issue.create("IconLauncherShape", "The launcher icon shape should use a distinct silhouette", "According to the Android Design Guide (http://developer.android.com/design/style/iconography.html) your launcher icons should \"use a distinct silhouette\", a \"three-dimensional, front view, with a slight perspective as if viewed from above, so that users perceive some depth.\"\n\nThe unique silhouette implies that your launcher icon should not be a filled square.", Category.ICONS, 6, Severity.WARNING, IMPLEMENTATION_JAVA).addMoreInfo("http://developer.android.com/design/style/iconography.html");
    }

    private final class MenuFinder
    extends ForwardingAstVisitor {
        private MenuFinder() {
        }

        public boolean visitSelect(Select node) {
            String type;
            VariableReference reference;
            Select select;
            if (node.astOperand() instanceof Select && (select = (Select)node.astOperand()).astOperand() instanceof VariableReference && (reference = (VariableReference)select.astOperand()).astIdentifier().astValue().equals("R") && (type = select.astIdentifier().astValue()).equals("menu")) {
                Collection icons;
                String name = node.astIdentifier().astValue();
                if (IconDetector.this.mMenuToIcons != null && (icons = IconDetector.this.mMenuToIcons.get((Object)name)) != null) {
                    if (IconDetector.this.mActionBarIcons == null) {
                        IconDetector.this.mActionBarIcons = Sets.newHashSet();
                    }
                    IconDetector.this.mActionBarIcons.addAll(icons);
                }
            }
            return super.visitSelect(node);
        }
    }

    private final class SetIconFinder
    extends ForwardingAstVisitor {
        private SetIconFinder() {
        }

        public boolean visitMethodInvocation(MethodInvocation node) {
            StrictListAccessor arguments;
            if (IconDetector.SET_SMALL_ICON.equals(node.astName().astValue()) && (arguments = node.astArguments()).size() == 1 && arguments.first() instanceof Select) {
                IconDetector.this.handleSelect((Select)arguments.first());
            }
            return super.visitMethodInvocation(node);
        }
    }

    private final class NotificationFinder
    extends ForwardingAstVisitor {
        private NotificationFinder() {
        }

        public boolean visitMethodDeclaration(MethodDeclaration node) {
            if (IconDetector.ON_CREATE_OPTIONS_MENU.equals(node.astMethodName().astValue())) {
                node.accept((AstVisitor)new MenuFinder());
            }
            return super.visitMethodDeclaration(node);
        }

        public boolean visitConstructorInvocation(ConstructorInvocation node) {
            TypeReference reference = node.astTypeReference();
            StrictListAccessor parts = reference.astParts();
            String typeName = ((TypeReferencePart)parts.last()).astIdentifier().astValue();
            if (IconDetector.NOTIFICATION_CLASS.equals(typeName)) {
                StrictListAccessor args = node.astArguments();
                if (args.size() == 3) {
                    String name;
                    if (args.first() instanceof Select && IconDetector.this.handleSelect((Select)args.first())) {
                        return super.visitConstructorInvocation(node);
                    }
                    Node method = StringFormatDetector.getParentMethod((Node)node);
                    if (method != null && (name = StringFormatDetector.getResourceForFirstArg(method, (Node)node)) != null) {
                        if (IconDetector.this.mNotificationIcons == null) {
                            IconDetector.this.mNotificationIcons = Sets.newHashSet();
                        }
                        IconDetector.this.mNotificationIcons.add(name);
                    }
                }
            } else if (IconDetector.BUILDER_CLASS.equals(typeName)) {
                Node method;
                String clz;
                boolean isBuilder = false;
                if (parts.size() == 1) {
                    isBuilder = true;
                } else if (parts.size() == 2 && (IconDetector.NOTIFICATION_CLASS.equals(clz = ((TypeReferencePart)parts.first()).astIdentifier().astValue()) || IconDetector.NOTIFICATION_COMPAT_CLASS.equals(clz))) {
                    isBuilder = true;
                }
                if (isBuilder && (method = StringFormatDetector.getParentMethod((Node)node)) != null) {
                    SetIconFinder finder = new SetIconFinder();
                    method.accept((AstVisitor)finder);
                }
            }
            return super.visitConstructorInvocation(node);
        }
    }
}

