/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;

public class MavenExecutionResult {
    private final MavenProject myMavenProject;
    private final List<Exception> myExceptions;
    private final DependencyResolutionResult myDependencyResolutionResult;

    public MavenExecutionResult(MavenProject mavenProject, List<Exception> exceptions) {
        this(mavenProject, null, exceptions);
    }

    public MavenExecutionResult(MavenProject mavenProject, DependencyResolutionResult dependencyResolutionResult, List<Exception> exceptions) {
        this.myMavenProject = mavenProject;
        this.myExceptions = exceptions == null ? new ArrayList() : exceptions;
        this.myDependencyResolutionResult = dependencyResolutionResult;
        if (this.myDependencyResolutionResult != null && this.myDependencyResolutionResult.getCollectionErrors() != null) {
            this.myExceptions.addAll(this.myDependencyResolutionResult.getCollectionErrors());
        }
    }

    public MavenProject getMavenProject() {
        return this.myMavenProject;
    }

    public DependencyResolutionResult getDependencyResolutionResult() {
        return this.myDependencyResolutionResult;
    }

    public List<Exception> getExceptions() {
        return this.myExceptions;
    }

    public boolean hasExceptions() {
        return !this.myExceptions.isEmpty();
    }
}

