/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlWriterUtil;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.idea.maven.server.Maven3ServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerProcessCanceledException;

public class MavenEffectivePomDumper {
    private static final String POM_XSD_URL = "http://maven.apache.org/maven-v4_0_0.xsd";
    private static final String SETTINGS_XSD_URL = "http://maven.apache.org/xsd/settings-1.0.0.xsd";

    public static String evaluateEffectivePom(final Maven3ServerEmbedder embedder, final File file, List<String> activeProfiles, List<String> inactiveProfiles) throws RemoteException, MavenServerProcessCanceledException {
        final StringWriter w = new StringWriter();
        try {
            final MavenExecutionRequest request = embedder.createRequest(file, activeProfiles, inactiveProfiles, Collections.<String>emptyList());
            embedder.executeWithMavenSession(request, new Runnable(){

                @Override
                public void run() {
                    try {
                        ProjectBuilder builder = embedder.getComponent(ProjectBuilder.class);
                        ProjectBuildingResult buildingResult = builder.build(new File(file.getPath()), request.getProjectBuildingRequest());
                        MavenProject project = buildingResult.getProject();
                        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, StringUtils.repeat((String)" ", (int)2));
                        MavenEffectivePomDumper.writeHeader((XMLWriter)writer);
                        MavenEffectivePomDumper.writeEffectivePom(project, (XMLWriter)writer);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            return null;
        }
        return w.toString();
    }

    private static void writeEffectivePom(MavenProject project, XMLWriter writer) throws MojoExecutionException {
        Model pom = project.getModel();
        MavenEffectivePomDumper.cleanModel(pom);
        StringWriter sWriter = new StringWriter();
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        try {
            pomWriter.write((Writer)sWriter, pom);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot serialize POM to XML.", (Exception)e);
        }
        String effectivePom = MavenEffectivePomDumper.addMavenNamespace(sWriter.toString(), true);
        MavenEffectivePomDumper.writeComment(writer, "Effective POM for project '" + project.getId() + "'");
        writer.writeMarkup(effectivePom);
    }

    private static void cleanModel(Model pom) {
        SortedProperties properties = new SortedProperties();
        properties.putAll((Map<?, ?>)pom.getProperties());
        pom.setProperties((Properties)properties);
    }

    protected static void writeHeader(XMLWriter writer) {
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)("Generated on " + dateFormat.format(new Date(System.currentTimeMillis()))));
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
    }

    protected static void writeComment(XMLWriter writer, String comment) {
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)comment);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
    }

    private static boolean hasLineBreak(Element e) {
        return !e.getChildren().isEmpty() || e.getText().contains("\n");
    }

    private static boolean isOneEOFText(String text) {
        int eof = text.indexOf(10);
        return eof != -1 && eof == text.lastIndexOf(10) && text.trim().isEmpty();
    }

    private static void addLineBreaks(Element element) {
        List children = element.getContent();
        for (int i = 0; i < children.size() - 2; ++i) {
            Content c1 = (Content)children.get(i);
            Content c2 = (Content)children.get(i + 1);
            Content c3 = (Content)children.get(i + 2);
            if (!(c1 instanceof Element) || !(c2 instanceof Text) || !(c3 instanceof Element) || !MavenEffectivePomDumper.hasLineBreak((Element)c1) && !MavenEffectivePomDumper.hasLineBreak((Element)c3) || !MavenEffectivePomDumper.isOneEOFText(((Text)c2).getText())) continue;
            element.setContent(i + 1, (Content)new Text(((Text)c2).getText().replace("\n", "\n\n")));
        }
    }

    private static void addLineBreaks(Document pomXml, Namespace pomNamespace) {
        Element rootElement = pomXml.getRootElement();
        MavenEffectivePomDumper.addLineBreaks(rootElement);
        Element buildElement = rootElement.getChild("build", pomNamespace);
        if (buildElement != null) {
            MavenEffectivePomDumper.addLineBreaks(buildElement);
        }
    }

    protected static String addMavenNamespace(String effectiveXml, boolean isPom) {
        SAXBuilder builder = new SAXBuilder();
        try {
            Document document = builder.build((Reader)new StringReader(effectiveXml));
            Element rootElement = document.getRootElement();
            Namespace pomNamespace = Namespace.getNamespace((String)"", (String)"http://maven.apache.org/POM/4.0.0");
            rootElement.setNamespace(pomNamespace);
            Namespace xsiNamespace = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
            rootElement.addNamespaceDeclaration(xsiNamespace);
            if (rootElement.getAttribute("schemaLocation", xsiNamespace) == null) {
                rootElement.setAttribute("schemaLocation", "http://maven.apache.org/POM/4.0.0 " + (isPom ? POM_XSD_URL : SETTINGS_XSD_URL), xsiNamespace);
            }
            ElementFilter elementFilter = new ElementFilter(Namespace.getNamespace((String)""));
            Iterator i = rootElement.getDescendants((Filter)elementFilter);
            while (i.hasNext()) {
                Element e = (Element)i.next();
                e.setNamespace(pomNamespace);
            }
            MavenEffectivePomDumper.addLineBreaks(document, pomNamespace);
            StringWriter w = new StringWriter();
            Format format = Format.getRawFormat();
            XMLOutputter out = new XMLOutputter(format);
            out.output(document.getRootElement(), (Writer)w);
            return w.toString();
        }
        catch (JDOMException e) {
            return effectiveXml;
        }
        catch (IOException e) {
            return effectiveXml;
        }
    }

    protected static class SortedProperties
    extends Properties {
        static final long serialVersionUID = -8985316072702233744L;

        protected SortedProperties() {
        }

        @Override
        public Set keySet() {
            Set<Object> keynames = super.keySet();
            Vector<Object> list = new Vector<Object>(keynames);
            Collections.sort(list);
            return new LinkedHashSet<Object>(list);
        }
    }
}

