/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.Dependency;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.ModuleLibrary;
import org.gradle.plugins.ide.idea.model.Path;
import org.gradle.util.GradleVersion;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ClasspathEntryModel;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.internal.BuildScriptClasspathModelImpl;
import org.jetbrains.plugins.gradle.tooling.internal.ClasspathEntryModelImpl;

public class ModelBuildScriptClasspathBuilderImpl
implements ModelBuilderService {
    private static final String COMPILE_SCOPE = "COMPILE";
    private static final String PLUS_CONFIGURATION = "plus";
    private static final String MINUS_CONFIGURATION = "minus";
    private static final String CLASSPATH_CONFIGURATION_NAME = "classpath";
    private final Map<String, BuildScriptClasspathModelImpl> cache = new ConcurrentHashMap<String, BuildScriptClasspathModelImpl>();

    public boolean canBuild(String modelName) {
        return BuildScriptClasspathModel.class.getName().equals(modelName);
    }

    public Object buildAll(String modelName, Project project) {
        BuildScriptClasspathModelImpl buildScriptClasspath = this.cache.get(project.getPath());
        if (buildScriptClasspath != null) {
            return buildScriptClasspath;
        }
        buildScriptClasspath = new BuildScriptClasspathModelImpl();
        File gradleHomeDir = project.getGradle().getGradleHomeDir();
        buildScriptClasspath.setGradleHomeDir(gradleHomeDir);
        buildScriptClasspath.setGradleVersion(GradleVersion.current().getVersion());
        IdeaPlugin ideaPlugin = (IdeaPlugin)project.getPlugins().getPlugin(IdeaPlugin.class);
        if (ideaPlugin != null) {
            Configuration configuration;
            Configuration classpathConfiguration;
            BuildScriptClasspathModelImpl parentBuildScriptClasspath;
            Project parent = project.getParent();
            if (parent != null && (parentBuildScriptClasspath = (BuildScriptClasspathModelImpl)this.buildAll(modelName, parent)) != null) {
                for (ClasspathEntryModel classpathEntryModel : parentBuildScriptClasspath.getClasspath()) {
                    buildScriptClasspath.add(classpathEntryModel);
                }
            }
            if ((classpathConfiguration = (Configuration)project.getBuildscript().getConfigurations().findByName(CLASSPATH_CONFIGURATION_NAME)) == null) {
                return null;
            }
            IdeaModule ideaModule = ideaPlugin.getModel().getModule();
            ConfigurationContainer configurations = ideaModule.getProject().getConfigurations();
            if (classpathConfiguration.getState() == Configuration.State.UNRESOLVED) {
                configuration = classpathConfiguration;
                configurations.add((Object)configuration);
            } else {
                String confName = project.getPath() + ":" + classpathConfiguration.getName();
                if (configurations.findByName(confName) != null) {
                    confName = confName + ":" + UUID.randomUUID().toString();
                }
                configuration = (Configuration)configurations.maybeCreate(confName);
                configuration.getDependencies().addAll((Collection)classpathConfiguration.getAllDependencies());
                configuration.getArtifacts().addAll((Collection)classpathConfiguration.getAllArtifacts());
            }
            RepositoryHandler buildscriptRepositories = project.getBuildscript().getRepositories();
            ArrayList projectRepositories = new ArrayList(project.getRepositories());
            project.getRepositories().clear();
            project.getRepositories().addAll((Collection)buildscriptRepositories);
            List<Configuration> plusConfigurations = Collections.singletonList(configuration);
            HashMap scopes = new HashMap(ideaModule.getScopes());
            HashMap buildScriptScope = new HashMap();
            HashMap<String, List<Object>> plusConfiguration = new HashMap<String, List<Object>>();
            plusConfiguration.put(PLUS_CONFIGURATION, plusConfigurations);
            if (scopes.get(COMPILE_SCOPE) != null) {
                plusConfiguration.put(MINUS_CONFIGURATION, (List<Object>)((Map)scopes.get(COMPILE_SCOPE)).get(PLUS_CONFIGURATION));
            }
            buildScriptScope.put(COMPILE_SCOPE, plusConfiguration);
            ideaModule.setScopes(buildScriptScope);
            Set buildScriptDependencies = ideaModule.resolveDependencies();
            for (Dependency dependency : buildScriptDependencies) {
                ModuleLibrary moduleLibrary;
                if (!(dependency instanceof ModuleLibrary) || !COMPILE_SCOPE.equals((moduleLibrary = (ModuleLibrary)dependency).getScope())) continue;
                buildScriptClasspath.add(new ClasspathEntryModelImpl(ModelBuildScriptClasspathBuilderImpl.convert(moduleLibrary.getClasses()), ModelBuildScriptClasspathBuilderImpl.convert(moduleLibrary.getSources()), ModelBuildScriptClasspathBuilderImpl.convert(moduleLibrary.getJavadoc())));
            }
            ideaModule.setScopes(scopes);
            configurations.remove((Object)configuration);
            project.getRepositories().clear();
            project.getRepositories().addAll(projectRepositories);
        }
        this.cache.put(project.getPath(), buildScriptClasspath);
        return buildScriptClasspath;
    }

    public ErrorMessageBuilder getErrorMessageBuilder(Project project, Exception e) {
        return ErrorMessageBuilder.create((Project)project, (Exception)e, (String)"Project build classpath resolve errors").withDescription("Unable to resolve additional buildscript classpath dependencies");
    }

    private static Set<String> convert(Set<Path> paths) {
        HashSet<String> result = new HashSet<String>(paths.size());
        for (Path path : paths) {
            result.add(path.getRelPath());
        }
        return result;
    }
}

