/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.plugincomponents;

import com.intellij.AppTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.messages.MessageBus;
import org.editorconfig.configmanagement.EditorSettingsManager;
import org.editorconfig.configmanagement.EncodingManager;
import org.editorconfig.configmanagement.LineEndingsManager;

public class ConfigProjectComponent
implements ProjectComponent {
    public ConfigProjectComponent(Project project, final EditorFactory editorFactory) {
        MessageBus bus = project.getMessageBus();
        EditorSettingsManager editorSettingsManager = new EditorSettingsManager(project);
        EncodingManager encodingManager = new EncodingManager(project);
        LineEndingsManager lineEndingsManager = new LineEndingsManager(project);
        bus.connect().subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)encodingManager);
        bus.connect().subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)editorSettingsManager);
        bus.connect().subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)lineEndingsManager);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void fileCreated(VirtualFileEvent event) {
                this.updateOpenEditors(event);
            }

            public void fileDeleted(VirtualFileEvent event) {
                this.updateOpenEditors(event);
            }

            public void contentsChanged(VirtualFileEvent event) {
                this.updateOpenEditors(event);
            }

            private void updateOpenEditors(VirtualFileEvent event) {
                if (".editorconfig".equals(event.getFile().getName())) {
                    for (Editor editor : editorFactory.getAllEditors()) {
                        ((EditorEx)editor).reinitSettings();
                    }
                }
            }
        }, (Disposable)project);
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public String getComponentName() {
        return "ConfigProjectComponent";
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }
}

