/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnGetInfo;
import org.tmatesoft.svn.core.wc2.SvnInfo;
import org.tmatesoft.svn.core.wc2.SvnSchedule;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.SvnWorkingCopyInfo;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgGetInfo
extends SvnNgOperationRunner<SvnInfo, SvnGetInfo>
implements SVNWCContext.ISVNWCNodeHandler {
    private boolean hasRootTreeConflict;
    private boolean isFirstInfo;
    private Map<File, SVNTreeConflictDescription> treeConflicts;

    @Override
    public void reset(SvnWcGeneration wcGeneration) {
        super.reset(wcGeneration);
        this.hasRootTreeConflict = false;
        this.isFirstInfo = false;
        this.treeConflicts = null;
    }

    @Override
    protected SvnInfo run(SVNWCContext context) throws SVNException {
        block7: {
            SVNTreeConflictDescription treeConflict;
            this.hasRootTreeConflict = false;
            this.isFirstInfo = true;
            this.getTreeConflicts().clear();
            if (((SvnGetInfo)this.getOperation()).isFetchActualOnly() && (treeConflict = context.getDb().opReadTreeConflict(this.getFirstTarget())) != null) {
                this.hasRootTreeConflict = true;
                this.getTreeConflicts().put(this.getFirstTarget(), treeConflict);
            }
            try {
                context.nodeWalkChildren(this.getFirstTarget(), this, ((SvnGetInfo)this.getOperation()).isFetchExcluded(), ((SvnGetInfo)this.getOperation()).getDepth(), ((SvnGetInfo)this.getOperation()).getApplicableChangelists());
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND && this.hasRootTreeConflict) break block7;
                throw e;
            }
        }
        SVNWCContext.SVNWCNodeReposInfo reposInfo = null;
        if (!this.getTreeConflicts().isEmpty()) {
            reposInfo = this.getWcContext().getNodeReposInfo(this.getFirstTarget());
            if (reposInfo.reposRootUrl == null) {
                reposInfo = null;
            }
        }
        for (File target : this.getTreeConflicts().keySet()) {
            SVNTreeConflictDescription treeConflict = this.getTreeConflicts().get(target);
            if (!this.isDepthIncludes(this.getFirstTarget(), ((SvnGetInfo)this.getOperation()).getDepth(), target, treeConflict.getNodeKind())) continue;
            SvnInfo unversionedInfo = this.buildUnversionedInfo(target);
            ArrayList<SVNConflictDescription> conflicts = new ArrayList<SVNConflictDescription>(1);
            conflicts.add(treeConflict);
            unversionedInfo.getWcInfo().setConflicts(conflicts);
            if (reposInfo != null) {
                unversionedInfo.setRepositoryRootURL(reposInfo.reposRootUrl);
                unversionedInfo.setRepositoryUuid(reposInfo.reposUuid);
            }
            ((SvnGetInfo)this.getOperation()).receive(SvnTarget.fromFile(target), unversionedInfo);
        }
        return (SvnInfo)((SvnGetInfo)this.getOperation()).first();
    }

    @Override
    public void nodeFound(File localAbspath, ISVNWCDb.SVNWCDbKind kind) throws SVNException {
        SvnInfo info = this.buildInfo(localAbspath, kind);
        if (info == null && this.isFirstInfo) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found", (Object)localAbspath), SVNLogType.WC);
        }
        this.isFirstInfo = false;
        if (info != null) {
            ((SvnGetInfo)this.getOperation()).receive(SvnTarget.fromFile(localAbspath), info);
        }
        if (((SvnGetInfo)this.getOperation()).isFetchActualOnly() && kind == ISVNWCDb.SVNWCDbKind.Dir) {
            Map<String, SVNTreeConflictDescription> treeConflicts = this.getWcContext().getDb().opReadAllTreeConflicts(localAbspath);
            for (String name : treeConflicts.keySet()) {
                this.getTreeConflicts().put(SVNFileUtil.createFilePath(localAbspath, name), treeConflicts.get(name));
            }
        }
        this.getTreeConflicts().remove(localAbspath);
    }

    private SvnInfo buildUnversionedInfo(File localAbspath) throws SVNException {
        SvnWorkingCopyInfo wcInfo = new SvnWorkingCopyInfo();
        wcInfo.setPath(localAbspath);
        SvnInfo info = new SvnInfo();
        info.setWcInfo(wcInfo);
        info.setRevision(-1L);
        info.setLastChangedRevision(-1L);
        info.setSize(-1L);
        info.setLastChangedDate(SVNDate.NULL);
        info.setKind(SVNNodeKind.NONE);
        wcInfo.setDepth(SVNDepth.UNKNOWN);
        wcInfo.setRecordedSize(-1L);
        wcInfo.setCopyFromRevision(-1L);
        wcInfo.setSchedule(SvnSchedule.NORMAL);
        return info;
    }

    private SvnInfo buildInfo(File localAbspath, ISVNWCDb.SVNWCDbKind kind) throws SVNException {
        SvnInfo info = new SvnInfo();
        SvnWorkingCopyInfo wcInfo = new SvnWorkingCopyInfo();
        wcInfo.setPath(localAbspath);
        info.setWcInfo(wcInfo);
        info.setKind(kind.toNodeKind());
        wcInfo.setCopyFromRevision(-1L);
        ISVNWCDb.WCDbInfo readInfo = this.getWcContext().getDb().readInfo(localAbspath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind, ISVNWCDb.WCDbInfo.InfoField.revision, ISVNWCDb.WCDbInfo.InfoField.reposRelPath, ISVNWCDb.WCDbInfo.InfoField.reposRootUrl, ISVNWCDb.WCDbInfo.InfoField.reposUuid, ISVNWCDb.WCDbInfo.InfoField.changedRev, ISVNWCDb.WCDbInfo.InfoField.changedDate, ISVNWCDb.WCDbInfo.InfoField.changedAuthor, ISVNWCDb.WCDbInfo.InfoField.depth, ISVNWCDb.WCDbInfo.InfoField.checksum, ISVNWCDb.WCDbInfo.InfoField.originalReposRelpath, ISVNWCDb.WCDbInfo.InfoField.originalRootUrl, ISVNWCDb.WCDbInfo.InfoField.originalUuid, ISVNWCDb.WCDbInfo.InfoField.originalRevision, ISVNWCDb.WCDbInfo.InfoField.lock, ISVNWCDb.WCDbInfo.InfoField.translatedSize, ISVNWCDb.WCDbInfo.InfoField.lastModTime, ISVNWCDb.WCDbInfo.InfoField.changelist, ISVNWCDb.WCDbInfo.InfoField.conflicted, ISVNWCDb.WCDbInfo.InfoField.opRoot, ISVNWCDb.WCDbInfo.InfoField.haveBase);
        info.setRevision(readInfo.revision);
        info.setRepositoryRootURL(readInfo.reposRootUrl);
        info.setRepositoryUuid(readInfo.reposUuid);
        info.setLastChangedDate(readInfo.changedDate);
        info.setLastChangedAuthor(readInfo.changedAuthor);
        info.setLastChangedRevision(readInfo.changedRev);
        wcInfo.setDepth(readInfo.depth);
        wcInfo.setChecksum(readInfo.checksum);
        wcInfo.setRecordedSize(readInfo.translatedSize);
        wcInfo.setRecordedTime(readInfo.lastModTime);
        wcInfo.setChangelist(readInfo.changelist);
        File reposRelPath = readInfo.reposRelPath;
        if (readInfo.originalRootUrl != null) {
            info.setRepositoryRootURL(readInfo.originalRootUrl);
            info.setRepositoryUuid(readInfo.originalUuid);
        }
        if (readInfo.status == ISVNWCDb.SVNWCDbStatus.Added) {
            if (readInfo.originalReposRelpath != null) {
                info.setRevision(readInfo.originalRevision);
                reposRelPath = readInfo.originalReposRelpath;
                if (readInfo.opRoot) {
                    wcInfo.setCopyFromUrl(SVNWCUtils.join(info.getRepositoryRootUrl(), readInfo.originalReposRelpath));
                    wcInfo.setCopyFromRevision(readInfo.originalRevision);
                }
            } else if (readInfo.opRoot) {
                Structure<StructureFields.AdditionInfo> additionInfo = SvnWcDbShared.scanAddition((SVNWCDb)this.getWcContext().getDb(), localAbspath);
                info.setRepositoryRootURL((SVNURL)additionInfo.get(StructureFields.AdditionInfo.reposRootUrl));
                info.setRepositoryUuid((String)additionInfo.get(StructureFields.AdditionInfo.reposUuid));
                if (readInfo.haveBase) {
                    long baseRev = this.getWcContext().getDb().getBaseInfo((File)localAbspath, (ISVNWCDb.WCDbBaseInfo.BaseInfoField[])new ISVNWCDb.WCDbBaseInfo.BaseInfoField[]{ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision}).revision;
                    info.setRevision(baseRev);
                }
                additionInfo.release();
            } else {
                Structure<StructureFields.NodeOriginInfo> nodeOrigin = this.getWcContext().getNodeOrigin(localAbspath, true, new StructureFields.NodeOriginInfo[0]);
                info.setRepositoryRootURL((SVNURL)nodeOrigin.get(StructureFields.NodeOriginInfo.reposRootUrl));
                info.setRepositoryUuid(nodeOrigin.text(StructureFields.NodeOriginInfo.reposUuid));
                info.setRevision(nodeOrigin.lng(StructureFields.NodeOriginInfo.revision));
                nodeOrigin.release();
            }
            SVNWCContext.ScheduleInternalInfo scheduleInfo = this.getWcContext().getNodeScheduleInternal(localAbspath, true, false);
            wcInfo.setSchedule(this.toSchedule(scheduleInfo.schedule));
            info.setUrl(this.getWcContext().getNodeUrl(localAbspath));
        } else if (readInfo.status == ISVNWCDb.SVNWCDbStatus.Deleted) {
            Structure<StructureFields.PristineInfo> pristineInfo = this.getWcContext().getDb().readPristineInfo(localAbspath);
            info.setLastChangedRevision(pristineInfo.lng(StructureFields.PristineInfo.changed_rev));
            info.setLastChangedDate((SVNDate)pristineInfo.get(StructureFields.PristineInfo.changed_date));
            info.setLastChangedAuthor(pristineInfo.text(StructureFields.PristineInfo.changed_author));
            wcInfo.setDepth((SVNDepth)pristineInfo.get(StructureFields.PristineInfo.depth));
            wcInfo.setChecksum((SvnChecksum)pristineInfo.get(StructureFields.PristineInfo.checksum));
            pristineInfo.release();
            Structure<StructureFields.DeletionInfo> delInfo = SvnWcDbShared.scanDeletion((SVNWCDb)this.getWcContext().getDb(), localAbspath);
            File workDelAbsPath = (File)delInfo.get(StructureFields.DeletionInfo.workDelAbsPath);
            delInfo.release();
            if (workDelAbsPath != null) {
                File addedAbsPath = SVNFileUtil.getFileDir(workDelAbsPath);
                Structure<StructureFields.AdditionInfo> additionInfo = SvnWcDbShared.scanAddition((SVNWCDb)this.getWcContext().getDb(), addedAbsPath);
                reposRelPath = (File)additionInfo.get(StructureFields.AdditionInfo.reposRelPath);
                info.setRepositoryRootURL((SVNURL)additionInfo.get(StructureFields.AdditionInfo.reposRootUrl));
                info.setRepositoryUuid((String)additionInfo.get(StructureFields.AdditionInfo.reposUuid));
                info.setRevision(additionInfo.lng(StructureFields.AdditionInfo.originalRevision));
                additionInfo.release();
                File p = SVNFileUtil.createFilePath(reposRelPath, SVNWCUtils.skipAncestor(addedAbsPath, localAbspath));
                info.setUrl(SVNWCUtils.join(info.getRepositoryRootUrl(), p));
            } else {
                ISVNWCDb.WCDbBaseInfo baseInfo = this.getWcContext().getDb().getBaseInfo(localAbspath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposUuid);
                reposRelPath = baseInfo.reposRelPath;
                info.setRevision(baseInfo.revision);
                info.setRepositoryRootURL(baseInfo.reposRootUrl);
                info.setRepositoryUuid(baseInfo.reposUuid);
                info.setUrl(SVNWCUtils.join(info.getRepositoryRootUrl(), reposRelPath));
            }
            wcInfo.setSchedule(SvnSchedule.DELETE);
        } else {
            if (readInfo.status == ISVNWCDb.SVNWCDbStatus.NotPresent || readInfo.status == ISVNWCDb.SVNWCDbStatus.ServerExcluded) {
                return null;
            }
            if (info.getRepositoryRootUrl() != null) {
                if (reposRelPath != null) {
                    info.setUrl(SVNWCUtils.join(info.getRepositoryRootUrl(), reposRelPath));
                } else {
                    info.setUrl(info.getRepositoryRootUrl());
                }
            }
            wcInfo.setSchedule(SvnSchedule.NORMAL);
        }
        if (readInfo.status == ISVNWCDb.SVNWCDbStatus.Excluded) {
            wcInfo.setDepth(SVNDepth.EXCLUDE);
        }
        info.setSize(-1L);
        wcInfo.setWcRoot(this.getWcContext().getDb().getWCRoot(localAbspath));
        if (readInfo.conflicted) {
            wcInfo.setConflicts(this.getWcContext().getDb().readConflicts(localAbspath));
        }
        if (readInfo.lock != null) {
            SVNLock lock = new SVNLock(null, readInfo.lock.token, readInfo.lock.owner, readInfo.lock.comment, readInfo.lock.date, null);
            info.setLock(lock);
        }
        return info;
    }

    private SvnSchedule toSchedule(SVNWCContext.SVNWCSchedule schedule) {
        if (schedule == SVNWCContext.SVNWCSchedule.add) {
            return SvnSchedule.ADD;
        }
        if (schedule == SVNWCContext.SVNWCSchedule.delete) {
            return SvnSchedule.DELETE;
        }
        if (schedule == SVNWCContext.SVNWCSchedule.normal) {
            return SvnSchedule.NORMAL;
        }
        if (schedule == SVNWCContext.SVNWCSchedule.replace) {
            return SvnSchedule.REPLACE;
        }
        return null;
    }

    private boolean isDepthIncludes(File rootPath, SVNDepth depth, File childPath, SVNNodeKind childKind) {
        if (depth == SVNDepth.INFINITY) {
            return true;
        }
        File childParentPath = SVNFileUtil.getParentFile(childPath);
        if (depth == SVNDepth.IMMEDIATES) {
            return rootPath.equals(childParentPath);
        }
        if (depth == SVNDepth.FILES) {
            return childKind == SVNNodeKind.FILE && rootPath.equals(childParentPath);
        }
        return rootPath.equals(childPath);
    }

    private Map<File, SVNTreeConflictDescription> getTreeConflicts() {
        if (this.treeConflicts == null) {
            this.treeConflicts = new HashMap<File, SVNTreeConflictDescription>();
        }
        return this.treeConflicts;
    }
}

