/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.util.containers.ContainerUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class CloudGitDeploymentDetector {
    public static final ExtensionPointName<CloudGitDeploymentDetector> EP_NAME = ExtensionPointName.create((String)"com.intellij.remoteServer.util.deploymentDetector");
    private final Pattern myGitUrlPattern;

    public static CloudGitDeploymentDetector getInstance(ServerType cloudType) {
        for (CloudGitDeploymentDetector deploymentDetector : (CloudGitDeploymentDetector[])EP_NAME.getExtensions()) {
            if (deploymentDetector.getCloudType() != cloudType) continue;
            return deploymentDetector;
        }
        throw new IllegalArgumentException("Deployment detector is not registered for: " + cloudType.getPresentableName());
    }

    protected CloudGitDeploymentDetector(Pattern gitUrlPattern) {
        this.myGitUrlPattern = gitUrlPattern;
    }

    public String getFirstApplicationName(GitRepository repository) {
        return (String)ContainerUtil.getFirstItem(this.collectApplicationNames(repository));
    }

    public List<String> collectApplicationNames(GitRepository repository) {
        ArrayList<String> result = new ArrayList<String>();
        for (GitRemote remote : repository.getRemotes()) {
            for (String url : remote.getUrls()) {
                Matcher matcher = this.myGitUrlPattern.matcher(url);
                if (!matcher.matches()) continue;
                result.add(matcher.group(1));
            }
        }
        return result;
    }

    public abstract ServerType getCloudType();

    public abstract CloudDeploymentNameConfiguration createDeploymentConfiguration();
}

