/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileProcessor;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertyCreationHandler;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashSet;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class JavaI18nUtil
extends I18nUtil {
    public static final PropertyCreationHandler DEFAULT_PROPERTY_CREATION_HANDLER = new PropertyCreationHandler(){

        @Override
        public void createProperty(Project project, Collection<PropertiesFile> propertiesFiles, String key, String value, PsiExpression[] parameters) throws IncorrectOperationException {
            JavaI18nUtil.createProperty((Project)project, propertiesFiles, (String)key, (String)value);
        }
    };
    private static final Key<ParameterizedCachedValue<PsiExpression, Pair<Project, PsiExpression>>> TOP_LEVEL_EXPRESSION = Key.create((String)"TOP_LEVEL_EXPRESSION");
    private static final ParameterizedCachedValueProvider<PsiExpression, Pair<Project, PsiExpression>> TOP_LEVEL_PROVIDER = new ParameterizedCachedValueProvider<PsiExpression, Pair<Project, PsiExpression>>(){

        public CachedValueProvider.Result<PsiExpression> compute(Pair<Project, PsiExpression> pair) {
            PsiExpression param = (PsiExpression)pair.second;
            Project project = (Project)pair.first;
            PsiExpression topLevel = JavaI18nUtil.getTopLevel(project, param);
            ParameterizedCachedValue cachedValue = (ParameterizedCachedValue)param.getUserData(TOP_LEVEL_EXPRESSION);
            assert (cachedValue != null);
            int i = 0;
            PsiExpression element = param;
            while (element != topLevel) {
                if (i % 10 == 0) {
                    element.putUserData(TOP_LEVEL_EXPRESSION, (Object)cachedValue);
                }
                element = element.getParent();
                ++i;
            }
            return CachedValueProvider.Result.create((Object)topLevel, (Object[])new Object[]{PsiManager.getInstance((Project)project).getModificationTracker()});
        }
    };

    private JavaI18nUtil() {
    }

    public static TextRange getSelectedRange(Editor editor, PsiFile psiFile) {
        if (editor == null) {
            return null;
        }
        String selectedText = editor.getSelectionModel().getSelectedText();
        if (selectedText != null) {
            return new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd());
        }
        PsiElement psiElement = psiFile.findElementAt(editor.getCaretModel().getOffset());
        if (psiElement == null || psiElement instanceof PsiWhiteSpace) {
            return null;
        }
        return psiElement.getTextRange();
    }

    public static boolean mustBePropertyKey(Project project, PsiExpression expression, Map<String, Object> annotationAttributeValues) {
        PsiAnnotation annotation;
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiVariable && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiVariable)parent), (String[])new String[]{"org.jetbrains.annotations.PropertyKey"})) != null) {
            return JavaI18nUtil.processAnnotationAttributes(annotationAttributeValues, annotation);
        }
        return JavaI18nUtil.isPassedToAnnotatedParam(project, expression, "org.jetbrains.annotations.PropertyKey", annotationAttributeValues, null);
    }

    public static boolean isPassedToAnnotatedParam(Project project, PsiExpression expression, String annFqn, Map<String, Object> annotationAttributeValues, Set<PsiModifierListOwner> nonNlsTargets) {
        PsiMethod method;
        PsiElement parent = (expression = JavaI18nUtil.getToplevelExpression(project, expression)).getParent();
        if (!(parent instanceof PsiExpressionList)) {
            return false;
        }
        int idx = -1;
        PsiExpression[] args = ((PsiExpressionList)parent).getExpressions();
        for (int i = 0; i < args.length; ++i) {
            PsiExpression arg = args[i];
            if (!PsiTreeUtil.isAncestor((PsiElement)arg, (PsiElement)expression, (boolean)false)) continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            return false;
        }
        PsiElement grParent = parent.getParent();
        if (grParent instanceof PsiAnonymousClass) {
            grParent = grParent.getParent();
        }
        return grParent instanceof PsiCall && (method = ((PsiCall)grParent).resolveMethod()) != null && JavaI18nUtil.isMethodParameterAnnotatedWith(method, idx, null, annFqn, annotationAttributeValues, nonNlsTargets);
    }

    public static PsiExpression getToplevelExpression(Project project, PsiExpression expression) {
        if (expression instanceof PsiBinaryExpression || expression.getParent() instanceof PsiBinaryExpression) {
            return (PsiExpression)CachedValuesManager.getManager((Project)project).getParameterizedCachedValue((UserDataHolder)expression, TOP_LEVEL_EXPRESSION, TOP_LEVEL_PROVIDER, true, (Object)Pair.create((Object)project, (Object)expression));
        }
        return JavaI18nUtil.getTopLevel(project, expression);
    }

    private static PsiExpression getTopLevel(Project project, PsiExpression expression) {
        int i = 0;
        while (expression.getParent() instanceof PsiExpression) {
            ParameterizedCachedValue value;
            ++i;
            PsiExpression parent = (PsiExpression)expression.getParent();
            if (parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() == expression || (expression = parent) instanceof PsiAssignmentExpression) break;
            if (i <= 10 || !(expression instanceof PsiBinaryExpression) || (value = (ParameterizedCachedValue)expression.getUserData(TOP_LEVEL_EXPRESSION)) == null || !value.hasUpToDateValue()) continue;
            return JavaI18nUtil.getToplevelExpression(project, expression);
        }
        return expression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isMethodParameterAnnotatedWith(PsiMethod method, int idx, Collection<PsiMethod> processed, String annFqn, Map<String, Object> annotationAttributeValues, Set<PsiModifierListOwner> nonNlsTargets) {
        PsiMethod[] superMethods;
        PsiAnnotation annotation;
        PsiParameter param;
        if (processed != null) {
            if (processed.contains(method)) {
                return false;
            }
        } else {
            processed = new THashSet();
        }
        processed.add(method);
        PsiParameter[] params = method.getParameterList().getParameters();
        if (idx >= params.length) {
            if (params.length == 0) {
                return false;
            }
            PsiParameter lastParam = params[params.length - 1];
            if (!lastParam.isVarArgs()) return false;
            param = lastParam;
        } else {
            param = params[idx];
        }
        if ((annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)param, (String[])new String[]{annFqn})) != null) {
            return JavaI18nUtil.processAnnotationAttributes(annotationAttributeValues, annotation);
        }
        if (nonNlsTargets != null) {
            nonNlsTargets.add((PsiModifierListOwner)param);
        }
        for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
            if (!JavaI18nUtil.isMethodParameterAnnotatedWith(superMethod, idx, (Collection<PsiMethod>)processed, annFqn, annotationAttributeValues, null)) continue;
            return true;
        }
        return false;
    }

    private static boolean processAnnotationAttributes(Map<String, Object> annotationAttributeValues, PsiAnnotation annotation) {
        if (annotationAttributeValues != null) {
            PsiNameValuePair[] attributes;
            PsiAnnotationParameterList parameterList = annotation.getParameterList();
            for (PsiNameValuePair attribute : attributes = parameterList.getAttributes()) {
                String name = attribute.getName();
                if (!annotationAttributeValues.containsKey(name)) continue;
                annotationAttributeValues.put(name, attribute.getValue());
            }
        }
        return true;
    }

    public static boolean isValidPropertyReference(Project project, PsiExpression expression, String key, Ref<String> outResourceBundle) {
        HashMap annotationAttributeValues = new HashMap();
        annotationAttributeValues.put((Object)"resourceBundle", null);
        if (JavaI18nUtil.mustBePropertyKey(project, expression, (Map<String, Object>)annotationAttributeValues)) {
            Object resourceBundleName = annotationAttributeValues.get((Object)"resourceBundle");
            if (!(resourceBundleName instanceof PsiExpression)) {
                return false;
            }
            PsiExpression expr = (PsiExpression)resourceBundleName;
            PsiConstantEvaluationHelper constantEvaluationHelper = JavaPsiFacade.getInstance((Project)project).getConstantEvaluationHelper();
            Object value = constantEvaluationHelper.computeConstantExpression((PsiElement)expr);
            if (value == null) {
                PsiElement resolve;
                if (expr instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)expr).resolve()) instanceof PsiField && ((PsiField)resolve).hasModifierProperty("final") && (value = constantEvaluationHelper.computeConstantExpression((PsiElement)((PsiField)resolve).getInitializer())) == null) {
                    return false;
                }
                if (value == null) {
                    ResourceBundle resourceBundle = JavaI18nUtil.resolveResourceBundleByKey(key, project);
                    if (resourceBundle == null) {
                        return false;
                    }
                    PropertiesFile defaultPropertiesFile = resourceBundle.getDefaultPropertiesFile();
                    String bundleName = BundleNameEvaluator.DEFAULT.evaluateBundleName(defaultPropertiesFile.getContainingFile());
                    if (bundleName == null) {
                        return false;
                    }
                    value = bundleName;
                }
            }
            String bundleName = value.toString();
            outResourceBundle.set((Object)bundleName);
            return JavaI18nUtil.isPropertyRef(expression, key, bundleName);
        }
        return true;
    }

    public static ResourceBundle resolveResourceBundleByKey(final String key, Project project) {
        final Ref bundleRef = Ref.create();
        boolean r = PropertiesReferenceManager.getInstance((Project)project).processAllPropertiesFiles(new PropertiesFileProcessor(){

            public boolean process(String baseName, PropertiesFile propertiesFile) {
                if (propertiesFile.findPropertyByKey(key) != null) {
                    if (bundleRef.get() == null) {
                        bundleRef.set((Object)propertiesFile.getResourceBundle());
                    } else if (!((ResourceBundle)bundleRef.get()).equals(propertiesFile.getResourceBundle())) {
                        return false;
                    }
                }
                return true;
            }
        });
        return r ? (ResourceBundle)bundleRef.get() : null;
    }

    public static boolean isPropertyRef(PsiExpression expression, String key, String resourceBundleName) {
        if (resourceBundleName == null) {
            return !PropertiesImplUtil.findPropertiesByKey((Project)expression.getProject(), (String)key).isEmpty();
        }
        List propertiesFiles = JavaI18nUtil.propertiesFilesByBundleName((String)resourceBundleName, (PsiElement)expression);
        boolean containedInPropertiesFile = false;
        for (PropertiesFile propertiesFile : propertiesFiles) {
            containedInPropertiesFile |= propertiesFile.findPropertyByKey(key) != null;
        }
        return containedInPropertiesFile;
    }

    public static Set<String> suggestExpressionOfType(PsiClassType type, PsiLiteralExpression context) {
        PsiExpression[] expressions;
        PsiVariable[] variables = MacroUtil.getVariablesVisibleAt((PsiElement)context, (String)"");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (PsiVariable var : variables) {
            PsiType varType = var.getType();
            if (type != null && !type.isAssignableFrom(varType)) continue;
            result.add(var.getNameIdentifier().getText());
        }
        for (PsiExpression expression : expressions = MacroUtil.getStandardExpressionsOfType((PsiElement)context, (PsiType)type)) {
            result.add(expression.getText());
        }
        if (type != null) {
            JavaI18nUtil.addAvailableMethodsOfType(type, context, result);
        }
        return result;
    }

    private static void addAvailableMethodsOfType(final PsiClassType type, PsiLiteralExpression context, final Collection<String> result) {
        PsiScopesUtil.treeWalkUp((PsiScopeProcessor)new PsiScopeProcessor(){

            public boolean execute(PsiElement element, ResolveState state) {
                PsiMethod method;
                PsiType returnType;
                if (element instanceof PsiMethod && (returnType = (method = (PsiMethod)element).getReturnType()) != null && TypeConversionUtil.isAssignable((PsiType)type, (PsiType)returnType) && method.getParameterList().getParametersCount() == 0) {
                    result.add(method.getName() + "()");
                }
                return true;
            }

            public <T> T getHint(Key<T> hintKey) {
                return null;
            }

            public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
            }
        }, (PsiElement)context, null);
    }

    public static int getPropertyValuePlaceholdersCount(String propertyValue) {
        try {
            return new MessageFormat(propertyValue).getFormatsByArgumentIndex().length;
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
    }

    public static int getPropertyValueParamsMaxCount(PsiExpression expression) {
        return JavaI18nUtil.getPropertyValueParamsMaxCount(expression, null);
    }

    public static int getPropertyValueParamsMaxCount(PsiExpression expression, String resourceBundleName) {
        SortedSet<Integer> paramsCount = JavaI18nUtil.getPropertyValueParamsCount(expression, resourceBundleName);
        if (paramsCount.isEmpty()) {
            return -1;
        }
        return paramsCount.last();
    }

    public static SortedSet<Integer> getPropertyValueParamsCount(PsiExpression expression, String resourceBundleName) {
        PsiLiteralExpression literalExpression;
        if (expression instanceof PsiLiteralExpression) {
            literalExpression = (PsiLiteralExpression)expression;
        } else if (expression instanceof PsiReferenceExpression) {
            PsiElement resolved = ((PsiReferenceExpression)expression).resolve();
            PsiField field = resolved == null ? null : (PsiField)resolved;
            literalExpression = field != null && field.hasModifierProperty("final") && field.getInitializer() instanceof PsiLiteralExpression ? (PsiLiteralExpression)field.getInitializer() : null;
        } else {
            literalExpression = null;
        }
        TreeSet<Integer> paramsCount = new TreeSet<Integer>();
        if (literalExpression == null) {
            return paramsCount;
        }
        for (PsiReference reference : literalExpression.getReferences()) {
            if (!(reference instanceof PsiPolyVariantReference)) continue;
            for (ResolveResult result : ((PsiPolyVariantReference)reference).multiResolve(false)) {
                if (!result.isValidResult() || !(result.getElement() instanceof IProperty)) continue;
                try {
                    String propertyValue;
                    PsiFile file;
                    IProperty property = (IProperty)result.getElement();
                    if (resourceBundleName != null && !resourceBundleName.equals(BundleNameEvaluator.DEFAULT.evaluateBundleName(file = property.getPropertiesFile().getContainingFile())) || (propertyValue = property.getValue()) == null) continue;
                    paramsCount.add(JavaI18nUtil.getPropertyValuePlaceholdersCount(propertyValue));
                }
                catch (IllegalArgumentException ignored) {
                    // empty catch block
                }
            }
        }
        return paramsCount;
    }
}

